/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.simba.services.common.utils.spring.SpringUtils;
import com.simba.services.service.IStatusTranslator;
import com.simba.services.service.translator.AbstractStatusTranslator;
import com.simba.services.service.translator.StatusTranslator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class StatusTranslatorHelper {
    private static final Logger log = LoggerFactory.getLogger(StatusTranslatorHelper.class);
    private Map<String, IStatusTranslator> translators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatusTranslator getTranslator(String deviceType) {
        if (this.translators == null) {
            StatusTranslatorHelper statusTranslatorHelper = this;
            synchronized (statusTranslatorHelper) {
                if (this.translators == null) {
                    this.loadTranslators();
                }
            }
        }
        if (StringUtils.isEmpty((Object)deviceType)) {
            log.error("\u72b6\u6001\u7c7b\u578b\u4e3a\u7a7a\u3002");
            return IStatusTranslator.DEFAULT;
        }
        return this.translators.getOrDefault(deviceType, IStatusTranslator.DEFAULT);
    }

    private void loadTranslators() {
        this.translators = new HashMap();
        try {
            Map beans = SpringUtils.getBeansWithAnnotation(StatusTranslator.class);
            if (beans.isEmpty()) {
                log.error("\u672a\u627e\u5230\u4efb\u4f55\u7ffb\u8bd1\u5668\u3002");
                return;
            }
            log.info("\u7ffb\u8bd1\u5668\u6570\u91cf: {}\u3002", (Object)beans.size());
            beans.forEach((key, value) -> {
                if (value instanceof AbstractStatusTranslator) {
                    AbstractStatusTranslator translator = (AbstractStatusTranslator)value;
                    String deviceType = translator.getDeviceType();
                    if (deviceType == null || deviceType.isEmpty()) {
                        log.warn("\u7ffb\u8bd1\u5668 {} \u7684\u8bbe\u5907\u7c7b\u578b\u4e3a\u7a7a\uff0c\u5df2\u8df3\u8fc7\u6ce8\u518c\u3002", key);
                        return;
                    }
                    log.info("\u6ce8\u518c\u7ffb\u8bd1\u5668: {} -> {}", key, (Object)deviceType);
                    this.translators.put(deviceType, translator);
                } else {
                    log.error("\u7ffb\u8bd1\u5668 {} \u4e0d\u662f AbstractStatusTranslator \u7684\u5b9e\u4f8b\uff0c\u5df2\u8df3\u8fc7\u6ce8\u518c\u3002", key);
                }
            });
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u7ffb\u8bd1\u5668\u5931\u8d25", (Throwable)e);
            this.translators = new HashMap();
        }
    }
}

