/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.simba.services.bean.domain.BasicConfig;
import com.simba.services.bean.domain.DeviceConfig;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.domain.UploadData;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.bean.model.InnerState;
import com.simba.services.bean.model.SorterDeviceInfo;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.common.utils.uuid.UUID;
import com.simba.services.config.WinccConfig;
import com.simba.services.enums.RequestType;
import com.simba.services.enums.UploadDataStatus;
import com.simba.services.helper.DatabaseHelper;
import com.simba.services.helper.DeviceHelper;
import com.simba.services.helper.DeviceStatusHelper;
import com.simba.services.helper.MachineHelper;
import com.simba.services.helper.StatusTranslatorHelper;
import com.simba.services.helper.UploadDataHelper;
import com.simba.services.message.sorter.CarrierStatus;
import com.simba.services.message.sorter.ElectricMotorStatus;
import com.simba.services.message.sorter.GridPosStatus;
import com.simba.services.message.sorter.HeartBreak;
import com.simba.services.message.sorter.InductStatus;
import com.simba.services.message.sorter.PlcStatus;
import com.simba.services.message.sorter.StatusArrWithNum;
import com.simba.services.service.BasicConfigService;
import com.simba.services.service.IStatusTranslator;
import com.simba.services.service.UploadDataService;
import com.simba.services.service.translator.FaultInfo;
import com.simba.services.upload.status.CarrierMsg;
import com.simba.services.upload.status.DeviceStatus;
import com.simba.services.upload.status.DynamicScaleMsg;
import com.simba.services.upload.status.ElectricMotorMsg;
import com.simba.services.upload.status.GrayscaleMsg;
import com.simba.services.upload.status.InductMsg;
import com.simba.services.upload.status.ObrMsg;
import com.simba.services.upload.status.PhysicalPosMsg;
import com.simba.services.upload.status.SorterMsg;
import com.simba.services.util.TokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SorterDeviceStatusHelper {
    private static final Logger log = LoggerFactory.getLogger(SorterDeviceStatusHelper.class);
    @Resource
    private WinccConfig.WorkshopConfig workshopConfig;
    @Resource
    private WinccConfig.ManufacturerConfig manufacturerConfig;
    @Resource
    private WinccConfig.DeviceStatusUploadConfig uploadConfig;
    @Resource
    private UploadDataService uploadDataService;
    @Resource
    private UploadDataHelper uploadDataHelper;
    @Resource
    private DatabaseHelper databaseHelper;
    @Resource
    private MachineHelper machineHelper;
    @Resource
    private DeviceHelper deviceHelper;
    @Resource
    private DeviceInfoManager deviceInfoManager;
    @Resource
    private StatusTranslatorHelper statusTranslatorHelper;
    @Resource
    private DeviceStatusHelper deviceStatusHelper;
    @Resource
    private BasicConfigService basicConfigService;

    public void createDeviceStatusUploadData(MachineConfig machine) {
        UploadData uploadData;
        log.debug("\u51c6\u5907\u751f\u6210\u4ea4\u53c9\u5e26\u5206\u62e3\u673a\u72b6\u6001\u4e0a\u62a5\u6570\u636e\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
        Date lastTime = this.getLastTime("lastDeviceStatusUploadTime-" + machine.getMachineId());
        if (lastTime == null) {
            lastTime = new Date(new Date().getTime() - machine.getStatusSendingInterval() * 1000L);
        } else if (!this.timeExpired(lastTime, machine.getStatusSendingInterval().longValue())) {
            log.debug("\u95f4\u9694\u6216\u5468\u671f\u672a\u5230\u3002\u4e0a\u6b21\u65f6\u95f4: {}\u3002", (Object)lastTime);
            return;
        }
        String ip = machine.getPlcIp();
        log.info("\u751f\u6210\u8bbe\u5907\u72b6\u6001\u3002\u4e0a\u62a5\u6e90IP: {}\u3002", (Object)ip);
        SorterDeviceInfo sorterDeviceInfo = (SorterDeviceInfo)this.deviceInfoManager.getSorterDeviceInfoMap().get(ip);
        if (sorterDeviceInfo == null) {
            log.warn("\u5206\u62e3\u673a\u4e0a\u62a5\u6e90IP\u672a\u914d\u7f6e\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
            return;
        }
        InnerState state = sorterDeviceInfo.getInnerState();
        HeartBreak heartBreak = sorterDeviceInfo.getHeartBreak();
        if (heartBreak == null) {
            log.info("\u8fd8\u6ca1\u6709\u6536\u5230\u5206\u62e3\u673a\u7684\u5fc3\u8df3\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
            return;
        }
        if (1 == heartBreak.getSystemStatus()) {
            if (!state.isRebooted()) {
                state.setRebooted(true);
                state.setShutdowned(false);
                this.deviceStatusHelper.createStatusForOnLineAndOffline(machine, "ST01", "\u5355\u5c42\u5206\u62e3\u673a", true);
            }
        } else if (2 != heartBreak.getSystemStatus() && state.isRebooted()) {
            this.deviceStatusHelper.createStatusForOnLineAndOffline(machine, "ST01", "\u5355\u5c42\u5206\u62e3\u673a", false);
            this.deviceStatusHelper.createStatusForOnLineAndOffline(machine, "ST01", "\u5355\u5c42\u5206\u62e3\u673a", true);
        }
        if ((uploadData = this.createStatus(machine, "ST01", sorterDeviceInfo)) != null) {
            this.deviceStatusHelper.createEvents(machine, uploadData);
            state.setRebooted(false);
        }
        if (2 == heartBreak.getSystemStatus() && !state.isShutdowned()) {
            state.setShutdowned(true);
            state.setRebooted(false);
            this.deviceStatusHelper.createStatusForOnLineAndOffline(machine, "ST01", "\u5355\u5c42\u5206\u62e3\u673a", false);
        }
        Date newTime = new Date(lastTime.getTime() + machine.getStatusSendingInterval() * 1000L);
        this.updateLastTime("lastDeviceStatusUploadTime-" + machine.getMachineId(), newTime);
    }

    private UploadData createStatus(MachineConfig machine, String sorterId, SorterDeviceInfo sorterDeviceInfo) {
        log.debug("\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u673a\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
        Date now = new Date();
        InnerState state = sorterDeviceInfo.getInnerState();
        UploadData data = new UploadData();
        DeviceStatus status = new DeviceStatus();
        status.setSorterId(machine.getMachineId());
        status.setSorterName(machine.getMachineName());
        String collectTimeStr = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss");
        status.setCollectTime(collectTimeStr);
        status.setRequestInterval(Integer.valueOf(machine.getStatusSendingInterval().intValue()));
        status.setSorterListMsg(new ArrayList());
        HeartBreak heartBreak = sorterDeviceInfo.getHeartBreak();
        if (heartBreak == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u5fc3\u8df3\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
        } else {
            String deviceType = "1";
            boolean isUploadAfterReboot = state.getUploadedAfterReboot(deviceType);
            log.debug("getUploadedAfterReboot({}): {}", (Object)deviceType, (Object)isUploadAfterReboot);
            IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
            String devId = sorterId;
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (!isUploadAfterReboot || state.getChanged(devId)) {
                SorterMsg sorterMsg = new SorterMsg();
                sorterMsg.setDevId(devId);
                sorterMsg.setName("\u5355\u5c42\u5206\u62e3\u673a");
                String sorterStatus = translator.translate("1", (int)heartBreak.getSystemStatus());
                sorterMsg.setSorterStatus(sorterStatus);
                FaultInfo faultInfo = translator.translateFault((int)heartBreak.getSystemStatus());
                sorterMsg.setFaultInfo(faultInfo);
                sorterMsg.setRunningSpeed(String.format("%.3f", Float.valueOf((float)heartBreak.getSystemSpeed() / 1000.0f)));
                sorterMsg.setEvenFlag(Integer.valueOf(1));
                status.getSorterListMsg().add(sorterMsg);
                state.setChanged(devId, Boolean.valueOf(false));
            }
            state.setUploadedAfterReboot(deviceType, Boolean.valueOf(true));
        }
        List carrierMsgList = this.createCarrierMsgList(machine, sorterId, sorterDeviceInfo, state);
        status.setCarrierListMsg(carrierMsgList);
        List dynamicScaleMsg = this.createDynamicScaleMsgList(machine, sorterId, sorterDeviceInfo, state);
        status.setDynamicScaleListMsg(dynamicScaleMsg);
        List electricMotorMsgList = this.createElectricMotorMsgList(machine, sorterId, sorterDeviceInfo, state);
        status.setElectricMotorListMsg(electricMotorMsgList);
        List grayscaleMsgList = this.createGrayscaleMsgList(machine, sorterId, sorterDeviceInfo, state);
        status.setGrayscaleListMsg(grayscaleMsgList);
        List inductMsgList = this.createInductMsgList(machine, sorterId, sorterDeviceInfo, state);
        status.setInductListMsg(inductMsgList);
        List obrMsgList = this.createObrMsgList(machine, sorterId, sorterDeviceInfo, state);
        status.setObrListMsg(obrMsgList);
        List slotStatusMsgList = this.createSlotStatusMsgList(machine, sorterId, sorterDeviceInfo, state);
        status.setPhysicalPosListMsg(slotStatusMsgList);
        status.setRelationDeviceListMsg(new ArrayList());
        List sorterDatabaseMsgList = this.deviceStatusHelper.createSorterDatabseMsgList(machine, this.deviceInfoManager);
        status.setSorterDatabaseListMsg(sorterDatabaseMsgList);
        if (!this.uploadDataHelper.hasAnyMessage(status)) {
            log.debug("\u6ca1\u6709\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u673a\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return null;
        }
        data.setRequestBody(JSON.toJSONString((Object)status));
        data.setStatusData(status);
        data.setFormat("JSON");
        data.setMachineId(machine.getMachineId());
        data.setManufacturerId(this.manufacturerConfig.getId());
        String requestId = UUID.randomUUID((boolean)true).toString(true);
        String requestTimeStr = TokenUtils.formatDate((Date)now);
        data.setRequestId(requestId);
        data.setRequestTime(DateUtils.dateTime((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (String)requestTimeStr));
        data.setStatus(UploadDataStatus.INIT.getCode());
        String token = TokenUtils.getToken((String)requestId, (String)requestTimeStr, (String)this.manufacturerConfig.getSecretKey());
        data.setToken(token);
        data.setType(RequestType.DEVICE_STATUS.getCode());
        data.setResponse("{}");
        this.uploadDataHelper.saveUploadData(data);
        return data;
    }

    private List<CarrierMsg> createCarrierMsgList(MachineConfig machine, String sorterId, SorterDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<CarrierMsg> carrierMsgList = new ArrayList<CarrierMsg>();
        CarrierStatus carrierStatus = sorterDeviceInfo.getCarrierStatus();
        if (carrierStatus == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u5c0f\u8f66\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return carrierMsgList;
        }
        log.debug("\u5c0f\u8f66\u6570\u91cf: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", new Object[]{carrierStatus.getCount(), machine.getMachineId(), sorterId});
        String deviceType = "3";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)deviceType, (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        byte[] statusArr = carrierStatus.getStatusArr();
        for (int i = 0; i < carrierStatus.getCount(); ++i) {
            String devId = sorterId + ".CR" + String.format("%04d", i + 1);
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            CarrierMsg msg = new CarrierMsg();
            msg.setDevId(devId);
            msg.setName(String.valueOf(i + 1) + "\u53f7\u5c0f\u8f66");
            String sorterStatus = translator.translate("1", (int)statusArr[i]);
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)statusArr[i]);
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            carrierMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(carrierMsgList)) {
            state.setUploadedAfterReboot(deviceType, Boolean.valueOf(true));
        }
        return carrierMsgList;
    }

    private List<ElectricMotorMsg> createElectricMotorMsgList(MachineConfig machine, String sorterId, SorterDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<ElectricMotorMsg> electricMotorMsgList = new ArrayList<ElectricMotorMsg>();
        ElectricMotorStatus electricMotorStatus = sorterDeviceInfo.getElectricMotorStatus();
        if (electricMotorStatus == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u76f4\u7ebf\u7535\u673a\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return electricMotorMsgList;
        }
        log.debug("\u76f4\u7ebf\u7535\u673a\u6570\u91cf: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", new Object[]{electricMotorStatus.getCount(), machine.getMachineId(), sorterId});
        String deviceType = "8";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)deviceType, (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        byte[] statusArr = electricMotorStatus.getStatusArr();
        for (int i = 0; i < electricMotorStatus.getCount(); ++i) {
            String devId = sorterId + ".EM" + String.format("%04d", i + 1);
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            ElectricMotorMsg msg = new ElectricMotorMsg();
            msg.setDevId(devId);
            msg.setName(String.valueOf(i + 1) + "\u53f7\u76f4\u7ebf\u7535\u673a");
            String sorterStatus = translator.translate("1", (int)statusArr[i]);
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)statusArr[i]);
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            electricMotorMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(electricMotorMsgList)) {
            state.setUploadedAfterReboot(deviceType, Boolean.valueOf(true));
        }
        return electricMotorMsgList;
    }

    private List<GrayscaleMsg> createGrayscaleMsgList(MachineConfig machine, String sorterId, SorterDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<GrayscaleMsg> grayscaleMsgList = new ArrayList<GrayscaleMsg>();
        PlcStatus plcStatus = sorterDeviceInfo.getPlcStatus();
        if (plcStatus == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230PLC\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return grayscaleMsgList;
        }
        StatusArrWithNum grayscale = plcStatus.getGrayscale();
        if (grayscale == null || grayscale.getCount() == 0) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u7070\u5ea6\u4eea\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return grayscaleMsgList;
        }
        log.debug("\u7070\u5ea6\u6570\u91cf: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", new Object[]{grayscale.getCount(), machine.getMachineId(), sorterId});
        String deviceType = "7";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)deviceType, (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        byte[] statusArr = grayscale.getStatusArr();
        for (int i = 0; i < grayscale.getCount(); ++i) {
            String devId = sorterId + ".GS" + String.format("%04d", i + 1);
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            GrayscaleMsg msg = new GrayscaleMsg();
            msg.setDevId(devId);
            msg.setName(String.valueOf(i + 1) + "\u53f7\u7070\u5ea6\u4eea");
            String sorterStatus = translator.translate("1", (int)statusArr[i]);
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)statusArr[i]);
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            grayscaleMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(grayscaleMsgList)) {
            state.setUploadedAfterReboot(deviceType, Boolean.valueOf(true));
        }
        return grayscaleMsgList;
    }

    private List<InductMsg> createInductMsgList(MachineConfig machine, String sorterId, SorterDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<InductMsg> inductMsgList = new ArrayList<InductMsg>();
        InductStatus inductStatus = sorterDeviceInfo.getInductStatus();
        if (inductStatus == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u4f9b\u4ef6\u53f0\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return inductMsgList;
        }
        log.debug("\u4f9b\u4ef6\u53f0\u6570\u91cf: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", new Object[]{inductStatus.getCount(), machine.getMachineId(), sorterId});
        List inductList = this.deviceHelper.getDynamicScaleConfigList(Long.valueOf(Long.parseLong(machine.getMachineId())), sorterId);
        if (CollectionUtils.isEmpty((Collection)inductList)) {
            log.debug("\u5f53\u524d\u5206\u62e3\u673a\u65e0\u4f9b\u4ef6\u53f0\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return inductMsgList;
        }
        String deviceType = "2";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)deviceType, (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        byte[] statusArr = inductStatus.getStatusArr();
        for (DeviceConfig induct : inductList) {
            int i = induct.getSeqNo() - 1;
            if (statusArr.length < induct.getSeqNo()) {
                log.error("\u4f9b\u4ef6\u53f0\u72b6\u6001\u4e0b\u6807\u6ea2\u51fa\u9519\u8bef\u3002\u72b6\u6001\u6570\u7ec4\u957f\u5ea6: {}, \u52a8\u6001\u79e4\u4e0b\u6807: {}\u3002", (Object)statusArr.length, (Object)i);
                break;
            }
            String devId = induct.getDevId();
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            InductMsg msg = new InductMsg();
            msg.setDevId(devId);
            msg.setName(induct.getDevName());
            String sorterStatus = translator.translate("1", (int)statusArr[i]);
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)statusArr[i]);
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            inductMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(inductMsgList)) {
            state.setUploadedAfterReboot(deviceType, Boolean.valueOf(true));
        }
        return inductMsgList;
    }

    private List<ObrMsg> createObrMsgList(MachineConfig machine, String sorterId, SorterDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<ObrMsg> obrMsgList = new ArrayList<ObrMsg>();
        PlcStatus plcStatus = sorterDeviceInfo.getPlcStatus();
        if (plcStatus == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230PLC\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return obrMsgList;
        }
        StatusArrWithNum obr = plcStatus.getScanner();
        if (obr == null || obr.getCount() == 0) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230OBR\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return obrMsgList;
        }
        log.debug("OBR\u6570\u91cf: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", new Object[]{obr.getCount(), machine.getMachineId(), sorterId});
        String deviceType = "4";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)deviceType, (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        byte[] statusArr = obr.getStatusArr();
        for (int i = 0; i < obr.getCount(); ++i) {
            String devId = sorterId + ".OR" + String.format("%04d", i + 1);
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            ObrMsg msg = new ObrMsg();
            msg.setDevId(devId);
            msg.setName(String.valueOf(i + 1) + "\u53f7OBR");
            String sorterStatus = translator.translate("1", (int)statusArr[i]);
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)statusArr[i]);
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            obrMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(obrMsgList)) {
            state.setUploadedAfterReboot(deviceType, Boolean.valueOf(true));
        }
        return obrMsgList;
    }

    private List<PhysicalPosMsg> createSlotStatusMsgList(MachineConfig machine, String sorterId, SorterDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<PhysicalPosMsg> slotStatusMsgList = new ArrayList<PhysicalPosMsg>();
        GridPosStatus slotStatus = sorterDeviceInfo.getGridPosStatus();
        if (slotStatus == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u683c\u53e3\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return slotStatusMsgList;
        }
        log.debug("\u683c\u53e3\u53f0\u6570\u91cf: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", new Object[]{slotStatus.getCount(), machine.getMachineId(), sorterId});
        String deviceType = "5";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)deviceType, (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        byte[] statusArr = slotStatus.getStatusArr();
        for (int i = 0; i < slotStatus.getCount(); ++i) {
            String devId = sorterId + ".PP" + String.format("%04d", i + 1);
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            PhysicalPosMsg msg = new PhysicalPosMsg();
            msg.setDevId(devId);
            msg.setName(String.valueOf(i + 1) + "\u53f7\u683c\u53e3");
            String sorterStatus = translator.translate("1", (int)statusArr[i]);
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)statusArr[i]);
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            slotStatusMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(slotStatusMsgList)) {
            state.setUploadedAfterReboot(deviceType, Boolean.valueOf(true));
        }
        return slotStatusMsgList;
    }

    private List<DynamicScaleMsg> createDynamicScaleMsgList(MachineConfig machine, String sorterId, SorterDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<DynamicScaleMsg> dynamicScaleMsgList = new ArrayList<DynamicScaleMsg>();
        InductStatus inductStatus = sorterDeviceInfo.getInductStatus();
        if (inductStatus == null) {
            log.debug("\u5c1a\u672a\u6536\u5230\u4f9b\u4ef6\u53f0\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return dynamicScaleMsgList;
        }
        byte[] statusArr = inductStatus.getStatusArr();
        if (statusArr == null) {
            log.debug("\u4f9b\u4ef6\u53f0\u72b6\u6001\u5217\u8868\u4e3a\u7a7a\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return dynamicScaleMsgList;
        }
        List dynamicScaleList = this.deviceHelper.getDynamicScaleConfigList(Long.valueOf(Long.parseLong(machine.getMachineId())), sorterId);
        if (CollectionUtils.isEmpty((Collection)dynamicScaleList)) {
            log.debug("\u5f53\u524d\u5206\u62e3\u673a\u65e0\u52a8\u6001\u79e4\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return dynamicScaleMsgList;
        }
        String deviceType = "6";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)deviceType, (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        for (DeviceConfig ds : dynamicScaleList) {
            int i = ds.getSeqNo() - 1;
            if (statusArr.length < ds.getSeqNo()) {
                log.error("\u52a8\u6001\u79e4\u72b6\u6001\u4e0b\u6807\u6ea2\u51fa\u9519\u8bef\u3002\u72b6\u6001\u6570\u7ec4\u957f\u5ea6: {}, \u52a8\u6001\u79e4\u4e0b\u6807: {}\u3002", (Object)statusArr.length, (Object)i);
                break;
            }
            String devId = ds.getDevId();
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            DynamicScaleMsg dynamicScaleMsg = new DynamicScaleMsg();
            dynamicScaleMsg.setDevId(ds.getDevId());
            dynamicScaleMsg.setName(ds.getDevName());
            int fixedStatus = statusArr[i];
            if (fixedStatus != 0) {
                fixedStatus = fixedStatus == 3 ? 1 : 2;
            }
            dynamicScaleMsg.setSorterStatus(translator.translate("1", fixedStatus));
            dynamicScaleMsg.setFaultInfo(translator.translateFault(fixedStatus));
            dynamicScaleMsg.setHostDevId(ds.getDevId());
            dynamicScaleMsgList.add(dynamicScaleMsg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(dynamicScaleMsgList)) {
            state.setUploadedAfterReboot(deviceType, Boolean.valueOf(true));
        }
        return dynamicScaleMsgList;
    }

    private Date getLastTime(String key) {
        Wrapper wrapper = (Wrapper)Wrappers.lambdaQuery().eq(BasicConfig::getBasickey, (Object)key);
        BasicConfig config = (BasicConfig)this.basicConfigService.getOne(wrapper);
        if (config == null) {
            log.info("\u4e0a\u6b21\u65f6\u95f4\u672a\u914d\u7f6e: {}\u3002", (Object)key);
            return null;
        }
        String value = config.getBasicvalue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            log.info("\u4e0a\u6b21\u65f6\u95f4\u672a\u914d\u7f6e: {}\u3002", (Object)key);
            return null;
        }
        try {
            Date lastTime = DateUtils.dateTime((String)"yyyy-MM-dd HH:mm:ss", (String)value);
            return lastTime;
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef: {}\u3002", (Object)value);
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean timeExpired(@NotNull Date lastTime, long intervalSeconds) {
        long diffMillSeconds = System.currentTimeMillis() - lastTime.getTime();
        return diffMillSeconds >= intervalSeconds;
    }

    private void updateLastTime(String key, Date lastTime) {
        Wrapper wrapper = (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(BasicConfig::getBasicvalue, (Object)DateFormatUtils.format((Date)lastTime, (String)"yyyy-MM-dd HH:mm:ss"))).eq(BasicConfig::getBasickey, (Object)key);
        this.basicConfigService.update(wrapper);
    }

    public static void main(String[] argv) {
        Date lastTime = new Date();
        System.out.println(lastTime + ": " + DateFormatUtils.format((Date)lastTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
    }
}

