/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.simba.services.bean.domain.BasicConfig;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.domain.UploadData;
import com.simba.services.bean.model.BalanceWheelDeviceInfo;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.bean.model.SorterDeviceInfo;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.common.utils.uuid.UUID;
import com.simba.services.config.WinccConfig;
import com.simba.services.enums.RequestType;
import com.simba.services.enums.UploadDataStatus;
import com.simba.services.helper.MachineHelper;
import com.simba.services.helper.UploadDataHelper;
import com.simba.services.message.sorter.GridPosStatus;
import com.simba.services.service.BasicConfigService;
import com.simba.services.service.StatisticsService;
import com.simba.services.service.UploadDataService;
import com.simba.services.upload.data.SortData;
import com.simba.services.util.TokenUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SortDataHelper {
    private static final Logger log = LoggerFactory.getLogger(SortDataHelper.class);
    @Resource
    private BasicConfigService basicConfigService;
    @Resource
    private WinccConfig.WorkshopConfig workshopConfig;
    @Resource
    private WinccConfig.ManufacturerConfig manufacturerConfig;
    @Resource
    private WinccConfig.DeviceStatusUploadConfig uploadConfig;
    @Resource
    private UploadDataService uploadDataService;
    @Resource
    private UploadDataHelper uploadDataHelper;
    @Resource
    private StatisticsService statisticsService;
    @Resource
    private MachineHelper machineHelper;
    @Resource
    private DeviceInfoManager deviceInfoManager;

    public void createForMachine(MachineConfig machineConfig) {
        Date lastTime = this.getLastTime("lastSortDataCreationTime-" + machineConfig.getMachineId());
        if (lastTime == null) {
            lastTime = new Date(new Date().getTime() - machineConfig.getDataSendingInterval() * 1000L);
        } else if (!this.isTimePassed(lastTime, machineConfig.getDataSendingInterval().longValue())) {
            log.debug("\u95f4\u9694\u6216\u5468\u671f\u672a\u5230\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u4e0a\u6b21\u65f6\u95f4: {}\u3002", (Object)machineConfig.getMachineId(), (Object)lastTime);
            return;
        }
        log.debug("\u95f4\u9694\u6216\u5468\u671f\u5df2\u5230\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u4e0a\u6b21\u65f6\u95f4: {}\u3002", (Object)machineConfig.getMachineId(), (Object)lastTime);
        this.createSortData(machineConfig, lastTime);
        Date newTime = new Date(lastTime.getTime() + machineConfig.getDataSendingInterval() * 1000L);
        this.updateLastTime("lastSortDataCreationTime-" + machineConfig.getMachineId(), newTime);
        log.debug("\u6b64\u6b21\u5206\u62e3\u6570\u636e\u751f\u6210\u65f6\u95f4: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}", (Object)newTime, (Object)machineConfig.getMachineId());
    }

    private void createSortData(MachineConfig machine, Date lastTime) {
        log.debug("\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
        Date now = new Date();
        UploadData data = new UploadData();
        SortData sortData = new SortData();
        sortData.setSorterId(machine.getMachineId());
        sortData.setSorterName(machine.getMachineName());
        String collectTimeStr = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss");
        sortData.setCollectTime(collectTimeStr);
        sortData.setRequestInterval(Integer.valueOf(machine.getDataSendingInterval().intValue()));
        int slotCount1 = 0;
        int slotCount2 = 0;
        if (this.machineHelper.isSorterTypeOfWheel(machine)) {
            slotCount1 = this.getBalanceWheelSlotCount(machine, "IL");
            slotCount2 = this.getBalanceWheelSlotCount(machine, "SL");
        } else {
            slotCount1 = this.getSorterSlotCount(machine);
        }
        log.debug("\u5206\u62e3\u673a\u6570\u636e\u5f00\u59cb");
        boolean isBalanceWheel = this.machineHelper.isSorterTypeOfWheel(machine);
        List sorterListMsg = this.statisticsService.listSorterSortDataByMachine(machine, lastTime, slotCount1, slotCount2, isBalanceWheel);
        sortData.setSorterListMsg(sorterListMsg);
        log.debug("\u5c0f\u8f66\u6570\u636e\u5f00\u59cb");
        if (!this.machineHelper.isSorterTypeOfWheel(machine)) {
            List carrierListMsg = this.statisticsService.listCarrierSortDataByMachine(machine, lastTime);
            sortData.setCarrierListMsg(carrierListMsg);
        }
        log.debug("\u683c\u53e3\u6570\u636e\u5f00\u59cb");
        List physicalPosListMsg = this.statisticsService.listSlotSortDataByMachine(machine, lastTime);
        sortData.setPhysicalPosListMsg(physicalPosListMsg);
        log.debug("\u4f9b\u4ef6\u53f0\u6570\u636e\u5f00\u59cb");
        List inductListMsg = new ArrayList();
        if (!this.machineHelper.isSorterTypeOfWheel(machine)) {
            inductListMsg = this.statisticsService.listInductSortDataByMachine(machine, lastTime);
        }
        sortData.setInductListMsg(inductListMsg);
        log.debug("OBR\u6570\u636e\u5f00\u59cb");
        List obrListMsg = this.statisticsService.listObrSortDataByMachine(machine, lastTime);
        sortData.setObrListMsg(obrListMsg);
        if (this.machineHelper.isSorterTypeOfWheel(machine)) {
            List linesListMsg = this.statisticsService.listLinesSortDataByMachine(machine, lastTime);
            sortData.setLinesListMsg(linesListMsg);
        }
        if (this.machineHelper.isSorterTypeOfWheel(machine)) {
            sortData.setWheelBeltListMsg(new ArrayList());
        }
        data.setRequestBody(JSON.toJSONString((Object)sortData));
        data.setFormat("JSON");
        data.setMachineId(machine.getMachineId());
        data.setManufacturerId(this.manufacturerConfig.getId());
        String requestId = UUID.randomUUID((boolean)true).toString(true);
        String requestTimeStr = TokenUtils.formatDate((Date)now);
        data.setRequestId(requestId);
        data.setRequestTime(DateUtils.dateTime((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (String)requestTimeStr));
        data.setStatus(UploadDataStatus.INIT.getCode());
        String token = TokenUtils.getToken((String)requestId, (String)requestTimeStr, (String)this.manufacturerConfig.getSecretKey());
        data.setToken(token);
        data.setType(RequestType.SORT_DATA.getCode());
        data.setResponse("{}");
        data.setRequestBody(JSON.toJSONString((Object)sortData));
        this.uploadDataService.saveTmUploadData(data);
    }

    private int getSorterSlotCount(MachineConfig machine) {
        int count = 0;
        Map sorterMap = this.deviceInfoManager.getSorterDeviceInfoMap();
        if (sorterMap == null || sorterMap.isEmpty()) {
            log.debug("\u5c1a\u65e0\u4ea4\u53c9\u5e26\u5206\u62e3\u673a\u8fde\u63a5\u3002");
            return 0;
        }
        log.debug("\u4ea4\u53c9\u5e26\u5206\u62e3\u673a\u6570\u91cf\u4e3a: {}\u3002", (Object)sorterMap.size());
        for (String plcIp : sorterMap.keySet()) {
            if (!plcIp.startsWith(machine.getPlcIp())) continue;
            SorterDeviceInfo sorter = (SorterDeviceInfo)sorterMap.get(plcIp);
            GridPosStatus slots = sorter.getGridPosStatus();
            if (slots == null) {
                log.debug("\u4ea4\u53c9\u5e26\u5206\u62e3\u673a\u5c1a\u65e0\u683c\u53e3\u72b6\u6001\u4fe1\u606f\u3002\u4ea4\u53c9\u5e26\u5206\u62e3\u673a\u7f16\u7801: {}, \u540d\u79f0: {}", (Object)machine.getMachineId(), (Object)machine.getMachineName());
                return 0;
            }
            count = slots.getCount();
            break;
        }
        return count;
    }

    private int getBalanceWheelSlotCount(MachineConfig machine, String lineType) {
        BalanceWheelDeviceInfo sorterDeviceInfo = this.deviceInfoManager.getBalanceWheelDeviceInfo();
        Map slotStatusMap = sorterDeviceInfo.getGridPosStatusMap();
        if (slotStatusMap == null || slotStatusMap.isEmpty()) {
            log.debug("\u83b7\u53d6\u683c\u53e3\u6570\u91cf\u3002\u5c1a\u65e0\u77e9\u9635\u5206\u62e3\u673a\u8fde\u63a5\u3002");
            return 0;
        }
        log.debug("\u683c\u53e3\u72b6\u6001\u6620\u5c04\u8868\u5927\u5c0f: {}\u3002", (Object)slotStatusMap.size());
        int countIl = 0;
        int countSl = 0;
        for (String lineNumStr : slotStatusMap.keySet()) {
            log.debug("TODO \u7ebf\u4f53\u53f7: {}", (Object)lineNumStr);
            com.simba.services.message.balancewheel.GridPosStatus slotStatus = (com.simba.services.message.balancewheel.GridPosStatus)slotStatusMap.get(lineNumStr);
            int lineNum = Integer.parseInt(lineNumStr);
            if (slotStatus == null) {
                log.debug("\u7ebf\u4f53\u5c1a\u672a\u8fde\u63a5\u3002\u7ebf\u4f53\u53f7: {}\u3002", (Object)lineNum);
                continue;
            }
            if (lineNum > 9 && lineNum < 18) {
                log.debug("\u7ebf\u4f53 {} \u683c\u53e3\u72b6\u6570\u91cf\u4e3a {}\u3002", (Object)lineNum, (Object)slotStatus.getCount());
                countSl += slotStatus.getCount();
                continue;
            }
            log.debug("\u7ebf\u4f53 {} \u683c\u53e3\u72b6\u6570\u91cf\u4e3a {}\u3002", (Object)lineNum, (Object)slotStatus.getCount());
            countIl += slotStatus.getCount();
        }
        if ("IL".equalsIgnoreCase(lineType)) {
            return countIl;
        }
        return countSl;
    }

    private Date getLastTime(String key) {
        Wrapper wrapper = (Wrapper)Wrappers.lambdaQuery().eq(BasicConfig::getBasickey, (Object)key);
        BasicConfig config = (BasicConfig)this.basicConfigService.getOne(wrapper);
        if (config == null) {
            log.info("\u4e0a\u6b21\u65f6\u95f4\u672a\u914d\u7f6e: {}\u3002", (Object)key);
            return null;
        }
        String value = config.getBasicvalue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            log.info("\u4e0a\u6b21\u65f6\u95f4\u672a\u914d\u7f6e: {}\u3002", (Object)key);
            return null;
        }
        try {
            Date lastTime = DateUtils.dateTime((String)"yyyy-MM-dd HH:mm:ss", (String)value);
            return lastTime;
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef: {}\u3002", (Object)value);
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean isTimePassed(@NotNull Date time, long expiredSeconds) {
        long diffMillSeconds = System.currentTimeMillis() - time.getTime();
        return diffMillSeconds >= expiredSeconds * 1000L;
    }

    private void updateLastTime(String key, Date lastTime) {
        Wrapper wrapper = (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(BasicConfig::getBasicvalue, (Object)DateFormatUtils.format((Date)lastTime, (String)"yyyy-MM-dd HH:mm:ss"))).eq(BasicConfig::getBasickey, (Object)key);
        this.basicConfigService.update(wrapper);
    }

    private List<UploadData> getSortDataList(MachineConfig machine) {
        List<String> statusList = Arrays.asList(UploadDataStatus.INIT.getCode(), UploadDataStatus.RETRYING.getCode());
        Wrapper query = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(UploadData::getStatus, statusList)).eq(UploadData::getMachineId, (Object)machine.getMachineId())).eq(UploadData::getType, (Object)RequestType.SORT_DATA.getCode())).orderByAsc(UploadData::getStatus)).orderByAsc(UploadData::getId)).last(" limit 100");
        List list = this.uploadDataService.list(query);
        return list;
    }
}

