/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.alibaba.fastjson.JSON;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.domain.UploadData;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.common.utils.uuid.UUID;
import com.simba.services.config.WinccConfig;
import com.simba.services.enums.DeviceClass;
import com.simba.services.enums.RequestType;
import com.simba.services.enums.UploadDataStatus;
import com.simba.services.helper.DatabaseHelper;
import com.simba.services.helper.MachineHelper;
import com.simba.services.helper.StatusTranslatorHelper;
import com.simba.services.helper.UploadDataHelper;
import com.simba.services.service.IStatusTranslator;
import com.simba.services.service.translator.FaultInfo;
import com.simba.services.upload.event.DeviceEvent;
import com.simba.services.upload.event.FaultMsg;
import com.simba.services.upload.status.AbstractDeviceMsg;
import com.simba.services.upload.status.DeviceStatus;
import com.simba.services.upload.status.RelationDeviceMsg;
import com.simba.services.upload.status.SorterDatabaseMsg;
import com.simba.services.upload.status.SorterMsg;
import com.simba.services.util.TokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceStatusHelper {
    private static final Logger log = LoggerFactory.getLogger(DeviceStatusHelper.class);
    @Resource
    private WinccConfig.ManufacturerConfig manufacturerConfig;
    @Resource
    private MachineHelper machineHelper;
    @Resource
    private UploadDataHelper uploadDataHelper;
    @Resource
    private StatusTranslatorHelper statusTranslatorHelper;
    @Resource
    private DatabaseHelper databaseStatusHelper;
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 0;

    public void createStatusForOnLineAndOffline(MachineConfig machine, String sorterDevId, String sorterName, boolean isOnLine) {
        log.info("\u751f\u6210\u5206\u62e3\u673a {} \u72b6\u6001\u6570\u636e\u3002", (Object)(isOnLine ? "\u5728\u7ebf" : "\u79bb\u7ebf"));
        Date now = new Date();
        UploadData data = new UploadData();
        DeviceStatus status = new DeviceStatus();
        status.setSorterId(machine.getMachineId());
        status.setSorterName(machine.getMachineName());
        String collectTimeStr = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss");
        status.setCollectTime(collectTimeStr);
        ArrayList<SorterMsg> sorterListMsg = new ArrayList<SorterMsg>();
        SorterMsg sorterMsg = new SorterMsg();
        sorterMsg.setDevId(sorterDevId);
        sorterMsg.setName(sorterName);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator("1");
        String sorterStatus = translator.translate("1", 0);
        sorterMsg.setSorterStatus(sorterStatus);
        sorterMsg.setRunningSpeed("0");
        if (isOnLine) {
            sorterMsg.setEvenFlag(Integer.valueOf(1));
        } else {
            sorterMsg.setEvenFlag(Integer.valueOf(0));
        }
        sorterListMsg.add(sorterMsg);
        status.setSorterListMsg(sorterListMsg);
        status.setCarrierListMsg(new ArrayList());
        status.setElectricMotorListMsg(new ArrayList());
        status.setGrayscaleListMsg(new ArrayList());
        status.setInductListMsg(new ArrayList());
        status.setPhysicalPosListMsg(new ArrayList());
        status.setRelationDeviceListMsg(this.createRelationDeviceDefaultListMsg(sorterDevId));
        status.setRequestInterval(Integer.valueOf(machine.getStatusSendingInterval().intValue()));
        status.setWheelBeltListMsg(new ArrayList());
        data.setRequestBody(JSON.toJSONString((Object)status));
        data.setFormat("JSON");
        data.setMachineId(machine.getMachineId());
        data.setManufacturerId(this.manufacturerConfig.getId());
        String requestId = UUID.randomUUID((boolean)true).toString(true);
        String requestTimeStr = TokenUtils.formatDate((Date)now);
        data.setRequestId(requestId);
        data.setRequestTime(DateUtils.dateTime((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (String)requestTimeStr));
        data.setStatus(UploadDataStatus.INIT.getCode());
        String token = TokenUtils.getToken((String)requestId, (String)requestTimeStr, (String)this.manufacturerConfig.getSecretKey());
        log.info("requestId: {}. request_time: {}, secretKey: {}\u3002", new Object[]{data.getRequestId(), requestTimeStr, this.manufacturerConfig.getSecretKey()});
        log.info("\u8ba1\u7b97\u7684token: {}\u3002", (Object)token);
        data.setToken(token);
        data.setType(RequestType.DEVICE_STATUS.getCode());
        data.setResponse("{}");
        data.setRequestBody(JSON.toJSONString((Object)status));
        this.uploadDataHelper.saveUploadData(data);
    }

    private List<RelationDeviceMsg> createRelationDeviceDefaultListMsg(String sorterId) {
        ArrayList<RelationDeviceMsg> list = new ArrayList<RelationDeviceMsg>();
        RelationDeviceMsg msg = new RelationDeviceMsg();
        msg.setDevId(sorterId + ".RD001");
        msg.setName("\u4e3bPLC\u8fde\u63a5");
        msg.setConnectStatus(String.valueOf(1));
        list.add(msg);
        msg = new RelationDeviceMsg();
        msg.setDevId(sorterId + ".RD002");
        msg.setName("\u901a\u8baf\u673a\u8fde\u63a5");
        msg.setConnectStatus(String.valueOf(1));
        list.add(msg);
        msg = new RelationDeviceMsg();
        msg.setDevId(sorterId + ".RD003");
        msg.setName("\u6570\u636e\u5e93\u8fde\u63a5");
        msg.setConnectStatus(String.valueOf(1));
        list.add(msg);
        msg = new RelationDeviceMsg();
        msg.setDevId(sorterId + ".RD004");
        msg.setName("\u65b0\u4e00\u4ee3\u5bc4\u9012\u5e73\u53f0\u8fde\u63a5");
        msg.setConnectStatus(String.valueOf(1));
        list.add(msg);
        msg = new RelationDeviceMsg();
        msg.setDevId(sorterId + ".RD005");
        msg.setName("\u4e0e\u63a7\u5236\u4e2d\u5fc3(ADM)\u7684\u8fde\u63a5\u72b6\u6001");
        msg.setConnectStatus(String.valueOf(1));
        list.add(msg);
        return list;
    }

    public List<SorterDatabaseMsg> createSorterDatabseMsgList(MachineConfig machine, DeviceInfoManager deviceInfoManager) {
        Boolean databaseStatusUploadedFlagFlag = (Boolean)deviceInfoManager.getDatabaseStatusUploadedFlagMap().get(machine.getMachineId());
        ArrayList<SorterDatabaseMsg> list = new ArrayList<SorterDatabaseMsg>();
        if (databaseStatusUploadedFlagFlag == null || !databaseStatusUploadedFlagFlag.booleanValue()) {
            SorterDatabaseMsg msg = this.databaseStatusHelper.createDatabaseMsg(machine);
            if (msg == null) {
                log.error("\u83b7\u53d6\u6570\u636e\u5e93\u72b6\u6001\u5931\u8d25\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u6570\u636e\u5e93\u540d: {}\u3002", (Object)machine.getMachineId(), (Object)machine.getReferenceSchema());
                return list;
            }
            deviceInfoManager.getDatabaseStatusUploadedFlagMap().put(machine.getMachineId(), Boolean.TRUE);
            list.add(msg);
        }
        return list;
    }

    public void createEvents(MachineConfig machine, UploadData uploadStatusData) {
        UploadData uploadEventData = new UploadData();
        DeviceStatus statusData = uploadStatusData.getStatusData();
        DeviceEvent eventData = new DeviceEvent();
        eventData.setSorterId(uploadStatusData.getStatusData().getSorterId());
        eventData.setSorterName(uploadStatusData.getStatusData().getSorterName());
        eventData.setCollectTime(uploadStatusData.getStatusData().getCollectTime());
        eventData.setInstructionListMsg(new ArrayList());
        eventData.setFaultListMsg(new ArrayList());
        Date now = new Date();
        this.convertStatusToFault(machine, statusData.getCarrierListMsg(), eventData.getFaultListMsg(), DeviceClass.CARRIER.getAbbr());
        this.convertStatusToFault(machine, statusData.getDynamicScaleListMsg(), eventData.getFaultListMsg(), DeviceClass.DYNAMICSCALE.getAbbr());
        this.convertStatusToFault(machine, statusData.getElectricMotorListMsg(), eventData.getFaultListMsg(), DeviceClass.ELECTRICMOTOR.getAbbr());
        this.convertStatusToFault(machine, statusData.getGrayscaleListMsg(), eventData.getFaultListMsg(), DeviceClass.GRAYSCALE.getAbbr());
        this.convertStatusToFault(machine, statusData.getInductListMsg(), eventData.getFaultListMsg(), DeviceClass.INDUCT.getAbbr());
        this.convertStatusToFault(machine, statusData.getLinesListMsg(), eventData.getFaultListMsg(), DeviceClass.LINESDEVICE.getAbbr());
        this.convertStatusToFault(machine, statusData.getObrListMsg(), eventData.getFaultListMsg(), DeviceClass.OBR.getAbbr());
        this.convertStatusToFault(machine, statusData.getPhysicalPosListMsg(), eventData.getFaultListMsg(), DeviceClass.PHYSICALPOS.getAbbr());
        this.convertStatusToFault(machine, statusData.getSorterListMsg(), eventData.getFaultListMsg(), DeviceClass.SORTER.getAbbr());
        this.convertStatusToFault(machine, statusData.getWheelBeltListMsg(), eventData.getFaultListMsg(), DeviceClass.WHEELBELT.getAbbr());
        if (CollectionUtils.isEmpty((Collection)eventData.getInstructionListMsg()) && CollectionUtils.isEmpty((Collection)eventData.getFaultListMsg())) {
            log.debug("\u6ca1\u6709\u6d88\u606f\u6570\u636e\u3002\u5206\u673a\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
            return;
        }
        uploadEventData.setRequestBody(JSON.toJSONString((Object)eventData));
        uploadEventData.setFormat("JSON");
        uploadEventData.setMachineId(machine.getMachineId());
        uploadEventData.setManufacturerId(this.manufacturerConfig.getId());
        String requestId = UUID.randomUUID((boolean)true).toString(true);
        String requestTimeStr = TokenUtils.formatDate((Date)now);
        uploadEventData.setRequestId(requestId);
        uploadEventData.setRequestTime(DateUtils.dateTime((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (String)requestTimeStr));
        uploadEventData.setStatus(UploadDataStatus.INIT.getCode());
        String token = TokenUtils.getToken((String)requestId, (String)requestTimeStr, (String)this.manufacturerConfig.getSecretKey());
        log.info("requestId: {}. request_time: {}, secretKey: {}\u3002", new Object[]{uploadEventData.getRequestId(), requestTimeStr, this.manufacturerConfig.getSecretKey()});
        log.info("\u8ba1\u7b97\u7684token: {}\u3002", (Object)token);
        uploadEventData.setToken(token);
        uploadEventData.setType(RequestType.DEVICE_EVENT.getCode());
        uploadEventData.setResponse("{}");
        this.uploadDataHelper.saveUploadData(uploadEventData);
    }

    private void convertStatusToFault(MachineConfig machine, List<? extends AbstractDeviceMsg> statusListMsg, List<FaultMsg> faultMsgList, String deviceClass) {
        if (CollectionUtils.isEmpty(statusListMsg)) {
            log.debug("{} \u72b6\u6001\u5217\u8868\u4e3a\u7a7a\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)deviceClass, (Object)machine.getMachineId());
            return;
        }
        log.debug("\u8f6c\u6362\u72b6\u6001\u4e3a\u6545\u969c\u3002{} \u72b6\u6001\u6570\u91cf: {}\u3002", (Object)deviceClass, (Object)statusListMsg.size());
        for (AbstractDeviceMsg abstractDeviceMsg : statusListMsg) {
            FaultInfo faultInfo = abstractDeviceMsg.getFaultInfo();
            if (faultInfo == null || StringUtils.isEmpty((CharSequence)faultInfo.getFaultStatus())) continue;
            String fixedDeviceClass = deviceClass;
            if (DeviceClass.WHEELBELT.getAbbr().equals(deviceClass)) {
                fixedDeviceClass = abstractDeviceMsg.getSorterStatus().startsWith("SHXB.SHDJ.113") ? DeviceClass.BALANCEWHEEL.getAbbr() : DeviceClass.BELTCONVEYOR.getAbbr();
            }
            log.debug("\u8f6c\u6362\u72b6\u6001\u4e3a\u6545\u969c: {}\u3002", (Object)JSON.toJSONString((Object)abstractDeviceMsg));
            FaultMsg faultMsg = this.convertStatusToFault(abstractDeviceMsg, fixedDeviceClass);
            faultMsgList.add(faultMsg);
        }
    }

    private FaultMsg convertStatusToFault(AbstractDeviceMsg statusMsg, String deviceClass) {
        FaultMsg faultMsg = new FaultMsg();
        faultMsg.setDeviceClass(deviceClass);
        faultMsg.setDevId(statusMsg.getDevId());
        FaultInfo faultInfo = statusMsg.getFaultInfo();
        faultMsg.setFaultDescription(faultInfo.getFaultDescription());
        faultMsg.setFaultLevel(faultInfo.getFaultLevel());
        faultMsg.setFaultStatus("SHXB.SHDJ." + faultInfo.getFaultStatus());
        faultMsg.setEvenFlag(new Integer(1));
        return faultMsg;
    }

    private void convertRelationDeviceStatus2Fault(MachineConfig machine, List<RelationDeviceMsg> relationDeviceListMsg, List<FaultMsg> faultMsgList) {
        if (CollectionUtils.isEmpty(relationDeviceListMsg)) {
            log.debug("\u5173\u8054\u8bbe\u5907\u72b6\u6001\u5217\u8868\u4e3a\u7a7a\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", relationDeviceListMsg, (Object)machine.getMachineId());
            return;
        }
        log.debug("\u5173\u8054\u8bbe\u5907\u72b6\u6001\u6570\u91cf: {}\u3002", (Object)relationDeviceListMsg.size());
        for (RelationDeviceMsg statusMsg : relationDeviceListMsg) {
            FaultInfo faultInfo = statusMsg.getFaultInfo();
            if (faultInfo == null) continue;
            FaultMsg faultMsg = this.convertStatusToFault(statusMsg, DeviceClass.RELATIONDEVICE.getAbbr());
            faultMsgList.add(faultMsg);
        }
    }

    private FaultMsg convertStatusToFault(RelationDeviceMsg statusMsg, String deviceClass) {
        FaultMsg faultMsg = new FaultMsg();
        faultMsg.setDeviceClass(deviceClass);
        faultMsg.setDevId(statusMsg.getDevId());
        FaultInfo faultInfo = statusMsg.getFaultInfo();
        faultMsg.setFaultDescription(faultInfo.getFaultDescription());
        faultMsg.setFaultLevel(faultInfo.getFaultLevel());
        faultMsg.setFaultStatus("SHXB.SHDJ." + faultInfo.getFaultStatus());
        return faultMsg;
    }
}

