/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.simba.services.bean.domain.DeviceConfig;
import com.simba.services.enums.DeviceClass;
import com.simba.services.service.DeviceConfigService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceHelper {
    private static final Logger log = LoggerFactory.getLogger(DeviceHelper.class);
    @Resource
    private DeviceConfigService deviceConfigService;

    public List<DeviceConfig> getDynamicScaleConfigList(Long machineId, String sorterId) {
        return this.getDeviceConfigList(machineId, sorterId, DeviceClass.DYNAMICSCALE.getCode());
    }

    public List<DeviceConfig> getObrConfigList(Long machineId, String sorterId) {
        return this.getDeviceConfigList(machineId, sorterId, DeviceClass.OBR.getCode());
    }

    private List<DeviceConfig> getDeviceConfigList(Long machineId, String sorterId, String deviceType) {
        Wrapper wrapper = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DeviceConfig::getDevType, (Object)deviceType)).eq(DeviceConfig::getMachineId, (Object)machineId)).eq(DeviceConfig::getSorterId, (Object)sorterId)).orderByAsc(DeviceConfig::getSeqNo);
        return this.deviceConfigService.list(wrapper);
    }

    public List<DeviceConfig> getBalanceWheelObrConfigList(short lineNum) {
        Wrapper wrapper = (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DeviceConfig::getLineNum, (Object)lineNum)).orderByAsc(DeviceConfig::getSeqNo);
        return this.deviceConfigService.list(wrapper);
    }

    public List<DeviceConfig> getWheelBeltConfigList() {
        Wrapper wrapper = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DeviceConfig::getDevType, (Object)DeviceClass.WHEELBELT.getCode())).orderByAsc(DeviceConfig::getLineNum)).orderByAsc(DeviceConfig::getSeqNo);
        return this.deviceConfigService.list(wrapper);
    }

    public List<DeviceConfig> getSlotConfigList() {
        Wrapper wrapper = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DeviceConfig::getDevType, (Object)DeviceClass.PHYSICALPOS.getCode())).orderByAsc(DeviceConfig::getLineNum)).orderByAsc(DeviceConfig::getSeqNo);
        return this.deviceConfigService.list(wrapper);
    }
}

