/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.statistics.TableSpaceInfo;
import com.simba.services.service.StatisticsService;
import com.simba.services.upload.status.SorterDatabaseMsg;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatabaseHelper {
    private static final Logger log = LoggerFactory.getLogger(DatabaseHelper.class);
    @Resource
    private StatisticsService statisticsService;

    public SorterDatabaseMsg createDatabaseMsg(MachineConfig machine) {
        SorterDatabaseMsg msg = new SorterDatabaseMsg();
        msg.setDevId(machine.getMachineName());
        msg.setIpAddr("192.168.8.22");
        msg.setTablespaceName(machine.getReferenceSchema());
        TableSpaceInfo spaceInfo = this.statisticsService.getTableSpaceInfo(machine.getReferenceSchema());
        if (spaceInfo == null) {
            return null;
        }
        float usedSize = spaceInfo.getUsedSize();
        float totalSize = spaceInfo.getUsedSize() + spaceInfo.getFreeSize();
        msg.setTotalSize(Integer.valueOf((int)totalSize));
        msg.setUsedSize(Integer.valueOf((int)usedSize));
        if (totalSize == 0.0f) {
            msg.setUsedRate(Float.valueOf(1.0f));
        } else {
            BigDecimal rate = new BigDecimal(usedSize / totalSize * 100.0f);
            rate = rate.setScale(2, 4);
            msg.setUsedRate(Float.valueOf(rate.floatValue()));
        }
        return msg;
    }
}

