/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.simba.services.bean.domain.BasicConfig;
import com.simba.services.bean.domain.DeviceConfig;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.domain.SorterConfig;
import com.simba.services.bean.domain.UploadData;
import com.simba.services.bean.model.BalanceWheelDeviceInfo;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.bean.model.InnerState;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.common.utils.uuid.UUID;
import com.simba.services.config.WinccConfig;
import com.simba.services.enums.RequestType;
import com.simba.services.enums.UploadDataStatus;
import com.simba.services.helper.DatabaseHelper;
import com.simba.services.helper.DeviceHelper;
import com.simba.services.helper.DeviceStatusHelper;
import com.simba.services.helper.MachineHelper;
import com.simba.services.helper.SorterHelper;
import com.simba.services.helper.StatusTranslatorHelper;
import com.simba.services.helper.UploadDataHelper;
import com.simba.services.message.balancewheel.GridPosStatus;
import com.simba.services.message.balancewheel.HeartBreak;
import com.simba.services.message.balancewheel.LineStatus;
import com.simba.services.service.BasicConfigService;
import com.simba.services.service.IStatusTranslator;
import com.simba.services.service.translator.FaultInfo;
import com.simba.services.upload.status.DeviceStatus;
import com.simba.services.upload.status.DynamicScaleMsg;
import com.simba.services.upload.status.LinesMsg;
import com.simba.services.upload.status.ObrMsg;
import com.simba.services.upload.status.PhysicalPosMsg;
import com.simba.services.upload.status.SorterMsg;
import com.simba.services.upload.status.WheelBeltMsg;
import com.simba.services.util.TokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BalanceWheelDeviceStatusHelper {
    private static final Logger log = LoggerFactory.getLogger(BalanceWheelDeviceStatusHelper.class);
    @Resource
    private WinccConfig.WorkshopConfig workshopConfig;
    @Resource
    private WinccConfig.ManufacturerConfig manufacturerConfig;
    @Resource
    private WinccConfig.DeviceStatusUploadConfig uploadConfig;
    @Resource
    private UploadDataHelper uploadDataHelper;
    @Resource
    private DatabaseHelper databaseHelper;
    @Resource
    private MachineHelper machineHelper;
    @Resource
    private DeviceHelper deviceHelper;
    @Resource
    private DeviceInfoManager deviceInfoManager;
    @Resource
    private SorterHelper sorterHelper;
    @Resource
    private StatusTranslatorHelper statusTranslatorHelper;
    @Resource
    private DeviceStatusHelper deviceStatusHelper;
    @Resource
    private BasicConfigService basicConfigService;

    public void createDeviceStatusUploadData(MachineConfig machine) {
        log.debug("\u51c6\u5907\u751f\u6210\u6446\u8f6e\u5206\u62e3\u673a\u72b6\u6001\u4e0a\u62a5\u6570\u636e\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
        Date lastTime = this.getLastTime("lastDeviceStatusUploadTime-" + machine.getMachineId());
        if (lastTime == null) {
            lastTime = new Date(new Date().getTime() - machine.getStatusSendingInterval() * 1000L);
        } else if (!this.timeExpired(lastTime, machine.getStatusSendingInterval().longValue())) {
            log.debug("\u95f4\u9694\u6216\u5468\u671f\u672a\u5230\u3002\u4e0a\u6b21\u65f6\u95f4: {}\u3002", (Object)lastTime);
            return;
        }
        BalanceWheelDeviceInfo sorterDeviceInfo = this.deviceInfoManager.getBalanceWheelDeviceInfo();
        for (String lineType : new String[]{"IL", "SL"}) {
            UploadData statusData;
            InnerState state;
            String sorterName = "\u77e9\u9635\u5206\u62e3\u673a";
            sorterName = "IL".equals(lineType) ? sorterName + "\u521d\u5206\u7ebf" : sorterName + "\u7ec6\u5206\u7ebf";
            List sorterList = this.sorterHelper.listSorter(machine.getMachineId(), lineType);
            log.debug("{} \u7ebf\u4f53\u6570\u91cf: {}\u3002", (Object)lineType, (Object)sorterList.size());
            if (CollectionUtils.isEmpty((Collection)sorterList)) {
                log.error("\u7ebf\u4f53\u5217\u8868\u4e3a\u7a7a\u3002\u7ebf\u4f53\u7c7b\u578b: {}, \u673a\u5668\u7f16\u7801: {}\u3002", (Object)lineType, (Object)machine.getMachineId());
                break;
            }
            SorterConfig sorter = (SorterConfig)sorterList.get(0);
            Integer lineNum = sorter.getLineNum();
            log.debug("\u751f\u6210\u8bbe\u5907\u72b6\u6001\u3002\u5206\u62e3\u673a\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)sorter.getSorterId());
            HeartBreak heartBreak = (HeartBreak)sorterDeviceInfo.getHeartBreakMap().get(String.valueOf(lineNum));
            if (heartBreak == null) {
                log.debug("\u8fd8\u6ca1\u6709\u6536\u5230\u5206\u62e3\u673a\u7684\u5fc3\u8df3\u3002\u5206\u62e3\u673a\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)sorter.getSorterId());
                continue;
            }
            log.debug("TODO:\u6b63\u5728\u751f\u6210 {} \u7684\u72b6\u6001\u3002\u673a\u5668\u7f16\u7801: {}\u3002", (Object)sorterName, (Object)machine.getMachineId());
            if ("IL".equals(lineType)) {
                state = sorterDeviceInfo.getInnerState();
                log.debug("TODO \u4f7f\u7528\u521d\u5206\u7ebf\u7684\u72b6\u6001\u3002isRebooted={}, isShutdown={}", (Object)state.isRebooted(), (Object)state.isShutdowned());
            } else {
                state = sorterDeviceInfo.getExtraInnerState();
                log.debug("TODO \u4f7f\u7528\u7ec6\u5206\u7ebf\u7684\u72b6\u6001: {}", (Object)JSON.toJSONString((Object)state));
            }
            log.debug("TODO heartBreak.getSystemStatus(): {}", (Object)heartBreak.getSystemStatus());
            if (1 == heartBreak.getSystemStatus() && (state.isRebooted() || state.isShutdowned())) {
                state.setShutdowned(false);
                this.deviceStatusHelper.createStatusForOnLineAndOffline(machine, lineType, sorterName, false);
                this.deviceStatusHelper.createStatusForOnLineAndOffline(machine, lineType, sorterName, true);
            }
            if ((statusData = this.createStatus(machine, sorterList, sorterDeviceInfo, lineType)) != null) {
                this.deviceStatusHelper.createEvents(machine, statusData);
                state.setRebooted(false);
            }
            if (2 != heartBreak.getSystemStatus() || state.isShutdowned()) continue;
            state.setShutdowned(true);
            state.setRebooted(false);
            this.deviceStatusHelper.createStatusForOnLineAndOffline(machine, lineType, sorterName, false);
        }
        Date newTime = new Date(lastTime.getTime() + machine.getStatusSendingInterval() * 1000L);
        this.updateLastTime("lastDeviceStatusUploadTime-" + machine.getMachineId(), newTime);
    }

    private UploadData createStatus(MachineConfig machine, List<SorterConfig> sorterList, BalanceWheelDeviceInfo sorterDeviceInfo, String sorterType) {
        SorterConfig anySorter = sorterList.get(0);
        String sorterId = sorterType;
        Date now = new Date();
        InnerState state = sorterDeviceInfo.getInnerState();
        UploadData data = new UploadData();
        DeviceStatus status = new DeviceStatus();
        status.setSorterId(machine.getMachineId());
        status.setSorterName(machine.getMachineName());
        String collectTimeStr = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss");
        status.setCollectTime(collectTimeStr);
        status.setRequestInterval(Integer.valueOf(machine.getStatusSendingInterval().intValue()));
        status.setSorterListMsg(new ArrayList());
        HeartBreak sorterHeartBreak = (HeartBreak)sorterDeviceInfo.getHeartBreakMap().get(String.valueOf(anySorter.getLineNum()));
        if (sorterHeartBreak == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u5fc3\u8df3\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
        } else {
            String deviceType = "1";
            String sorterPrefix = sorterType + ".";
            boolean isUploadAfterReboot = state.getUploadedAfterReboot(sorterPrefix + (String)deviceType);
            log.debug("getUploadedAfterReboot({}): {}", (Object)(sorterPrefix + (String)deviceType), (Object)isUploadAfterReboot);
            IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
            String devId = sorterId;
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (!isUploadAfterReboot || state.getChanged(devId)) {
                SorterMsg sorterMsg = new SorterMsg();
                sorterMsg.setDevId(devId);
                sorterMsg.setName("IL".equals(sorterType) ? "\u521d\u5206\u7ebf" : "\u7ec6\u5206\u7ebf");
                int fixedStatus = sorterHeartBreak.getSystemStatus();
                if (fixedStatus == 1) {
                    fixedStatus = 5;
                }
                String sorterStatus = translator.translate("1", fixedStatus);
                sorterMsg.setSorterStatus(sorterStatus);
                FaultInfo faultInfo = translator.translateFault(fixedStatus);
                sorterMsg.setFaultInfo(faultInfo);
                sorterMsg.setEvenFlag(Integer.valueOf(1));
                status.getSorterListMsg().add(sorterMsg);
                state.setChanged(devId, Boolean.valueOf(false));
            }
            state.setUploadedAfterReboot(sorterPrefix + (String)deviceType, Boolean.valueOf(true));
        }
        for (SorterConfig sorter : sorterList) {
            List dynamicScaleMsgList = this.createDynamicScaleMsgList(machine, sorter, sorterDeviceInfo, state);
            if (CollectionUtils.isEmpty((Collection)status.getDynamicScaleListMsg())) {
                status.setDynamicScaleListMsg(dynamicScaleMsgList);
            } else {
                status.getDynamicScaleListMsg().addAll(dynamicScaleMsgList);
            }
            status.setGrayscaleListMsg(new ArrayList());
            HeartBreak heartBreak = (HeartBreak)sorterDeviceInfo.getHeartBreakMap().get(String.valueOf(sorter.getSeqNo()));
            if (heartBreak == null) {
                log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u5fc3\u8df3\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            } else {
                LinesMsg lineStatusMsg = new LinesMsg();
                lineStatusMsg.setDevId(sorter.getSorterId());
                lineStatusMsg.setName(sorter.getSorterName());
                lineStatusMsg.setType(sorterType);
                String deviceType = "16";
                IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
                byte lineStatus = heartBreak.getSystemStatus();
                String statusStr = translator.translate("1", (int)lineStatus);
                lineStatusMsg.setSorterStatus(statusStr);
                FaultInfo faultInfo = translator.translateFault((int)lineStatus);
                lineStatusMsg.setFaultInfo(faultInfo);
                if (CollectionUtils.isEmpty((Collection)status.getLinesListMsg())) {
                    status.setLinesListMsg(new ArrayList());
                }
                status.getLinesListMsg().add(lineStatusMsg);
            }
            List obrMsgList = this.createObrStatusMsgList(machine, sorter, sorterDeviceInfo, state);
            if (CollectionUtils.isEmpty((Collection)status.getObrListMsg())) {
                status.setObrListMsg(obrMsgList);
            } else {
                status.getObrListMsg().addAll(obrMsgList);
            }
            List slotStatusMsgList = this.createSlotStatusMsgList(machine, sorter, sorterDeviceInfo, state);
            if (CollectionUtils.isEmpty((Collection)status.getPhysicalPosListMsg())) {
                status.setPhysicalPosListMsg(slotStatusMsgList);
            } else {
                status.getPhysicalPosListMsg().addAll(slotStatusMsgList);
            }
            status.setRelationDeviceListMsg(new ArrayList());
            if (CollectionUtils.isEmpty((Collection)status.getSorterDatabaseListMsg())) {
                List sorterDatabseMsgList = this.deviceStatusHelper.createSorterDatabseMsgList(machine, this.deviceInfoManager);
                status.setSorterDatabaseListMsg(sorterDatabseMsgList);
            }
            List wheelBeltMsgList = this.createWheelBeltMsgList(machine, sorter, sorterDeviceInfo, state);
            if (CollectionUtils.isEmpty((Collection)status.getWheelBeltListMsg())) {
                status.setWheelBeltListMsg(wheelBeltMsgList);
            } else {
                status.getWheelBeltListMsg().addAll(wheelBeltMsgList);
            }
            data.setRequestBody(JSON.toJSONString((Object)status));
            data.setStatusData(status);
        }
        if (!this.uploadDataHelper.hasAnyMessage(status)) {
            log.debug("\u6ca1\u6709\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u673a\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return null;
        }
        data.setFormat("JSON");
        data.setMachineId(machine.getMachineId());
        data.setManufacturerId(this.manufacturerConfig.getId());
        String requestId = UUID.randomUUID((boolean)true).toString(true);
        String requestTimeStr = TokenUtils.formatDate((Date)now);
        data.setRequestId(requestId);
        data.setRequestTime(DateUtils.dateTime((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (String)requestTimeStr));
        data.setStatus(UploadDataStatus.INIT.getCode());
        String token = TokenUtils.getToken((String)requestId, (String)requestTimeStr, (String)this.manufacturerConfig.getSecretKey());
        data.setToken(token);
        data.setType(RequestType.DEVICE_STATUS.getCode());
        data.setResponse("{}");
        this.uploadDataHelper.saveUploadData(data);
        return data;
    }

    private List<WheelBeltMsg> createWheelBeltMsgList(MachineConfig machine, SorterConfig sorter, BalanceWheelDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<WheelBeltMsg> wheelBeltMsgList = new ArrayList<WheelBeltMsg>();
        String sorterId = sorter.getSorterId();
        List beltWheelConfigList = (List)sorterDeviceInfo.getBeltWheelConfigMap().get(sorter.getSorterId());
        if (beltWheelConfigList == null) {
            log.error("\u6446\u8f6e/\u76ae\u5e26\u673a\u5b9a\u4e49\u7f3a\u5931\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return wheelBeltMsgList;
        }
        String sorterPrefix = sorter.getSorterId() + ".";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(sorterPrefix + "13");
        log.debug("getUploadedAfterReboot({}): {}", (Object)(sorterPrefix + "13"), (Object)isUploadAfterReboot);
        log.debug("\u7ebf\u4f53 {} \u7684\u8bbe\u5907\u5b9a\u4e49\u5217\u8868\u5927\u5c0f\u4e3a {}\u3002", (Object)sorterId, (Object)beltWheelConfigList.size());
        for (DeviceConfig beltWheelConfig : beltWheelConfigList) {
            LineStatus lineStatus = (LineStatus)sorterDeviceInfo.getLineStatusMap().get(String.valueOf(beltWheelConfig.getLineNum().intValue()));
            if (lineStatus == null) {
                log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u7ebf\u4f53\u72b6\u6001\u3002\u7ebf\u4f53\u53f7: {}\u3002", (Object)beltWheelConfig.getLineNum());
                continue;
            }
            byte[] statusArr = lineStatus.getStatusArr();
            int n = beltWheelConfig.getSeqNo();
            if (n > statusArr.length) {
                log.error("\u7ebf\u4f53\u72b6\u6001\u4e0b\u6807\u8d85\u51fa\u8303\u56f4: {} > {}\u3002\u8bbe\u5907\u5b9a\u4e49: {} ", new Object[]{n, statusArr.length, JSON.toJSONString((Object)beltWheelConfig)});
                continue;
            }
            log.debug("n={}, statusArr.length={}", (Object)n, (Object)statusArr.length);
            String deviceType = "BeltWheel".equals(beltWheelConfig.getDevType()) ? "13" : "14";
            IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
            String devId = beltWheelConfig.getDevId();
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            WheelBeltMsg msg = new WheelBeltMsg();
            msg.setDevId(devId);
            msg.setName(beltWheelConfig.getDevName());
            String sorterStatus = translator.translate("1", (int)statusArr[n - 1]);
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)statusArr[n - 1]);
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            wheelBeltMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(wheelBeltMsgList)) {
            state.setUploadedAfterReboot(sorterPrefix + "13", Boolean.valueOf(true));
        }
        return wheelBeltMsgList;
    }

    private List<ObrMsg> createObrStatusMsgList(MachineConfig machine, SorterConfig sorter, BalanceWheelDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<ObrMsg> obrMsgList = new ArrayList<ObrMsg>();
        HeartBreak heartBreak = (HeartBreak)sorterDeviceInfo.getHeartBreakMap().get(String.valueOf(sorter.getLineNum()));
        if (heartBreak == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u5fc3\u8df3\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorter.getSorterId());
            return obrMsgList;
        }
        List obrList = this.deviceHelper.getObrConfigList(Long.valueOf(Long.parseLong(machine.getMachineId())), sorter.getSorterId());
        if (CollectionUtils.isEmpty((Collection)obrList)) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230OBR\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorter.getSorterId());
            return obrMsgList;
        }
        log.debug("OBR\u6570\u91cf: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", new Object[]{obrList.size(), machine.getMachineId(), sorter.getSorterId()});
        String sorterPrefix = sorter.getSorterId() + ".";
        String deviceType = "4";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(sorterPrefix + deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)(sorterPrefix + deviceType), (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        for (DeviceConfig obr : obrList) {
            String devId = obr.getDevId();
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            ObrMsg msg = new ObrMsg();
            msg.setDevId(devId);
            msg.setName(obr.getDevName());
            String sorterStatus = translator.translate("1", (int)heartBreak.getCameraStatus());
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)heartBreak.getCameraStatus());
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            obrMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(obrMsgList)) {
            state.setUploadedAfterReboot(sorterPrefix + deviceType, Boolean.valueOf(true));
        }
        return obrMsgList;
    }

    private List<PhysicalPosMsg> createSlotStatusMsgList(MachineConfig machine, SorterConfig sorter, BalanceWheelDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<PhysicalPosMsg> slotStatusMsgList = new ArrayList<PhysicalPosMsg>();
        String sorterId = sorter.getSorterId();
        GridPosStatus soltStatus = (GridPosStatus)sorterDeviceInfo.getGridPosStatusMap().get(String.valueOf(sorter.getLineNum()));
        if (soltStatus == null) {
            log.debug("\u6ca1\u6709\u63a5\u6536\u5230\u683c\u53e3\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return slotStatusMsgList;
        }
        log.debug("\u683c\u53e3\u6570\u91cf: {}\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", new Object[]{soltStatus.getCount(), machine.getMachineId(), sorter.getSorterId()});
        String sorterPrefix = sorter.getSorterId() + ".";
        String deviceType = "5";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(sorterPrefix + deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)(sorterPrefix + deviceType), (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        List slotConfigList = (List)sorterDeviceInfo.getGridPosConfigMap().get(sorter.getSorterId());
        if (slotConfigList == null) {
            log.debug("\u6b64\u7ebf\u4f53\u6ca1\u6709\u683c\u53e3\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorter.getSorterId());
            return slotStatusMsgList;
        }
        byte[] statusArr = soltStatus.getStatusArr();
        for (int i = 0; i < soltStatus.getCount(); ++i) {
            if (i >= slotConfigList.size()) {
                log.error("\u683c\u53e3\u6570\u91cf\u5927\u4e8e\u683c\u53e3\u5b9a\u4e49\u6570\u91cf\u3002\u683c\u53e3\u6570\u91cf: {}, \u683c\u53e3\u5b9a\u4e49\u6570\u91cf: {}\u3002", (Object)soltStatus);
                break;
            }
            DeviceConfig slotConfig = (DeviceConfig)slotConfigList.get(i);
            String devId = slotConfig.getDevId();
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            PhysicalPosMsg msg = new PhysicalPosMsg();
            msg.setDevId(devId);
            msg.setName(slotConfig.getDevName());
            String sorterStatus = translator.translate("1", (int)statusArr[i]);
            msg.setSorterStatus(sorterStatus);
            FaultInfo faultInfo = translator.translateFault((int)statusArr[i]);
            msg.setFaultInfo(faultInfo);
            msg.setEvenFlag(Integer.valueOf(1));
            slotStatusMsgList.add(msg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(slotStatusMsgList)) {
            state.setUploadedAfterReboot(sorterPrefix + deviceType, Boolean.valueOf(true));
        }
        return slotStatusMsgList;
    }

    private List<DynamicScaleMsg> createDynamicScaleMsgList(MachineConfig machine, SorterConfig sorter, BalanceWheelDeviceInfo sorterDeviceInfo, InnerState state) {
        ArrayList<DynamicScaleMsg> dynamicScaleMsgList = new ArrayList<DynamicScaleMsg>();
        String sorterId = sorter.getSorterId();
        List dynamicScaleList = this.deviceHelper.getDynamicScaleConfigList(sorter.getMachineId(), sorterId);
        if (CollectionUtils.isEmpty((Collection)dynamicScaleList)) {
            log.debug("\u5f53\u524d\u5206\u62e3\u673a\u65e0\u52a8\u6001\u79e4\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
            return dynamicScaleMsgList;
        }
        String deviceType = "6";
        String sorterPrefix = sorter.getSorterId() + ".";
        boolean isUploadAfterReboot = state.getUploadedAfterReboot(sorterPrefix + deviceType);
        log.debug("getUploadedAfterReboot({}): {}", (Object)(sorterPrefix + deviceType), (Object)isUploadAfterReboot);
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        for (DeviceConfig ds : dynamicScaleList) {
            int originalStatus;
            LineStatus lineStatus = (LineStatus)sorterDeviceInfo.getLineStatusMap().get(String.valueOf(ds.getLineNum()));
            if (lineStatus == null) {
                log.debug("\u5c1a\u672a\u6536\u5230\u7ebf\u4f53\u72b6\u6001\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u8bbe\u5907\u7f16\u7801: {}\u3002", (Object)machine.getMachineId(), (Object)sorterId);
                continue;
            }
            byte[] statusArr = lineStatus.getStatusArr();
            int i = ds.getSeqNo() - 1;
            if (statusArr.length < ds.getSeqNo()) {
                log.error("\u52a8\u6001\u79e4\u72b6\u6001\u4e0b\u6807\u6ea2\u51fa\u9519\u8bef\u3002\u72b6\u6001\u6570\u7ec4\u957f\u5ea6: {}, \u52a8\u6001\u79e4\u4e0b\u6807: {}\u3002", (Object)statusArr.length, (Object)i);
                continue;
            }
            String devId = ds.getDevId();
            log.debug("getChanged({}): {}", (Object)devId, (Object)state.getChanged(devId));
            if (isUploadAfterReboot && !state.getChanged(devId)) continue;
            DynamicScaleMsg dynamicScaleMsg = new DynamicScaleMsg();
            dynamicScaleMsg.setDevId(devId);
            dynamicScaleMsg.setName(ds.getDevName());
            int fixedStatus = originalStatus = statusArr[i];
            if (originalStatus != 0) {
                fixedStatus = originalStatus == 4 || originalStatus == 5 || originalStatus == 10 ? 1 : 2;
            }
            String statusStr = translator.translate("1", fixedStatus);
            dynamicScaleMsg.setSorterStatus(statusStr);
            FaultInfo faultInfo = translator.translateFault(fixedStatus);
            dynamicScaleMsg.setFaultInfo(faultInfo);
            dynamicScaleMsg.setHostDevId(ds.getDevId());
            dynamicScaleMsgList.add(dynamicScaleMsg);
            state.setChanged(devId, Boolean.valueOf(false));
        }
        if (CollectionUtils.isNotEmpty(dynamicScaleMsgList)) {
            state.setUploadedAfterReboot(sorterPrefix + deviceType, Boolean.valueOf(true));
        }
        return dynamicScaleMsgList;
    }

    private Date getLastTime(String key) {
        Wrapper wrapper = (Wrapper)Wrappers.lambdaQuery().eq(BasicConfig::getBasickey, (Object)key);
        BasicConfig config = (BasicConfig)this.basicConfigService.getOne(wrapper);
        if (config == null) {
            log.info("\u4e0a\u6b21\u65f6\u95f4\u672a\u914d\u7f6e: {}\u3002", (Object)key);
            return null;
        }
        String value = config.getBasicvalue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            log.info("\u4e0a\u6b21\u65f6\u95f4\u672a\u914d\u7f6e: {}\u3002", (Object)key);
            return null;
        }
        try {
            Date lastTime = DateUtils.dateTime((String)"yyyy-MM-dd HH:mm:ss", (String)value);
            return lastTime;
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef: {}\u3002", (Object)value);
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean timeExpired(@NotNull Date lastTime, long intervalSeconds) {
        long diffMillSeconds = System.currentTimeMillis() - lastTime.getTime();
        return diffMillSeconds >= intervalSeconds;
    }

    private void updateLastTime(String key, Date lastTime) {
        Wrapper wrapper = (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(BasicConfig::getBasicvalue, (Object)DateFormatUtils.format((Date)lastTime, (String)"yyyy-MM-dd HH:mm:ss"))).eq(BasicConfig::getBasickey, (Object)key);
        this.basicConfigService.update(wrapper);
    }
}

