/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.handler;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.bean.model.InnerState;
import com.simba.services.bean.model.SorterDeviceInfo;
import com.simba.services.config.WinccConfig;
import com.simba.services.helper.DeviceStatusHelper;
import com.simba.services.helper.MachineHelper;
import com.simba.services.helper.SorterHelper;
import com.simba.services.message.SorterDeviceMessage;
import com.simba.services.message.sorter.CarrierLocation;
import com.simba.services.message.sorter.CarrierStatus;
import com.simba.services.message.sorter.ElectricMotorStatus;
import com.simba.services.message.sorter.EmergencyStopStatus;
import com.simba.services.message.sorter.GridPosStatus;
import com.simba.services.message.sorter.HeartBreak;
import com.simba.services.message.sorter.InductStatus;
import com.simba.services.message.sorter.PlcStatus;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SorterDeviceMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(SorterDeviceMessageHandler.class);
    private Set<String> plcIpList = new HashSet();
    @Resource
    private DeviceInfoManager deviceInfoManager;
    @Resource
    private SorterHelper sorterHelper;
    @Resource
    private WinccConfig.WorkshopConfig config;
    @Resource
    private DeviceStatusHelper deviceStatusHelper;
    @Resource
    private MachineHelper machineHelper;

    @PostConstruct
    private void init() {
        List machineList = this.machineHelper.getMachineList();
        if (CollectionUtils.isEmpty((Collection)machineList)) {
            log.error("\u672a\u914d\u7f6e\u4efb\u4f55\u5206\u62e3\u673a\u7684\u4e0a\u62a5\u6e90IP\u3002");
            return;
        }
        for (MachineConfig machine : machineList) {
            String plcIp = machine.getPlcIp();
            if (StringUtils.isEmpty((CharSequence)plcIp)) {
                log.warn("\u672a\u914d\u7f6e\u4e0a\u62a5\u6e90IP\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
                continue;
            }
            this.plcIpList.add(plcIp);
        }
    }

    public void onDeviceMessageReceived(SorterDeviceMessage msg, ChannelHandlerContext ctx) {
        String remoteAddressInfo = ctx.channel().remoteAddress().toString();
        SorterDeviceInfo sorterDeviceInfo = this.getSorterDeviceInfo(remoteAddressInfo);
        byte command = msg.getCommand();
        if (command == 48) {
            this.onCarrierStatusReceived(msg, sorterDeviceInfo);
        } else if (command == 49) {
            this.onGridPosStatusReceived(msg, sorterDeviceInfo);
        } else if (command == 50) {
            this.onInductStatusReceived(msg, sorterDeviceInfo);
        } else if (command == 51) {
            this.onEmergencyStopStatusReceived(msg, sorterDeviceInfo);
        } else if (command == 52) {
            this.onElectricMotorStatusReceived(msg, sorterDeviceInfo);
        } else if (command == 53) {
            this.onPlcStatusReceived(msg, sorterDeviceInfo);
        } else if (command == 54) {
            this.onHeartBreakReceived(msg, sorterDeviceInfo);
        } else if (command == 96) {
            this.onInductDeletionReceived(msg, sorterDeviceInfo);
        } else if (command == 97) {
            this.onInductCheckReceived(msg, sorterDeviceInfo);
        } else if (command == 103) {
            this.onCarrierLocationReceived(msg, sorterDeviceInfo);
        } else {
            log.error("\u4e0d\u652f\u6301\u7684\u5206\u62e3\u673a\u8bbe\u5907\u6d88\u606f\u547d\u4ee4\u5b57: {}\u3002", (Object)command);
        }
    }

    private SorterDeviceInfo getSorterDeviceInfo(String remoteAddressInfo) {
        String ip = null;
        for (String plcIp : this.plcIpList) {
            if (!remoteAddressInfo.contains(plcIp + ":")) continue;
            ip = plcIp;
            break;
        }
        if (StringUtils.isEmpty(ip)) {
            log.error("\u4e0d\u652f\u6301\u7684\u8fde\u63a5\u6e90: {}\u3002" + remoteAddressInfo);
            return null;
        }
        SorterDeviceInfo info = (SorterDeviceInfo)this.deviceInfoManager.getSorterDeviceInfoMap().get(ip);
        if (info == null) {
            info = new SorterDeviceInfo();
            this.deviceInfoManager.getSorterDeviceInfoMap().put(ip, info);
        }
        return info;
    }

    private void onCarrierStatusReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        CarrierStatus payload = (CarrierStatus)msg.getPayload();
        CarrierStatus oldOne = sorterDeviceInfo.getCarrierStatus();
        sorterDeviceInfo.setCarrierStatus(payload);
        InnerState state = sorterDeviceInfo.getInnerState();
        String sorterPrefix = "ST01.";
        if (oldOne == null) {
            int n = payload.getCount();
            log.debug("\u7b2c\u4e00\u6b21\u63a5\u6536\u5230\u5c0f\u8f66\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                String devId = sorterPrefix + "CR" + String.format("%04d", i + 1);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        } else {
            int n = payload.getCount();
            if (n != oldOne.getCount()) {
                log.warn("\u5c0f\u8f66\u6570\u91cf\u6709\u53d8\u5316\u3002\u539f\u6570\u91cf: {}, \u76ee\u524d\u6570\u91cf: {}\u3002", (Object)oldOne.getCount(), (Object)n);
                n = Math.max(n, oldOne.getCount());
            }
            log.debug("\u63a5\u6536\u5230\u5c0f\u8f66\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                byte oldStatus;
                String devId = sorterPrefix + "CR" + String.format("%04d", i + 1);
                byte newStatus = payload.getStatusArr()[i];
                if (newStatus == (oldStatus = oldOne.getStatusArr()[i])) continue;
                log.debug("\u5c0f\u8f66\u72b6\u6001\u53d8\u5316\u524d: {}, \u53d8\u5316\u540e: {}\u3002", (Object)oldStatus, (Object)newStatus);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        }
    }

    private void onGridPosStatusReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        GridPosStatus payload = (GridPosStatus)msg.getPayload();
        GridPosStatus oldOne = sorterDeviceInfo.getGridPosStatus();
        sorterDeviceInfo.setGridPosStatus(payload);
        InnerState state = sorterDeviceInfo.getInnerState();
        String sorterPrefix = "ST01.";
        if (oldOne == null) {
            int n = payload.getCount();
            log.debug("\u7b2c\u4e00\u6b21\u63a5\u6536\u5230\u683c\u53e3\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                String devId = sorterPrefix + "PP" + String.format("%04d", i + 1);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        } else {
            int n = payload.getCount();
            if (n != oldOne.getCount()) {
                log.warn("\u683c\u53e3\u6570\u91cf\u6709\u53d8\u5316\u3002\u539f\u6570\u91cf: {}, \u76ee\u524d\u6570\u91cf: {}\u3002", (Object)oldOne.getCount(), (Object)n);
                n = Math.max(n, oldOne.getCount());
            }
            log.debug("\u63a5\u6536\u5230\u683c\u53e3\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                byte oldStatus;
                String devId = sorterPrefix + "PP" + String.format("%04d", i + 1);
                byte newStatus = payload.getStatusArr()[i];
                if (newStatus == (oldStatus = oldOne.getStatusArr()[i])) continue;
                log.debug("\u683c\u53e3\u72b6\u6001\u53d8\u5316\u524d: {}, \u53d8\u5316\u540e: {}\u3002", (Object)oldStatus, (Object)newStatus);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        }
    }

    private void onInductStatusReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        InductStatus payload = (InductStatus)msg.getPayload();
        InductStatus oldOne = sorterDeviceInfo.getInductStatus();
        sorterDeviceInfo.setInductStatus(payload);
        InnerState state = sorterDeviceInfo.getInnerState();
        String sorterPrefix = "ST01.";
        if (oldOne == null) {
            int n = payload.getCount();
            log.debug("\u7b2c\u4e00\u6b21\u63a5\u6536\u5230\u4f9b\u4ef6\u53f0\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                String devId = sorterPrefix + "ID" + String.format("%04d", i + 1);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        } else {
            int n = payload.getCount();
            if (n != oldOne.getCount()) {
                log.warn("\u4f9b\u4ef6\u53f0\u6570\u91cf\u6709\u53d8\u5316\u3002\u539f\u6570\u91cf: {}, \u76ee\u524d\u6570\u91cf: {}\u3002", (Object)oldOne.getCount(), (Object)n);
                n = Math.max(n, oldOne.getCount());
            }
            log.debug("\u63a5\u6536\u5230\u4f9b\u4ef6\u53f0\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                byte oldStatus;
                String devId = sorterPrefix + "ID" + String.format("%04d", i + 1);
                byte newStatus = payload.getStatusArr()[i];
                if (newStatus == (oldStatus = oldOne.getStatusArr()[i])) continue;
                log.debug("\u4f9b\u4ef6\u53f0\u72b6\u6001\u53d8\u5316\u524d: {}, \u53d8\u5316\u540e: {}\u3002", (Object)oldStatus, (Object)newStatus);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        }
    }

    private void onElectricMotorStatusReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        ElectricMotorStatus payload = (ElectricMotorStatus)msg.getPayload();
        ElectricMotorStatus oldOne = sorterDeviceInfo.getElectricMotorStatus();
        sorterDeviceInfo.setElectricMotorStatus(payload);
        InnerState state = sorterDeviceInfo.getInnerState();
        String sorterPrefix = "ST01.";
        if (oldOne == null) {
            int n = payload.getCount();
            log.debug("\u7b2c\u4e00\u6b21\u63a5\u6536\u5230\u76f4\u7ebf\u7535\u673a\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                String devId = sorterPrefix + "EM" + String.format("%04d", i + 1);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        } else {
            int n = payload.getCount();
            if (n != oldOne.getCount()) {
                log.warn("\u76f4\u7ebf\u7535\u673a\u6570\u91cf\u6709\u53d8\u5316\u3002\u539f\u6570\u91cf: {}, \u76ee\u524d\u6570\u91cf: {}\u3002", (Object)oldOne.getCount(), (Object)n);
                n = Math.max(n, oldOne.getCount());
            }
            log.debug("\u63a5\u6536\u5230\u76f4\u7ebf\u7535\u673a\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                byte oldStatus;
                String devId = sorterPrefix + "EM" + String.format("%04d", i + 1);
                byte newStatus = payload.getStatusArr()[i];
                if (newStatus == (oldStatus = oldOne.getStatusArr()[i])) continue;
                log.debug("\u76f4\u7ebf\u7535\u673a\u72b6\u6001\u53d8\u5316\u524d: {}, \u53d8\u5316\u540e: {}\u3002", (Object)oldStatus, (Object)newStatus);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        }
    }

    private void onEmergencyStopStatusReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        EmergencyStopStatus payload = (EmergencyStopStatus)msg.getPayload();
        EmergencyStopStatus oldOne = sorterDeviceInfo.getEmergencyStopStatus();
        sorterDeviceInfo.setEmergencyStopStatus(payload);
        sorterDeviceInfo.setEmergencyStopStatus(payload);
        InnerState state = sorterDeviceInfo.getInnerState();
        if (state.isRebooted() && !state.getUploadedAfterReboot("EmergencyStop") || oldOne == null) {
            // empty if block
        }
    }

    private void onPlcStatusReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        PlcStatus payload = (PlcStatus)msg.getPayload();
        PlcStatus oldOne = sorterDeviceInfo.getPlcStatus();
        sorterDeviceInfo.setPlcStatus(payload);
        sorterDeviceInfo.setPlcStatus(payload);
        InnerState state = sorterDeviceInfo.getInnerState();
        if (state.isRebooted() && !state.getUploadedAfterReboot("Plc") || oldOne == null) {
            // empty if block
        }
    }

    private void onHeartBreakReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        HeartBreak payload = (HeartBreak)msg.getPayload();
        HeartBreak oldOne = sorterDeviceInfo.getHeartBreak();
        sorterDeviceInfo.setHeartBreak(payload);
        InnerState state = sorterDeviceInfo.getInnerState();
        if (oldOne == null) {
            log.debug("\u6ca1\u6709\u65e7\u72b6\u6001\uff0c\u89c6\u4f5c\u5206\u62e3\u673a\u91cd\u542f\u3002");
            state.setRebooted(true);
            state.setChanged("ST01", Boolean.valueOf(true));
        } else if (payload.getSystemStatus() != oldOne.getSystemStatus()) {
            log.debug("\u5206\u62e3\u673a\u72b6\u6001\u5df2\u53d8\u5316\u3002\u65e7\u72b6\u6001: {}\uff0c\u65b0\u72b6\u6001: {}\u3002", (Object)oldOne.getSystemStatus(), (Object)payload.getSystemStatus());
            if (payload.getSystemStatus() == 1) {
                log.info("\u5206\u62e3\u673a\u5f00\u673a\u3002");
                state.setRebooted(true);
            } else if (payload.getSystemStatus() == 6) {
                log.info("\u5206\u62e3\u673a\u542f\u52a8\u3002");
                state.setRebooted(true);
            } else if (payload.getSystemStatus() == 2) {
                log.info("\u5206\u62e3\u673a\u5173\u673a\u3002");
                state.setRebooted(false);
            } else {
                state.setChanged("ST01", Boolean.valueOf(true));
            }
        } else {
            log.debug("\u5206\u62e3\u673a\u72b6\u6001\u6ca1\u6709\u53d8\u5316: {}\u3002", (Object)payload.getSystemStatus());
        }
    }

    private void onInductDeletionReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        log.info("\u5ffd\u7565\u6536\u5230\u7684\u4f9b\u4ef6\u53f0\u5254\u9664\u6d88\u606f: {}\u3002", (Object)JSON.toJSONString((Object)msg));
    }

    private void onInductCheckReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        log.info("\u5ffd\u7565\u6536\u5230\u7684\u4f9b\u4ef6\u53f0\u6821\u9a8c\u6d88\u606f: {}\u3002", (Object)JSON.toJSONString((Object)msg));
    }

    private void onCarrierLocationReceived(SorterDeviceMessage msg, SorterDeviceInfo sorterDeviceInfo) {
        CarrierLocation payload = (CarrierLocation)msg.getPayload();
        sorterDeviceInfo.getCarrierLocationMap().put(String.valueOf(payload.getDeviceNum()), payload);
    }
}

