/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.handler;

import com.alibaba.fastjson.JSON;
import com.simba.services.handler.BalanceWheelDeviceMessageHandler;
import com.simba.services.handler.SorterDeviceMessageHandler;
import com.simba.services.message.AbstractDeviceMessage;
import com.simba.services.message.BalanceWheelDeviceMessage;
import com.simba.services.message.SorterDeviceMessage;
import io.netty.channel.ChannelHandlerContext;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PlcMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(PlcMessageHandler.class);
    @Resource
    private BalanceWheelDeviceMessageHandler balanceWheelDeviceMessageHandler;
    @Resource
    private SorterDeviceMessageHandler sorterDeviceMessageHandler;

    public void onDeviceMessageReceived(AbstractDeviceMessage msg, ChannelHandlerContext ctx) {
        log.info("\u4ece {} \u6536\u5230\u6d88\u606f: {}\u3002", (Object)ctx.channel().remoteAddress().toString(), (Object)JSON.toJSONString((Object)msg));
        if (msg instanceof BalanceWheelDeviceMessage) {
            this.balanceWheelDeviceMessageHandler.onDeviceMessageReceived((BalanceWheelDeviceMessage)msg, ctx);
        } else if (msg instanceof SorterDeviceMessage) {
            this.sorterDeviceMessageHandler.onDeviceMessageReceived((SorterDeviceMessage)msg, ctx);
        } else {
            log.error("Unknown message type: {}. Only the type of BalanceWheelDeviceMessage and SorterDeviceMessage can be hanndled.", (Object)msg.getClass().getSimpleName());
        }
    }
}

