/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.handler;

import com.simba.services.bean.domain.DeviceConfig;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.bean.model.InnerState;
import com.simba.services.helper.DeviceHelper;
import com.simba.services.helper.SorterHelper;
import com.simba.services.message.BalanceWheelDeviceMessage;
import com.simba.services.message.balancewheel.EmergencyStopStatus;
import com.simba.services.message.balancewheel.GridPosStatus;
import com.simba.services.message.balancewheel.HeartBreak;
import com.simba.services.message.balancewheel.LineStatus;
import com.simba.services.message.balancewheel.OverheadDoorStatus;
import com.simba.services.message.balancewheel.PhotoEletricStatus;
import com.simba.services.message.balancewheel.RemoteIoCommStatus;
import com.simba.services.server.MyServerHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BalanceWheelDeviceMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(BalanceWheelDeviceMessageHandler.class);
    @Resource
    private DeviceInfoManager deviceInfoManager;
    @Resource
    private DeviceHelper deviceHelper;
    @Resource
    private SorterHelper sorterHelper;

    public void onDeviceMessageReceived(BalanceWheelDeviceMessage msg, ChannelHandlerContext ctx) {
        byte command = msg.getCommand();
        if (command == -128) {
            this.onHeartBreakReceived(msg, ctx);
        } else if (command == -127) {
            this.onLineStatusReceived(msg);
        } else if (command == -126) {
            this.onEmergencyStopStatusReceived(msg);
        } else if (command == -125) {
            this.onOverheadDoorStatusReceived(msg);
        } else if (command == -124) {
            this.onRemoteIoCommStatusReceived(msg);
        } else if (command == -122) {
            this.onGridPosStatusReceived(msg);
        } else if (command == -121) {
            this.onPhotoEletricStatusReceived(msg);
        } else {
            log.error("\u4e0d\u652f\u6301\u7684\u6446\u8f6e\u8bbe\u5907\u6d88\u606f\u547d\u4ee4\u5b57: {}\u3002", (Object)command);
        }
    }

    private void onHeartBreakReceived(BalanceWheelDeviceMessage msg, ChannelHandlerContext ctx) {
        HeartBreak payload = (HeartBreak)msg.getPayload();
        MyServerHandler.CHANNEL_ID_MAP.put(String.valueOf(payload.getLineNum()), ctx.channel().id());
        String lineNumStr = String.valueOf(payload.getLineNum());
        HeartBreak oldOne = (HeartBreak)this.deviceInfoManager.getBalanceWheelDeviceInfo().getHeartBreakMap().get(lineNumStr);
        this.deviceInfoManager.getBalanceWheelDeviceInfo().getHeartBreakMap().put(lineNumStr, payload);
        InnerState state = this.deviceInfoManager.getBalanceWheelDeviceInfo().getInnerState();
        if (oldOne == null) {
            log.debug("\u6ca1\u6709\u65e7\u72b6\u6001\uff0c\u89c6\u4f5c\u5206\u62e3\u673a\u91cd\u542f\u3002");
            state.setRebooted(true);
            state.setChanged(lineNumStr, Boolean.valueOf(true));
        } else if (oldOne.getSystemStatus() != payload.getSystemStatus()) {
            if (payload.getSystemStatus() == 1) {
                log.info("\u5206\u62e3\u673a\u5728\u7ebf\u3002");
                state.setRebooted(true);
            } else if (payload.getSystemStatus() == 2) {
                log.info("\u5206\u62e3\u673a\u79bb\u7ebf\u3002");
                state.setShutdowned(true);
            } else {
                log.error("\u672a\u77e5\u7684\u5206\u62e3\u673a\u72b6\u6001: {}\u3002", (Object)payload.getSystemStatus());
            }
        } else {
            log.debug("\u5206\u62e3\u673a\u72b6\u6001\u6ca1\u6709\u53d8\u5316: {}\u3002", (Object)payload.getSystemStatus());
        }
        if (oldOne != null && oldOne.getCameraStatus() != payload.getCameraStatus()) {
            List obrList = this.deviceHelper.getBalanceWheelObrConfigList(payload.getLineNum());
            if (CollectionUtils.isEmpty((Collection)obrList)) {
                log.debug("\u6b64\u7ebf\u4f53\u6ca1\u6709OBR\u3002\u7ebf\u4f53\u53f7: {}\u3002", (Object)lineNumStr);
            } else {
                for (DeviceConfig obr : obrList) {
                    state.setChanged(obr.getDevId(), Boolean.valueOf(true));
                }
            }
        }
    }

    private void onLineStatusReceived(BalanceWheelDeviceMessage msg) {
        LineStatus payload = (LineStatus)msg.getPayload();
        Long lineNum = new Long(payload.getLineNum());
        LineStatus oldOne = (LineStatus)this.deviceInfoManager.getBalanceWheelDeviceInfo().getLineStatusMap().get(String.valueOf(lineNum));
        this.deviceInfoManager.getBalanceWheelDeviceInfo().getLineStatusMap().put(String.valueOf(lineNum), payload);
        if (oldOne != null) {
            int n;
            byte[] statusArr = payload.getStatusArr();
            if (statusArr == null | (n = statusArr.length) == 0) {
                log.error("\u7ebf\u4f53\u72b6\u6001\u5217\u8868\u4e3a\u7a7a\u3002\u7ebf\u4f53\u53f7: {}\u3002", (Object)lineNum);
                return;
            }
            log.debug("\u7ebf\u4f53\u72b6\u6001\u957f\u5ea6\u4e3a {}\u3002\u7ebf\u4f53\u53f7: {}\u3002", (Object)n, (Object)lineNum);
            Map beltWheelConfigMap = (Map)this.deviceInfoManager.getBalanceWheelDeviceInfo().getBeltWheelConfigMapWithLineNum().get(lineNum);
            if (beltWheelConfigMap == null) {
                log.warn("\u6446\u8f6e-\u76ae\u5e26\u673a\u5b9a\u4e49\u4e3a\u7a7a\u3002\u7ebf\u4f53\u53f7: {}\u3002", (Object)lineNum);
                return;
            }
            InnerState state = this.deviceInfoManager.getBalanceWheelDeviceInfo().getInnerState();
            for (int i = 0; i < n; ++i) {
                if (statusArr[i] == oldOne.getStatusArr()[i]) continue;
                log.debug("\u6446\u8f6e-\u76ae\u5e26\u673a\u72b6\u6001\u5df2\u53d8\u5316\u3002\u53d8\u5316\u524d: {}, \u53d8\u5316\u540e: {}\u3002\u7ebf\u4f53\u53f7: {}, \u5e8f\u53f7: {}\u3002", new Object[]{oldOne.getStatusArr()[i], statusArr[i], lineNum, i + 1});
                DeviceConfig beltWheelConfig = (DeviceConfig)beltWheelConfigMap.get(i + 1);
                if (beltWheelConfig == null) {
                    log.warn("\u627e\u4e0d\u5230\u6446\u8f6e-\u76ae\u5e26\u673a\u7684\u5b9a\u4e49\u3002\u7ebf\u4f53\u53f7: {}, \u5e8f\u53f7: {}\u3002", (Object)lineNum, (Object)(i + 1));
                    continue;
                }
                state.setChanged(beltWheelConfig.getDevId(), Boolean.valueOf(true));
            }
        }
    }

    private void onEmergencyStopStatusReceived(BalanceWheelDeviceMessage msg) {
        EmergencyStopStatus payload = (EmergencyStopStatus)msg.getPayload();
        this.deviceInfoManager.getBalanceWheelDeviceInfo().getEmergencyStopStatusMap().put(String.valueOf(payload.getLineNum()), payload);
    }

    private void onOverheadDoorStatusReceived(BalanceWheelDeviceMessage msg) {
        OverheadDoorStatus payload = (OverheadDoorStatus)msg.getPayload();
        this.deviceInfoManager.getBalanceWheelDeviceInfo().getOverheadDoorStatusMap().put(String.valueOf(payload.getLineNum()), payload);
    }

    private void onRemoteIoCommStatusReceived(BalanceWheelDeviceMessage msg) {
        RemoteIoCommStatus payload = (RemoteIoCommStatus)msg.getPayload();
        this.deviceInfoManager.getBalanceWheelDeviceInfo().getRemoteIoCommStatusMap().put(String.valueOf(payload.getLineNum()), payload);
    }

    private void onGridPosStatusReceived(BalanceWheelDeviceMessage msg) {
        GridPosStatus payload = (GridPosStatus)msg.getPayload();
        String lineNumStr = String.valueOf(payload.getLineNum());
        GridPosStatus oldOne = (GridPosStatus)this.deviceInfoManager.getBalanceWheelDeviceInfo().getGridPosStatusMap().get(lineNumStr);
        this.deviceInfoManager.getBalanceWheelDeviceInfo().getGridPosStatusMap().put(lineNumStr, payload);
        InnerState state = this.deviceInfoManager.getBalanceWheelDeviceInfo().getInnerState();
        String sorterPrefix = lineNumStr + ".";
        if (oldOne == null) {
            int n = payload.getCount();
            log.debug("\u7b2c\u4e00\u6b21\u63a5\u6536\u5230\u683c\u53e3\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                String devId = sorterPrefix + "PP" + String.format("%04d", i + 1);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        } else {
            int n = payload.getCount();
            if (n != oldOne.getCount()) {
                log.warn("\u683c\u53e3\u6570\u91cf\u6709\u53d8\u5316\u3002\u539f\u6570\u91cf: {}, \u76ee\u524d\u6570\u91cf: {}\u3002", (Object)oldOne.getCount(), (Object)n);
                n = Math.max(n, oldOne.getCount());
            }
            log.debug("\u63a5\u6536\u5230\u683c\u53e3\u72b6\u6001\u3002\u6570\u91cf\u4e3a {}\u3002", (Object)n);
            for (int i = 0; i < n; ++i) {
                byte oldStatus;
                String devId = sorterPrefix + "PP" + String.format("%04d", i + 1);
                byte newStatus = payload.getStatusArr()[i];
                if (newStatus == (oldStatus = oldOne.getStatusArr()[i])) continue;
                log.debug("\u683c\u53e3\u72b6\u6001\u53d8\u5316\u524d: {}, \u53d8\u5316\u540e: {}\u3002", (Object)oldStatus, (Object)newStatus);
                state.setChanged(devId, Boolean.valueOf(true));
            }
        }
    }

    private void onPhotoEletricStatusReceived(BalanceWheelDeviceMessage msg) {
        PhotoEletricStatus payload = (PhotoEletricStatus)msg.getPayload();
        this.deviceInfoManager.getBalanceWheelDeviceInfo().getPhotoEletricStatusMap().put(String.valueOf(payload.getLineNum()), payload);
    }
}

