/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.controller;

import com.simba.services.bean.domain.UploadData;
import com.simba.services.common.annotation.Log;
import com.simba.services.common.core.controller.BaseController;
import com.simba.services.common.enums.BusinessType;
import com.simba.services.common.utils.poi.ExcelUtil;
import com.simba.services.common.utils.sql.core.domain.AjaxResult;
import com.simba.services.common.utils.sql.core.page.TableDataInfo;
import com.simba.services.service.UploadDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u4e0a\u4f20\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/upload-data"})
public class UploadDataController
extends BaseController {
    private UploadDataService uploadDataService;

    @ApiOperation(value="\u67e5\u8be2\u673a\u5668\u5217\u8868", notes="\u67e5\u8be2\u673a\u5668\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(UploadData tmUploadData) {
        this.startPage();
        List list = this.uploadDataService.findTmUploadDataList(tmUploadData);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5bfc\u51fa\u673a\u5668\u5217\u8868", notes="\u5bfc\u51fa\u673a\u5668\u5217\u8868")
    @Log(title="\u673a\u5668", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, UploadData tmUploadData) {
        List list = this.uploadDataService.findTmUploadDataList(tmUploadData);
        ExcelUtil util = new ExcelUtil(UploadData.class);
        util.exportExcel(response, list, "\u673a\u5668\u6570\u636e");
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u5668\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u673a\u5668\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.uploadDataService.findTmUploadDataById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u673a\u5668", notes="\u65b0\u589e\u673a\u5668")
    @Log(title="\u673a\u5668", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody UploadData tmUploadData) {
        return this.toAjax(this.uploadDataService.saveTmUploadData(tmUploadData));
    }

    @ApiOperation(value="\u4fee\u6539\u673a\u5668", notes="\u4fee\u6539\u673a\u5668")
    @Log(title="\u673a\u5668", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody UploadData tmUploadData) {
        return this.toAjax(this.uploadDataService.editTmUploadData(tmUploadData));
    }

    @ApiOperation(value="\u5220\u9664\u673a\u5668", notes="\u5220\u9664\u673a\u5668")
    @Log(title="\u673a\u5668", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.uploadDataService.removeTmUploadDataByIds(ids));
    }

    @PostMapping(value={"/device-status"})
    public AjaxResult uploadDeviceStatus(@RequestParam(value="name") String name) {
        return null;
    }

    public UploadDataController(UploadDataService uploadDataService) {
        this.uploadDataService = uploadDataService;
    }
}

