/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.controller;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.simba.services.bean.request.CommonReq;
import com.simba.services.bean.request.SysConfig;
import com.simba.services.bean.response.CommonRes;
import com.simba.services.config.WinccConfig;
import com.simba.services.exception.ParameterCheckException;
import com.simba.services.helper.SysSettingHelper;
import com.simba.services.util.TokenUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys-setting"})
public class SysSettingController {
    private static final Logger log = LoggerFactory.getLogger(SysSettingController.class);
    @Resource
    private WinccConfig.ManufacturerConfig manufacturerConfig;
    @Resource
    private SysSettingHelper sysSettingHelper;

    @PostMapping
    public CommonRes changeSetting(@ModelAttribute CommonReq req) {
        log.info("\u6536\u5230\u53c2\u6570\u914d\u7f6e\u6570\u636e: {}\u3002", (Object)JSON.toJSONString((Object)req));
        try {
            try {
                this.checkParameters(req);
                String requestId = req.getRequest_id().trim();
                if (this.sysSettingHelper.saveRequest(req)) {
                    log.info("\u91cd\u590d\u63a5\u6536\uff0c\u76f4\u63a5\u53d1\u9001\u54cd\u5e94");
                    CommonRes res = this.makeSuccessResponse(requestId);
                    return res;
                }
                String body = req.getRequest_body();
                SysConfig sysSettingParameter = (SysConfig)JSON.parseObject((String)body, SysConfig.class);
                this.sysSettingHelper.changeSysSetting(sysSettingParameter);
                CommonRes res = this.makeSuccessResponse(requestId);
                this.sysSettingHelper.saveResponse(req.getRequest_id(), res);
                return res;
            }
            catch (ParameterCheckException e) {
                return e.getRes();
            }
        }
        catch (Throwable t) {
            log.debug(t.getMessage(), t);
            log.error("\u68c0\u67e5\u53c2\u6570\u65f6\u672a\u77e5\u5f02\u5e38\u53d1\u751f: {}\u3002", (Object)t.getMessage());
            return this.makeFailureResponse(req.getRequest_id(), t);
        }
    }

    private CommonRes makeSuccessResponse(String requestId) {
        CommonRes res = new CommonRes();
        res.setRequestId(requestId);
        res.setStatus(0);
        return res;
    }

    private CommonRes makeFailureResponse(String requestId, Throwable t) {
        CommonRes res = new CommonRes();
        res.setRequestId(requestId);
        res.setStatus(-1);
        res.setErrorCode(9999);
        res.setErrorMsg("\u672a\u77e5\u9519\u8bef");
        return res;
    }

    private void checkParameters(CommonReq req) {
        String realToken;
        String requestTime;
        String requestBody;
        String format;
        String manufacturerId;
        int maxLen;
        int n;
        String requestId;
        if (req.getRequest_id() == null || req.getManufacturer_id() == null || req.getFormat() == null || req.getToken() == null || req.getRequest_time() == null || req.getRequest_body() == null) {
            log.error("\u7f3a\u5c11\u4e00\u4e2a\u6216\u591a\u4e2a\u5fc5\u4f20\u53c2\u6570: {}\u3002", (Object)JSON.toJSONString((Object)req));
            this.sysSettingHelper.throwCheckException(1001, "\u53c2\u6570\u4e2a\u6570\u4e0d\u591f");
        }
        if (StringUtils.isEmpty((CharSequence)(requestId = req.getRequest_id()))) {
            log.error("\u6d88\u606fID\u4e3a\u7a7a\u3002");
            this.sysSettingHelper.throwCheckException(1002, "request_id\u4e3a\u7a7a");
        }
        if ((n = (requestId = requestId.trim()).length()) > (maxLen = 32)) {
            log.error("\u6d88\u606fID\u8d85\u957f\u3002\u6700\u5927\u957f\u5ea6: {}, \u5b9e\u9645\u957f\u5ea6\uff1a {}\u3002", (Object)n, (Object)maxLen);
            this.sysSettingHelper.throwCheckException(1002, "request_id\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)(manufacturerId = req.getManufacturer_id()))) {
            log.error("\u5206\u62e3\u673a\u5382\u5546\u6807\u8bc6\u4e3a\u7a7a\u3002");
            this.sysSettingHelper.throwCheckException(1003, "manufacturer_id\u4e3a\u7a7a");
        }
        if (!"SHXB".equals(manufacturerId = manufacturerId.trim())) {
            log.error("\u5206\u62e3\u673a\u5382\u5546\u6807\u8bc6\u4e0d\u4e00\u81f4\u3002\u671f\u671b\u503c: {} \u6216 {}, \u5b9e\u9645\u503c: {}\u3002", (Object)"SHXB", (Object)manufacturerId);
            this.sysSettingHelper.throwCheckException(1005, "manufacturer_id\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((CharSequence)(format = req.getFormat()))) {
            log.error("\u8bf7\u6c42\u4f53\u683c\u5f0f\u4e3a\u7a7a\u3002");
            this.sysSettingHelper.throwCheckException(1005, "format\u4e3a\u7a7a");
        }
        if (!"JSON".equals(format = format.trim()) && !"XML".equals(format)) {
            log.error("\u8bf7\u6c42\u4f53\u683c\u5f0f\u4e0d\u88ab\u652f\u6301\u3002\u671f\u671b\u503c: {} \u6216 {}, \u5b9e\u9645\u503c: {}\u3002", new Object[]{"JSON", "XML", format});
            this.sysSettingHelper.throwCheckException(1005, "format\u4e0d\u88ab\u652f\u6301");
        }
        if (StringUtils.isEmpty((CharSequence)(requestBody = req.getRequest_body()))) {
            log.error("\u62a5\u6587\u4f53\u4e3a\u7a7a\u3002");
            this.sysSettingHelper.throwCheckException(1006, "request_body\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)(requestTime = req.getRequest_time()))) {
            log.error("\u8bf7\u6c42\u65f6\u95f4\u4e3a\u7a7a\u3002");
            this.sysSettingHelper.throwCheckException(1007, "requestTime\u4e3a\u7a7a");
        }
        requestTime = requestTime.trim();
        String token = req.getToken();
        if (StringUtils.isEmpty((CharSequence)token)) {
            log.error("\u5b89\u5168\u6821\u9a8c\u4fe1\u606f\u4e3a\u7a7a\u3002");
            this.sysSettingHelper.throwCheckException(1004, "token\u4e3a\u7a7a");
        }
        if ((token = token.trim()).equals(realToken = TokenUtils.getToken((String)requestId, (String)requestTime, (String)this.manufacturerConfig.getSecretKey()))) {
            log.error("\u5b89\u5168\u6821\u9a8c\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25\u3002\u53c2\u6570\u503c: {}, \u5b9e\u9645\u503c: {}\u3002", (Object)token, (Object)realToken);
            this.sysSettingHelper.throwCheckException(1004, "token\u9a8c\u8bc1\u5931\u8d25");
        }
    }
}

