/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.controller;

import com.simba.services.bean.domain.SorterConfig;
import com.simba.services.common.annotation.Log;
import com.simba.services.common.core.controller.BaseController;
import com.simba.services.common.enums.BusinessType;
import com.simba.services.common.utils.poi.ExcelUtil;
import com.simba.services.common.utils.sql.core.domain.AjaxResult;
import com.simba.services.common.utils.sql.core.page.TableDataInfo;
import com.simba.services.service.SorterConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u62e3\u673a\u5b9a\u4e49\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/sorter-config"})
public class SorterConfigController
extends BaseController {
    private SorterConfigService sorterConfigService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u62e3\u673a\u5217\u8868", notes="\u67e5\u8be2\u5206\u62e3\u673a\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SorterConfig tmSorterConfig) {
        this.startPage();
        List list = this.sorterConfigService.findTmSorterConfigList(tmSorterConfig);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5bfc\u51fa\u5206\u62e3\u673a\u5217\u8868", notes="\u5bfc\u51fa\u5206\u62e3\u673a\u5217\u8868")
    @Log(title="\u5206\u62e3\u673a", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SorterConfig tmSorterConfig) {
        List list = this.sorterConfigService.findTmSorterConfigList(tmSorterConfig);
        ExcelUtil util = new ExcelUtil(SorterConfig.class);
        util.exportExcel(response, list, "\u5206\u62e3\u673a\u6570\u636e");
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u62e3\u673a\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u5206\u62e3\u673a\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.sorterConfigService.findTmSorterConfigById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u5206\u62e3\u673a", notes="\u65b0\u589e\u5206\u62e3\u673a")
    @Log(title="\u5206\u62e3\u673a", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SorterConfig tmSorterConfig) {
        return this.toAjax(this.sorterConfigService.saveTmSorterConfig(tmSorterConfig));
    }

    @ApiOperation(value="\u4fee\u6539\u5206\u62e3\u673a", notes="\u4fee\u6539\u5206\u62e3\u673a")
    @Log(title="\u5206\u62e3\u673a", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SorterConfig tmSorterConfig) {
        return this.toAjax(this.sorterConfigService.editTmSorterConfig(tmSorterConfig));
    }

    @ApiOperation(value="\u5220\u9664\u5206\u62e3\u673a", notes="\u5220\u9664\u5206\u62e3\u673a")
    @Log(title="\u5206\u62e3\u673a", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.sorterConfigService.removeTmSorterConfigByIds(ids));
    }

    public SorterConfigController(SorterConfigService sorterConfigService) {
        this.sorterConfigService = sorterConfigService;
    }
}

