/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.controller;

import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.handler.BalanceWheelDeviceActionHandler;
import com.simba.services.server.MyServerHandler;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SendToDeviceController {
    private static final Logger log = LoggerFactory.getLogger(SendToDeviceController.class);
    @Autowired
    private MyServerHandler serverHandler;
    @Resource
    private DeviceInfoManager deviceInfoManager;
    @Autowired
    private BalanceWheelDeviceActionHandler balanceWheelDeviceControlHandler;

    @GetMapping(value={"/reset"})
    public String reset() {
        log.info("Received reset request");
        this.deviceInfoManager.reset();
        return "OK";
    }

    @PostMapping(value={"/reupload"})
    public String reupload() {
        log.info("Received allUpload request");
        this.deviceInfoManager.uploadAllStatus();
        boolean uploadFlag = this.deviceInfoManager.uploadAllStatus();
        if (!uploadFlag) {
            return "FAIL";
        }
        return "OK";
    }

    @PostMapping(value={"/reload"})
    public String reload() {
        log.info("Received reload request");
        boolean reloadFlag = this.deviceInfoManager.reload();
        if (!reloadFlag) {
            return "FAIL";
        }
        return "OK";
    }

    @GetMapping(value={"/send/{code}"})
    public String send(@PathVariable(value="code") String code) {
        this.serverHandler.send(code, "123456789");
        log.info("Received: " + code);
        return "OK";
    }

    @GetMapping(value={"/test/postform"})
    public String postForm(@RequestParam(value="para1") String para1) {
        log.info("Received para1: {}.", (Object)para1);
        return "OK";
    }
}

