/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.controller;

import com.simba.services.handler.BalanceWheelDeviceActionHandler;
import com.simba.services.server.MyServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/device-control"})
public class DeviceOperationController {
    private static final Logger log = LoggerFactory.getLogger(DeviceOperationController.class);
    @Autowired
    private MyServerHandler serverHandler;
    @Autowired
    private BalanceWheelDeviceActionHandler balanceWheelDeviceControlHandler;

    @PostMapping
    public String controlDevice(@RequestParam(value="line-num") short lineNum, @RequestParam(value="sys-status") byte sysStatus, @RequestParam(value="sys-mode") byte sysMode) {
        log.info("Received line-num: {}, sys-status: {}, sys-mode: {}.", new Object[]{lineNum, sysStatus, sysMode});
        this.checkParameters(lineNum, sysStatus, sysMode);
        this.balanceWheelDeviceControlHandler.sysStatusChange(Short.valueOf(lineNum), sysStatus, sysMode);
        return "OK";
    }

    private void checkParameters(short lineNum, byte sysStatus, byte sysMode) {
    }
}

