/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.controller;

import com.simba.services.bean.domain.DeviceConfig;
import com.simba.services.common.annotation.Log;
import com.simba.services.common.core.controller.BaseController;
import com.simba.services.common.enums.BusinessType;
import com.simba.services.common.utils.poi.ExcelUtil;
import com.simba.services.common.utils.sql.core.domain.AjaxResult;
import com.simba.services.common.utils.sql.core.page.TableDataInfo;
import com.simba.services.service.DeviceConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bbe\u5907\u5b9a\u4e49\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/device-config"})
public class DeviceConfigController
extends BaseController {
    private DeviceConfigService deviceConfigService;

    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u5217\u8868", notes="\u67e5\u8be2\u8bbe\u5907\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(DeviceConfig tmDeviceConfig) {
        this.startPage();
        List list = this.deviceConfigService.findTmDeviceConfigList(tmDeviceConfig);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5bfc\u51fa\u8bbe\u5907\u5217\u8868", notes="\u5bfc\u51fa\u8bbe\u5907\u5217\u8868")
    @Log(title="\u8bbe\u5907", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, DeviceConfig tmDeviceConfig) {
        List list = this.deviceConfigService.findTmDeviceConfigList(tmDeviceConfig);
        ExcelUtil util = new ExcelUtil(DeviceConfig.class);
        util.exportExcel(response, list, "\u8bbe\u5907\u6570\u636e");
    }

    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u8bbe\u5907\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.deviceConfigService.findTmDeviceConfigById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u8bbe\u5907", notes="\u65b0\u589e\u8bbe\u5907")
    @Log(title="\u8bbe\u5907", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody DeviceConfig tmDeviceConfig) {
        return this.toAjax(this.deviceConfigService.saveTmDeviceConfig(tmDeviceConfig));
    }

    @ApiOperation(value="\u4fee\u6539\u8bbe\u5907", notes="\u4fee\u6539\u8bbe\u5907")
    @Log(title="\u8bbe\u5907", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DeviceConfig tmDeviceConfig) {
        return this.toAjax(this.deviceConfigService.editTmDeviceConfig(tmDeviceConfig));
    }

    @ApiOperation(value="\u5220\u9664\u8bbe\u5907", notes="\u5220\u9664\u8bbe\u5907")
    @Log(title="\u8bbe\u5907", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.deviceConfigService.removeTmDeviceConfigByIds(ids));
    }

    public DeviceConfigController(DeviceConfigService deviceConfigService) {
        this.deviceConfigService = deviceConfigService;
    }
}

