/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.controller;

import com.simba.services.bean.domain.BasicConfig;
import com.simba.services.common.annotation.Log;
import com.simba.services.common.core.controller.BaseController;
import com.simba.services.common.enums.BusinessType;
import com.simba.services.common.utils.poi.ExcelUtil;
import com.simba.services.common.utils.sql.core.domain.AjaxResult;
import com.simba.services.common.utils.sql.core.page.TableDataInfo;
import com.simba.services.service.BasicConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57fa\u672c\u914d\u7f6e\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/basic-config"})
public class BasicConfigController
extends BaseController {
    private BasicConfigService basicConfigService;

    @ApiOperation(value="\u67e5\u8be2\u57fa\u672c\u914d\u7f6e\u5217\u8868", notes="\u67e5\u8be2\u57fa\u672c\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(BasicConfig tmBasicConfig) {
        this.startPage();
        List list = this.basicConfigService.findTmBasicConfigList(tmBasicConfig);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5bfc\u51fa\u57fa\u672c\u914d\u7f6e\u5217\u8868", notes="\u5bfc\u51fa\u57fa\u672c\u914d\u7f6e\u5217\u8868")
    @Log(title="\u57fa\u672c\u914d\u7f6e", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, BasicConfig tmBasicConfig) {
        List list = this.basicConfigService.findTmBasicConfigList(tmBasicConfig);
        ExcelUtil util = new ExcelUtil(BasicConfig.class);
        util.exportExcel(response, list, "\u57fa\u672c\u914d\u7f6e\u6570\u636e");
    }

    @ApiOperation(value="\u83b7\u53d6\u57fa\u672c\u914d\u7f6e\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u57fa\u672c\u914d\u7f6e\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.basicConfigService.findTmBasicConfigById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u57fa\u672c\u914d\u7f6e", notes="\u65b0\u589e\u57fa\u672c\u914d\u7f6e")
    @Log(title="\u57fa\u672c\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BasicConfig tmBasicConfig) {
        return this.toAjax(this.basicConfigService.saveTmBasicConfig(tmBasicConfig));
    }

    @ApiOperation(value="\u4fee\u6539\u57fa\u672c\u914d\u7f6e", notes="\u4fee\u6539\u57fa\u672c\u914d\u7f6e")
    @Log(title="\u57fa\u672c\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BasicConfig tmBasicConfig) {
        return this.toAjax(this.basicConfigService.editTmBasicConfig(tmBasicConfig));
    }

    @ApiOperation(value="\u5220\u9664\u57fa\u672c\u914d\u7f6e", notes="\u5220\u9664\u57fa\u672c\u914d\u7f6e")
    @Log(title="\u57fa\u672c\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.basicConfigService.removeTmBasicConfigByIds(ids));
    }

    public BasicConfigController(BasicConfigService basicConfigService) {
        this.basicConfigService = basicConfigService;
    }
}

