/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.config.datasource;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.simba.services.mapper.sorter"}, sqlSessionTemplateRef="sorterSqlSessionTemplate")
public class SorterDataSourceConfig {
    @Bean(name={"sorterSqlSessionFactory"})
    public SqlSessionFactory sorterSqlSessionFactory(@Qualifier(value="sorterDataSource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/sorterdb/**/*Mapper.xml"));
        return bean.getObject();
    }

    @Bean(name={"sorterTransactionManager"})
    public DataSourceTransactionManager sorterTransactionManager(@Qualifier(value="sorterDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"sorterSqlSessionTemplate"})
    public SqlSessionTemplate sorterSqlSessionTemplate(@Qualifier(value="sorterSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

