/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.config.datasource;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.simba.services.mapper.monitor,com.simba.services.push.database.*.mapper"}, sqlSessionTemplateRef="monitorSqlSessionTemplate")
public class MonitorDataSourceConfig {
    @Bean(name={"monitorSqlSessionFactory"})
    @Primary
    public SqlSessionFactory monitorSqlSessionFactory(@Qualifier(value="monitorDataSource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/quartz/**/*Mapper.xml"));
        return bean.getObject();
    }

    @Bean(name={"monitorTransactionManager"})
    @Primary
    public DataSourceTransactionManager monitorTransactionManager(@Qualifier(value="monitorDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"monitorSqlSessionTemplate"})
    @Primary
    public SqlSessionTemplate monitorSqlSessionTemplate(@Qualifier(value="monitorSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

