/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.bean.model;

import com.simba.services.bean.model.BalanceWheelDeviceInfo;
import com.simba.services.bean.model.SorterDeviceInfo;
import com.simba.services.config.WinccConfig;
import com.simba.services.push.manager.NewStatusManager;
import com.simba.services.upload.event.FaultMsg;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeviceInfoManager {
    private static final Logger log = LoggerFactory.getLogger(DeviceInfoManager.class);
    @Resource
    private BalanceWheelDeviceInfo balanceWheelDeviceInfo = new BalanceWheelDeviceInfo();
    private Map<String, SorterDeviceInfo> sorterDeviceInfoMap = new HashMap();
    @Resource
    private WinccConfig.WorkshopConfig config;
    private Map<String, Boolean> databaseStatusUploadedFlagMap = new ConcurrentHashMap();
    private Map<String, Object> lastStatusMap = new ConcurrentHashMap();
    private Map<String, FaultMsg> lastEventMap = new ConcurrentHashMap();
    @Resource
    private NewStatusManager newStatusManager;

    public void reset() {
        log.info("Reset status");
        log.info("Reset balance wheel status");
        this.balanceWheelDeviceInfo.getInnerState().reset();
        for (String sorterId : this.sorterDeviceInfoMap.keySet()) {
            log.info("Reset sorter status");
            ((SorterDeviceInfo)this.sorterDeviceInfoMap.get(sorterId)).getInnerState().reset();
        }
    }

    public boolean uploadAllStatus() {
        log.info("Reset new upload status");
        return this.newStatusManager.handleUploadMessage();
    }

    public boolean reload() {
        log.info("Reload status");
        return this.newStatusManager.reReload();
    }

    public BalanceWheelDeviceInfo getBalanceWheelDeviceInfo() {
        return this.balanceWheelDeviceInfo;
    }

    public Map<String, SorterDeviceInfo> getSorterDeviceInfoMap() {
        return this.sorterDeviceInfoMap;
    }

    public Map<String, Boolean> getDatabaseStatusUploadedFlagMap() {
        return this.databaseStatusUploadedFlagMap;
    }

    public Map<String, Object> getLastStatusMap() {
        return this.lastStatusMap;
    }

    public Map<String, FaultMsg> getLastEventMap() {
        return this.lastEventMap;
    }
}

