/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.bean.model;

import com.simba.services.bean.domain.DeviceConfig;
import com.simba.services.bean.model.InnerState;
import com.simba.services.helper.DeviceHelper;
import com.simba.services.message.balancewheel.EmergencyStopStatus;
import com.simba.services.message.balancewheel.GridPosStatus;
import com.simba.services.message.balancewheel.HeartBreak;
import com.simba.services.message.balancewheel.LineStatus;
import com.simba.services.message.balancewheel.OverheadDoorStatus;
import com.simba.services.message.balancewheel.PhotoEletricStatus;
import com.simba.services.message.balancewheel.RemoteIoCommStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BalanceWheelDeviceInfo {
    private static final Logger log = LoggerFactory.getLogger(BalanceWheelDeviceInfo.class);
    @Resource
    private DeviceHelper deviceHelper;
    private InnerState innerState = new InnerState(true);
    private InnerState extraInnerState = new InnerState(true);
    private Map<String, List<DeviceConfig>> gridPosConfigMap = new HashMap();
    private Map<String, List<DeviceConfig>> beltWheelConfigMap = new HashMap();
    private Map<Long, Map<Integer, DeviceConfig>> beltWheelConfigMapWithLineNum = new HashMap();
    private Map<String, HeartBreak> heartBreakMap = new HashMap();
    private Map<String, LineStatus> lineStatusMap = new HashMap();
    private Map<String, EmergencyStopStatus> emergencyStopStatusMap = new HashMap();
    private Map<String, OverheadDoorStatus> overheadDoorStatusMap = new HashMap();
    private Map<String, RemoteIoCommStatus> remoteIoCommStatusMap = new HashMap();
    private Map<String, GridPosStatus> gridPosStatusMap = new HashMap();
    private Map<String, PhotoEletricStatus> photoEletricStatusMap = new HashMap();

    @PostConstruct
    public void init() {
        this.loadSlotConfig();
        this.loadWheelBeltConfig();
    }

    private void loadSlotConfig() {
        List slotConfigList = this.deviceHelper.getSlotConfigList();
        if (CollectionUtils.isEmpty((Collection)slotConfigList)) {
            log.error("\u65e0\u6cd5\u52a0\u8f7d\u683c\u53e3\u8bbe\u5907\u5b9a\u4e49, \u521d\u59cb\u5316\u5931\u8d25\u3002");
            return;
        }
        log.info("\u683c\u53e3\u8bbe\u5907\u5b9a\u4e49\u6570\u91cf: {}\u3002", (Object)slotConfigList.size());
        for (DeviceConfig slot : slotConfigList) {
            String key = slot.getSorterId();
            ArrayList<DeviceConfig> list = (ArrayList<DeviceConfig>)this.gridPosConfigMap.get(key);
            if (list == null) {
                list = new ArrayList<DeviceConfig>();
                this.gridPosConfigMap.put(key, list);
            }
            list.add(slot);
        }
    }

    private void loadWheelBeltConfig() {
        List wheelBeltConfigList = this.deviceHelper.getWheelBeltConfigList();
        if (CollectionUtils.isEmpty((Collection)wheelBeltConfigList)) {
            log.error("\u65e0\u6cd5\u52a0\u8f7d\u6446\u8f6e-\u76ae\u5e26\u673a\u8bbe\u5907\u5b9a\u4e49, \u521d\u59cb\u5316\u5931\u8d25\u3002");
            return;
        }
        log.info("\u6446\u8f6e-\u76ae\u5e26\u673a\u8bbe\u5907\u5b9a\u4e49\u6570\u91cf: {}\u3002", (Object)wheelBeltConfigList.size());
        for (DeviceConfig wheelBelt : wheelBeltConfigList) {
            String key = wheelBelt.getSorterId();
            ArrayList<DeviceConfig> list = (ArrayList<DeviceConfig>)this.beltWheelConfigMap.get(key);
            if (list == null) {
                list = new ArrayList<DeviceConfig>();
                this.beltWheelConfigMap.put(key, list);
            }
            list.add(wheelBelt);
            Long lineNum = wheelBelt.getLineNum();
            HashMap<Integer, DeviceConfig> map = (HashMap<Integer, DeviceConfig>)this.beltWheelConfigMapWithLineNum.get(lineNum);
            if (map == null) {
                map = new HashMap<Integer, DeviceConfig>();
                this.beltWheelConfigMapWithLineNum.put(lineNum, map);
            }
            map.put(wheelBelt.getSeqNo(), wheelBelt);
        }
    }

    public DeviceHelper getDeviceHelper() {
        return this.deviceHelper;
    }

    public InnerState getInnerState() {
        return this.innerState;
    }

    public InnerState getExtraInnerState() {
        return this.extraInnerState;
    }

    public Map<String, List<DeviceConfig>> getGridPosConfigMap() {
        return this.gridPosConfigMap;
    }

    public Map<String, List<DeviceConfig>> getBeltWheelConfigMap() {
        return this.beltWheelConfigMap;
    }

    public Map<Long, Map<Integer, DeviceConfig>> getBeltWheelConfigMapWithLineNum() {
        return this.beltWheelConfigMapWithLineNum;
    }

    public Map<String, HeartBreak> getHeartBreakMap() {
        return this.heartBreakMap;
    }

    public Map<String, LineStatus> getLineStatusMap() {
        return this.lineStatusMap;
    }

    public Map<String, EmergencyStopStatus> getEmergencyStopStatusMap() {
        return this.emergencyStopStatusMap;
    }

    public Map<String, OverheadDoorStatus> getOverheadDoorStatusMap() {
        return this.overheadDoorStatusMap;
    }

    public Map<String, RemoteIoCommStatus> getRemoteIoCommStatusMap() {
        return this.remoteIoCommStatusMap;
    }

    public Map<String, GridPosStatus> getGridPosStatusMap() {
        return this.gridPosStatusMap;
    }

    public Map<String, PhotoEletricStatus> getPhotoEletricStatusMap() {
        return this.photoEletricStatusMap;
    }

    public void setDeviceHelper(DeviceHelper deviceHelper) {
        this.deviceHelper = deviceHelper;
    }

    public void setInnerState(InnerState innerState) {
        this.innerState = innerState;
    }

    public void setExtraInnerState(InnerState extraInnerState) {
        this.extraInnerState = extraInnerState;
    }

    public void setGridPosConfigMap(Map<String, List<DeviceConfig>> gridPosConfigMap) {
        this.gridPosConfigMap = gridPosConfigMap;
    }

    public void setBeltWheelConfigMap(Map<String, List<DeviceConfig>> beltWheelConfigMap) {
        this.beltWheelConfigMap = beltWheelConfigMap;
    }

    public void setBeltWheelConfigMapWithLineNum(Map<Long, Map<Integer, DeviceConfig>> beltWheelConfigMapWithLineNum) {
        this.beltWheelConfigMapWithLineNum = beltWheelConfigMapWithLineNum;
    }

    public void setHeartBreakMap(Map<String, HeartBreak> heartBreakMap) {
        this.heartBreakMap = heartBreakMap;
    }

    public void setLineStatusMap(Map<String, LineStatus> lineStatusMap) {
        this.lineStatusMap = lineStatusMap;
    }

    public void setEmergencyStopStatusMap(Map<String, EmergencyStopStatus> emergencyStopStatusMap) {
        this.emergencyStopStatusMap = emergencyStopStatusMap;
    }

    public void setOverheadDoorStatusMap(Map<String, OverheadDoorStatus> overheadDoorStatusMap) {
        this.overheadDoorStatusMap = overheadDoorStatusMap;
    }

    public void setRemoteIoCommStatusMap(Map<String, RemoteIoCommStatus> remoteIoCommStatusMap) {
        this.remoteIoCommStatusMap = remoteIoCommStatusMap;
    }

    public void setGridPosStatusMap(Map<String, GridPosStatus> gridPosStatusMap) {
        this.gridPosStatusMap = gridPosStatusMap;
    }

    public void setPhotoEletricStatusMap(Map<String, PhotoEletricStatus> photoEletricStatusMap) {
        this.photoEletricStatusMap = photoEletricStatusMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BalanceWheelDeviceInfo)) {
            return false;
        }
        BalanceWheelDeviceInfo other = (BalanceWheelDeviceInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DeviceHelper this$deviceHelper = this.getDeviceHelper();
        DeviceHelper other$deviceHelper = other.getDeviceHelper();
        if (this$deviceHelper == null ? other$deviceHelper != null : !this$deviceHelper.equals(other$deviceHelper)) {
            return false;
        }
        InnerState this$innerState = this.getInnerState();
        InnerState other$innerState = other.getInnerState();
        if (this$innerState == null ? other$innerState != null : !this$innerState.equals(other$innerState)) {
            return false;
        }
        InnerState this$extraInnerState = this.getExtraInnerState();
        InnerState other$extraInnerState = other.getExtraInnerState();
        if (this$extraInnerState == null ? other$extraInnerState != null : !this$extraInnerState.equals(other$extraInnerState)) {
            return false;
        }
        Map this$gridPosConfigMap = this.getGridPosConfigMap();
        Map other$gridPosConfigMap = other.getGridPosConfigMap();
        if (this$gridPosConfigMap == null ? other$gridPosConfigMap != null : !((Object)this$gridPosConfigMap).equals(other$gridPosConfigMap)) {
            return false;
        }
        Map this$beltWheelConfigMap = this.getBeltWheelConfigMap();
        Map other$beltWheelConfigMap = other.getBeltWheelConfigMap();
        if (this$beltWheelConfigMap == null ? other$beltWheelConfigMap != null : !((Object)this$beltWheelConfigMap).equals(other$beltWheelConfigMap)) {
            return false;
        }
        Map this$beltWheelConfigMapWithLineNum = this.getBeltWheelConfigMapWithLineNum();
        Map other$beltWheelConfigMapWithLineNum = other.getBeltWheelConfigMapWithLineNum();
        if (this$beltWheelConfigMapWithLineNum == null ? other$beltWheelConfigMapWithLineNum != null : !((Object)this$beltWheelConfigMapWithLineNum).equals(other$beltWheelConfigMapWithLineNum)) {
            return false;
        }
        Map this$heartBreakMap = this.getHeartBreakMap();
        Map other$heartBreakMap = other.getHeartBreakMap();
        if (this$heartBreakMap == null ? other$heartBreakMap != null : !((Object)this$heartBreakMap).equals(other$heartBreakMap)) {
            return false;
        }
        Map this$lineStatusMap = this.getLineStatusMap();
        Map other$lineStatusMap = other.getLineStatusMap();
        if (this$lineStatusMap == null ? other$lineStatusMap != null : !((Object)this$lineStatusMap).equals(other$lineStatusMap)) {
            return false;
        }
        Map this$emergencyStopStatusMap = this.getEmergencyStopStatusMap();
        Map other$emergencyStopStatusMap = other.getEmergencyStopStatusMap();
        if (this$emergencyStopStatusMap == null ? other$emergencyStopStatusMap != null : !((Object)this$emergencyStopStatusMap).equals(other$emergencyStopStatusMap)) {
            return false;
        }
        Map this$overheadDoorStatusMap = this.getOverheadDoorStatusMap();
        Map other$overheadDoorStatusMap = other.getOverheadDoorStatusMap();
        if (this$overheadDoorStatusMap == null ? other$overheadDoorStatusMap != null : !((Object)this$overheadDoorStatusMap).equals(other$overheadDoorStatusMap)) {
            return false;
        }
        Map this$remoteIoCommStatusMap = this.getRemoteIoCommStatusMap();
        Map other$remoteIoCommStatusMap = other.getRemoteIoCommStatusMap();
        if (this$remoteIoCommStatusMap == null ? other$remoteIoCommStatusMap != null : !((Object)this$remoteIoCommStatusMap).equals(other$remoteIoCommStatusMap)) {
            return false;
        }
        Map this$gridPosStatusMap = this.getGridPosStatusMap();
        Map other$gridPosStatusMap = other.getGridPosStatusMap();
        if (this$gridPosStatusMap == null ? other$gridPosStatusMap != null : !((Object)this$gridPosStatusMap).equals(other$gridPosStatusMap)) {
            return false;
        }
        Map this$photoEletricStatusMap = this.getPhotoEletricStatusMap();
        Map other$photoEletricStatusMap = other.getPhotoEletricStatusMap();
        return !(this$photoEletricStatusMap == null ? other$photoEletricStatusMap != null : !((Object)this$photoEletricStatusMap).equals(other$photoEletricStatusMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BalanceWheelDeviceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeviceHelper $deviceHelper = this.getDeviceHelper();
        result = result * 59 + ($deviceHelper == null ? 43 : $deviceHelper.hashCode());
        InnerState $innerState = this.getInnerState();
        result = result * 59 + ($innerState == null ? 43 : $innerState.hashCode());
        InnerState $extraInnerState = this.getExtraInnerState();
        result = result * 59 + ($extraInnerState == null ? 43 : $extraInnerState.hashCode());
        Map $gridPosConfigMap = this.getGridPosConfigMap();
        result = result * 59 + ($gridPosConfigMap == null ? 43 : ((Object)$gridPosConfigMap).hashCode());
        Map $beltWheelConfigMap = this.getBeltWheelConfigMap();
        result = result * 59 + ($beltWheelConfigMap == null ? 43 : ((Object)$beltWheelConfigMap).hashCode());
        Map $beltWheelConfigMapWithLineNum = this.getBeltWheelConfigMapWithLineNum();
        result = result * 59 + ($beltWheelConfigMapWithLineNum == null ? 43 : ((Object)$beltWheelConfigMapWithLineNum).hashCode());
        Map $heartBreakMap = this.getHeartBreakMap();
        result = result * 59 + ($heartBreakMap == null ? 43 : ((Object)$heartBreakMap).hashCode());
        Map $lineStatusMap = this.getLineStatusMap();
        result = result * 59 + ($lineStatusMap == null ? 43 : ((Object)$lineStatusMap).hashCode());
        Map $emergencyStopStatusMap = this.getEmergencyStopStatusMap();
        result = result * 59 + ($emergencyStopStatusMap == null ? 43 : ((Object)$emergencyStopStatusMap).hashCode());
        Map $overheadDoorStatusMap = this.getOverheadDoorStatusMap();
        result = result * 59 + ($overheadDoorStatusMap == null ? 43 : ((Object)$overheadDoorStatusMap).hashCode());
        Map $remoteIoCommStatusMap = this.getRemoteIoCommStatusMap();
        result = result * 59 + ($remoteIoCommStatusMap == null ? 43 : ((Object)$remoteIoCommStatusMap).hashCode());
        Map $gridPosStatusMap = this.getGridPosStatusMap();
        result = result * 59 + ($gridPosStatusMap == null ? 43 : ((Object)$gridPosStatusMap).hashCode());
        Map $photoEletricStatusMap = this.getPhotoEletricStatusMap();
        result = result * 59 + ($photoEletricStatusMap == null ? 43 : ((Object)$photoEletricStatusMap).hashCode());
        return result;
    }

    public String toString() {
        return "BalanceWheelDeviceInfo(deviceHelper=" + this.getDeviceHelper() + ", innerState=" + this.getInnerState() + ", extraInnerState=" + this.getExtraInnerState() + ", gridPosConfigMap=" + this.getGridPosConfigMap() + ", beltWheelConfigMap=" + this.getBeltWheelConfigMap() + ", beltWheelConfigMapWithLineNum=" + this.getBeltWheelConfigMapWithLineNum() + ", heartBreakMap=" + this.getHeartBreakMap() + ", lineStatusMap=" + this.getLineStatusMap() + ", emergencyStopStatusMap=" + this.getEmergencyStopStatusMap() + ", overheadDoorStatusMap=" + this.getOverheadDoorStatusMap() + ", remoteIoCommStatusMap=" + this.getRemoteIoCommStatusMap() + ", gridPosStatusMap=" + this.getGridPosStatusMap() + ", photoEletricStatusMap=" + this.getPhotoEletricStatusMap() + ")";
    }
}

