/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.internal;

import com.jrockit.mc.rjmx.internal.KnownObjectNames;
import com.jrockit.mc.rjmx.subscription.IMBeanServerChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

class StandardNotificationListener {
    private final IMBeanServerChangeListener mbeanServerChangeListener;
    private final MBeanServerConnection mbeanServerConnection;
    private final NotificationListener notificationListener;

    public StandardNotificationListener(MBeanServerConnection mbeanServerConnection, IMBeanServerChangeListener mbeanServerChangeListener) throws InstanceNotFoundException, IOException {
        this.mbeanServerChangeListener = mbeanServerChangeListener;
        this.mbeanServerConnection = mbeanServerConnection;
        this.notificationListener = this.createNotificationListener();
        mbeanServerConnection.addNotificationListener(KnownObjectNames.MBEAN_NOTIFICATION_OBJECT_NAME, this.notificationListener, null, null);
    }

    private NotificationListener createNotificationListener() {
        return new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                StandardNotificationListener.this.internalHandleNotification(notification, handback);
            }
        };
    }

    private void internalHandleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification serverNotification = (MBeanServerNotification)notification;
            ObjectName mbean = serverNotification.getMBeanName();
            if (serverNotification.getType().equals("JMX.mbean.registered")) {
                this.mbeanServerChangeListener.mbeanRegistered(mbean);
            } else {
                this.mbeanServerChangeListener.mbeanUnregistered(mbean);
            }
        }
    }

    public void unregister(Logger logger) {
        try {
            this.mbeanServerConnection.removeNotificationListener(KnownObjectNames.MBEAN_NOTIFICATION_OBJECT_NAME, this.notificationListener);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem unregistering notification listener.", e);
        }
    }
}

