/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class ClassLoadedCommand
extends Command {
    private String className;
    private byte[] classFileBytes;
    private int[] thisAndParentLoaderData;
    private boolean threadInCallGraph;

    public ClassLoadedCommand(String string, int[] nArray, byte[] byArray, boolean bl) {
        super(3);
        this.className = string;
        this.thisAndParentLoaderData = nArray;
        this.classFileBytes = byArray;
        this.threadInCallGraph = bl;
    }

    ClassLoadedCommand() {
        super(3);
    }

    public byte[] getClassFileBytes() {
        return this.classFileBytes;
    }

    public String getClassName() {
        return this.className;
    }

    public int[] getThisAndParentLoaderData() {
        return this.thisAndParentLoaderData;
    }

    public boolean getThreadInCallGraph() {
        return this.threadInCallGraph;
    }

    public String toString() {
        return super.toString() + ", className: " + this.className + ", threadInCallGraph: " + this.threadInCallGraph + ", thisAndParentLoaderData: " + this.thisAndParentLoaderData[0] + ", " + this.thisAndParentLoaderData[1] + ", " + this.thisAndParentLoaderData[2] + ", classFileBytes: " + (this.classFileBytes == null ? "null" : "" + this.classFileBytes.length);
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        this.className = objectInputStream.readUTF();
        this.thisAndParentLoaderData = new int[3];
        for (n = 0; n < 3; ++n) {
            this.thisAndParentLoaderData[n] = objectInputStream.readInt();
        }
        n = objectInputStream.readInt();
        if (n == 0) {
            this.classFileBytes = null;
        } else {
            this.classFileBytes = new byte[n];
            objectInputStream.readFully(this.classFileBytes);
        }
        this.threadInCallGraph = objectInputStream.readBoolean();
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.className);
        for (int i = 0; i < 3; ++i) {
            objectOutputStream.writeInt(this.thisAndParentLoaderData[i]);
        }
        if (this.classFileBytes != null) {
            objectOutputStream.writeInt(this.classFileBytes.length);
            objectOutputStream.write(this.classFileBytes);
            this.classFileBytes = null;
        } else {
            objectOutputStream.writeInt(0);
        }
        objectOutputStream.writeBoolean(this.threadInCallGraph);
    }
}

