/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.jnlp;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.TemplatePlaceholders;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.cert.CertificateEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JNLPBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(JNLPBundler.class.getName());
    private static final String dtFX = "dtjava.js";
    private static final String webfilesDir = "web-files";
    private static final String EMBEDDED_DT = "./web-files/dtjava.js";
    private static final String PUBLIC_DT = "http://java.com/js/dtjava.js";
    public static final StandardBundlerParam<String> OUT_FILE = new StandardBundlerParam<String>(I18N.getString("param.out-file.name"), I18N.getString("param.out-file.description"), "jnlp.outfile", String.class, null, null);
    public static final StandardBundlerParam<Boolean> SWING_APP = new StandardBundlerParam<Boolean>(I18N.getString("param.swing-app.name"), I18N.getString("param.swing-app.description"), "jnlp.swingApp", Boolean.class, map -> Boolean.FALSE, (string, map) -> Boolean.parseBoolean(string));
    public static final StandardBundlerParam<Boolean> INCLUDE_DT = new StandardBundlerParam<Boolean>(I18N.getString("param.include-deployment-toolkit.name"), I18N.getString("param.include-deployment-toolkit.description"), "jnlp.includeDT", Boolean.class, map -> Boolean.FALSE, (string, map) -> Boolean.parseBoolean(string));
    public static final StandardBundlerParam<Boolean> EMBED_JNLP = new StandardBundlerParam<Boolean>(I18N.getString("param.embed-jnlp.name"), I18N.getString("param.embed-jnlp.description"), "jnlp.embedJnlp", Boolean.class, map -> Boolean.FALSE, (string, map) -> Boolean.parseBoolean(string));
    public static final StandardBundlerParam<Boolean> EXTENSION = new StandardBundlerParam<Boolean>(I18N.getString("param.extension.name"), I18N.getString("param.extension.description"), "jnlp.extension", Boolean.class, map -> Boolean.FALSE, (string, map) -> Boolean.parseBoolean(string));
    public static final StandardBundlerParam<Map<File, File>> TEMPLATES = new StandardBundlerParam<Map>(I18N.getString("param.templates.name"), I18N.getString("param.templates.description"), "jnlp.templates", Map.class, map -> new LinkedHashMap(), null);
    public static final StandardBundlerParam<String> CODEBASE = new StandardBundlerParam<String>(I18N.getString("param.codebase.name"), I18N.getString("param.codebase.description"), "jnlp.codebase", String.class, map -> null, null);
    public static final StandardBundlerParam<String> PLACEHOLDER = new StandardBundlerParam<String>(I18N.getString("param.placeholder.name"), I18N.getString("param.placeholder.description"), "jnlp.placeholder", String.class, map -> "'javafx-app-placeholder'", (string, map) -> {
        if (!string.startsWith("'")) {
            string = "'" + string;
        }
        if (!string.endsWith("'")) {
            string = string + "'";
        }
        return string;
    });
    public static final StandardBundlerParam<Boolean> OFFLINE_ALLOWED = new StandardBundlerParam<Boolean>(I18N.getString("param.offline-allowed.name"), I18N.getString("param.offline-allowed.description"), "jnlp.offlineAllowed", Boolean.class, map -> true, (string, map) -> Boolean.valueOf(string));
    public static final StandardBundlerParam<Boolean> ALL_PERMISSIONS = new StandardBundlerParam<Boolean>(I18N.getString("param.all-permissions.name"), I18N.getString("param.all-permissions.description"), "jnlp.allPermisions", Boolean.class, map -> false, (string, map) -> Boolean.valueOf(string));
    public static final StandardBundlerParam<Integer> WIDTH = new StandardBundlerParam<Integer>(I18N.getString("param.width.name"), I18N.getString("param.width.description"), "jnlp.width", Integer.class, map -> 0, (string, map) -> Integer.parseInt(string));
    public static final StandardBundlerParam<Integer> HEIGHT = new StandardBundlerParam<Integer>(I18N.getString("param.height.name"), I18N.getString("param.height.description"), "jnlp.height", Integer.class, map -> 0, (string, map) -> Integer.parseInt(string));
    public static final StandardBundlerParam<String> EMBEDDED_WIDTH = new StandardBundlerParam<String>(I18N.getString("param.embedded-width.name"), I18N.getString("param.embedded-width.description"), "jnlp.embeddedWidth", String.class, map -> Integer.toString((Integer)WIDTH.fetchFrom((Map<String, Object>)map)), (string, map) -> string);
    public static final StandardBundlerParam<String> EMBEDDED_HEIGHT = new StandardBundlerParam<String>(I18N.getString("param.embedded-height.name"), I18N.getString("param.embedded-height.description"), "jnlp.embeddedHeight", String.class, map -> Integer.toString((Integer)HEIGHT.fetchFrom((Map<String, Object>)map)), (string, map) -> string);
    public static final StandardBundlerParam<String> FALLBACK_APP = new StandardBundlerParam<String>(I18N.getString("param.fallback-app.name"), I18N.getString("param.fallback-app.description"), "jnlp.fallbackApp", String.class, map -> null, (string, map) -> string);
    public static final StandardBundlerParam<String> UPDATE_MODE = new StandardBundlerParam<String>(I18N.getString("param.update-mode.name"), I18N.getString("param.update-mode.description"), "jnlp.updateMode", String.class, map -> null, (string, map) -> string);
    public static final StandardBundlerParam<String> FX_PLATFORM = new StandardBundlerParam<String>(I18N.getString("param.fx-platform.name"), I18N.getString("param.fx-platform.description"), "jnlp.fxPlatform", String.class, map -> "8.0", (string, map) -> string);
    public static final StandardBundlerParam<String> JRE_PLATFORM = new StandardBundlerParam<String>(I18N.getString("param.jre-platform.name"), I18N.getString("param.jre-platform.description"), "jnlp.jrePlatform", String.class, map -> "8.0", (string, map) -> string);
    public static final StandardBundlerParam<List<Map<String, ? super Object>>> ICONS = new StandardBundlerParam<List>(I18N.getString("param.icons.name"), I18N.getString("param.icons.description"), "jnlp.icons", List.class, map -> new ArrayList(1), null);
    public static final StandardBundlerParam<Map<String, String>> APP_PARAMS = new StandardBundlerParam<Map>(I18N.getString("param.params.name"), I18N.getString("param.params.description"), "jnlp.params", Map.class, map -> new HashMap(), null);
    public static final StandardBundlerParam<Map<String, String>> ESCAPED_APPLET_PARAMS = new StandardBundlerParam<Map>(I18N.getString("param.escaped-applet-params.name"), I18N.getString("param.escaped-applet-params.description"), "jnlp.escapedAppletParams", Map.class, map -> new HashMap(), null);
    public static final StandardBundlerParam<Map<String, String>> APPLET_PARAMS = new StandardBundlerParam<Map>(I18N.getString("param.applet-params.name"), I18N.getString("param.applet-params.description"), "jnlp.appletParams", Map.class, map -> new HashMap(), null);
    public static final StandardBundlerParam<Map<String, String>> JS_CALLBACKS = new StandardBundlerParam<Map>(I18N.getString("param.js-callbacks.name"), I18N.getString("param.js-callbacks.description"), "jnlp.jsCallbacks", Map.class, map -> new HashMap(), null);
    public static final StandardBundlerParam<String> ICONS_HREF = new StandardBundlerParam<String>(I18N.getString("param.icons-href.name"), I18N.getString("param.icons-href.description"), "jnlp.icons.href", String.class, null, null);
    public static final StandardBundlerParam<String> ICONS_KIND = new StandardBundlerParam<String>(I18N.getString("param.icons-kind.name"), I18N.getString("param.icons-kind.description"), "jnlp.icons.kind", String.class, map -> null, null);
    public static final StandardBundlerParam<String> ICONS_WIDTH = new StandardBundlerParam<String>(I18N.getString("param.icons-width.name"), I18N.getString("param.icons-width.description"), "jnlp.icons.width", String.class, map -> null, null);
    public static final StandardBundlerParam<String> ICONS_HEIGHT = new StandardBundlerParam<String>(I18N.getString("param.icons-height.name"), I18N.getString("param.icons-height.description"), "jnlp.icons.height", String.class, map -> null, null);
    public static final StandardBundlerParam<String> ICONS_DEPTH = new StandardBundlerParam<String>(I18N.getString("param.icons-depth.name"), I18N.getString("param.icons-depth.description"), "jnlp.icons.depth", String.class, map -> null, null);
    private static String[] webFiles = new String[]{"javafx-loading-100x100.gif", "dtjava.js", "javafx-loading-25x25.gif", "error.png", "upgrade_java.png", "javafx-chrome.png", "get_java.png", "upgrade_javafx.png", "get_javafx.png"};
    private static String prefixWebFiles = "/resources/web-files/";

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "jnlp";
    }

    @Override
    public String getBundleType() {
        return "JNLP";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return null;
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        if (OUT_FILE.fetchFrom(map) == null) {
            throw new ConfigException(I18N.getString("error.no-outfile"), I18N.getString("error.no-outfile.advice"));
        }
        if (StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(map) == null) {
            throw new ConfigException(I18N.getString("error.no-app-resources"), I18N.getString("error.no-app-resources.advice"));
        }
        if (!((Boolean)EXTENSION.fetchFrom(map)).booleanValue()) {
            StandardBundlerParam.validateMainClassInfoFromAppResources(map);
        }
        return true;
    }

    private String readTextFile(File file) throws PackagerException {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));){
            int n;
            char[] cArray = new char[16384];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, stringBuilder.length(), n);
            }
        }
        catch (IOException iOException) {
            throw new PackagerException(iOException, "ERR_FileReadFailed", file.getAbsolutePath());
        }
        return stringBuilder.toString();
    }

    private String processTemplate(Map<String, ? super Object> map, String string, Map<TemplatePlaceholders, String> map2) {
        String string2 = "(#[\\w\\.\\(\\)]+#)";
        String string3 = "[\\/\\*-<\\!]*[ \\t]*";
        String string4 = "[ \\t]*[\\*\\/>-]*";
        Pattern pattern = Pattern.compile(string3 + string2 + string4);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string5;
            String string6 = matcher.group();
            String string7 = matcher.group(1);
            boolean bl = string6.startsWith("<!--") && string6.endsWith("-->") || string6.startsWith("//") || string6.startsWith("/*") && string6.endsWith(" */");
            String string8 = null;
            String[] stringArray = string7.substring(1, string7.length() - 1).split("[\\(\\)]");
            String string9 = stringArray[0];
            String string10 = string5 = stringArray.length == 1 ? null : stringArray[1];
            if (map2.containsKey((Object)TemplatePlaceholders.fromString(string9)) && (string5 == null || string5.equals(StandardBundlerParam.IDENTIFIER.fetchFrom(map)))) {
                string8 = map2.get((Object)TemplatePlaceholders.fromString(string9));
            }
            if (string8 == null) continue;
            if (bl || string7.length() == string6.length()) {
                matcher.appendReplacement(stringBuffer, string8);
                continue;
            }
            int n = string6.indexOf(string7);
            String string11 = string6.substring(0, n) + string8 + string6.substring(n + string7.length());
            matcher.appendReplacement(stringBuffer, string11);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        Map map2 = (Map)TEMPLATES.fetchFrom(map);
        boolean bl = !map2.isEmpty();
        EnumMap<TemplatePlaceholders, String> enumMap = null;
        if (bl) {
            enumMap = new EnumMap<TemplatePlaceholders, String>(TemplatePlaceholders.class);
        }
        try {
            PrintStream printStream;
            String string = (String)OUT_FILE.fetchFrom(map);
            boolean bl2 = (Boolean)SWING_APP.fetchFrom(map);
            String string2 = string + ".jnlp";
            String string3 = bl2 ? string + "_browser.jnlp" : string2;
            String string4 = string + ".html";
            file.mkdirs();
            boolean bl3 = (Boolean)INCLUDE_DT.fetchFrom(map);
            if (bl3 && !this.extractWebFiles(file)) {
                throw new PackagerException("ERR_NoEmbeddedDT");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            if (bl2) {
                printStream = new PrintStream(byteArrayOutputStream);
                this.generateJNLP(map, printStream, string2, Mode.SwingAPP);
                printStream.close();
                this.save(file, string2, byteArrayOutputStream.toByteArray());
                printStream = new PrintStream(byteArrayOutputStream2);
                this.generateJNLP(map, printStream, string3, Mode.APPLET);
                printStream.close();
                this.save(file, string3, byteArrayOutputStream2.toByteArray());
            } else {
                printStream = new PrintStream(byteArrayOutputStream2);
                this.generateJNLP(map, printStream, string3, Mode.FX);
                printStream.close();
                this.save(file, string3, byteArrayOutputStream2.toByteArray());
                byteArrayOutputStream = byteArrayOutputStream2;
            }
            boolean bl4 = (Boolean)EXTENSION.fetchFrom(map);
            if (!bl4) {
                ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
                Object object = new PrintStream(byteArrayOutputStream3);
                this.generateHTML(map, (PrintStream)object, byteArrayOutputStream2.toByteArray(), string3, byteArrayOutputStream.toByteArray(), string2, enumMap, bl2);
                ((PrintStream)object).close();
                if (bl) {
                    for (Map.Entry entry : ((Map)TEMPLATES.fetchFrom(map)).entrySet()) {
                        File file2 = (File)entry.getValue();
                        if (file2 == null) {
                            System.out.println("Perform inplace substitution for " + ((File)entry.getKey()).getAbsolutePath());
                            file2 = (File)entry.getKey();
                        }
                        this.save(file2, this.processTemplate(map, this.readTextFile((File)entry.getKey()), enumMap).getBytes());
                    }
                } else {
                    this.save(file, string4, byteArrayOutputStream3.toByteArray());
                }
            }
            for (Object object : (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(map)) {
                JNLPBundler.copyFiles((RelativeFileSet)object, file);
            }
            return file;
        }
        catch (Exception exception) {
            Log.info("JNLP failed : " + exception.getMessage());
            exception.printStackTrace();
            Log.debug(exception);
            return null;
        }
    }

    private static void copyFiles(RelativeFileSet relativeFileSet, File file) throws IOException, PackagerException {
        File file2 = relativeFileSet.getBaseDirectory();
        for (String string : relativeFileSet.getIncludedFiles()) {
            File file3 = new File(file2, string);
            if (!file3.exists() || !file3.isFile()) continue;
            File file4 = new File(file, string);
            if (!file3.getCanonicalFile().equals(file4.getCanonicalFile())) {
                JNLPBundler.copyFileToOutDir(new FileInputStream(file3), file4);
                continue;
            }
            Log.verbose(MessageFormat.format(I18N.getString("error.jar-no-self-copy"), string));
        }
    }

    private String getJvmArguments(Map<String, ? super Object> map, boolean bl) {
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        Map map2 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        StringBuilder stringBuilder = new StringBuilder();
        for (String object : list) {
            stringBuilder.append(object);
            stringBuilder.append(" ");
        }
        if (bl) {
            for (Map.Entry entry : map2.entrySet()) {
                stringBuilder.append("-D");
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append((String)entry.getValue());
                stringBuilder.append(" ");
            }
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void generateJNLP(Map<String, ? super Object> map, PrintStream printStream, String string, Mode mode) throws IOException, CertificateEncodingException {
        boolean bl;
        Object object;
        Object object2;
        boolean bl2;
        Object object4;
        String string2;
        String string3 = (String)CODEBASE.fetchFrom(map);
        String string4 = (String)StandardBundlerParam.TITLE.fetchFrom(map);
        String string5 = (String)StandardBundlerParam.VENDOR.fetchFrom(map);
        String string6 = (String)StandardBundlerParam.DESCRIPTION.fetchFrom(map);
        printStream.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printStream.println("<jnlp spec=\"1.0\" xmlns:jfx=\"http://javafx.com\"" + (string3 != null ? " codebase=\"" + string3 + "\"" : "") + " href=\"" + string + "\">");
        printStream.println("  <information>");
        printStream.println("    <title>" + (string4 != null ? string4 : "Sample JavaFX Application") + "</title>");
        printStream.println("    <vendor>" + (string5 != null ? string5 : "Unknown vendor") + "</vendor>");
        printStream.println("    <description>" + (string6 != null ? string6 : "Sample JavaFX 2.0 application.") + "</description>");
        for (Map map2 : (List)ICONS.fetchFrom(map)) {
            String string7 = (String)ICONS_HREF.fetchFrom(map2);
            String string8 = (String)ICONS_KIND.fetchFrom(map2);
            string2 = (String)ICONS_WIDTH.fetchFrom(map2);
            object4 = (String)ICONS_HEIGHT.fetchFrom(map2);
            String object32 = (String)ICONS_DEPTH.fetchFrom(map2);
            printStream.println("    <icon href=\"" + string7 + "\" " + (string8 != null ? " kind=\"" + string8 + "\"" : "") + (string2 != null ? " width=\"" + string2 + "\"" : "") + (object4 != null ? " height=\"" + (String)object4 + "\"" : "") + (object32 != null ? " depth=\"" + object32 + "\"" : "") + "/>");
        }
        boolean bl3 = (Boolean)OFFLINE_ALLOWED.fetchFrom(map);
        boolean bl4 = (Boolean)EXTENSION.fetchFrom(map);
        if (bl3 && !bl4) {
            printStream.println("    <offline-allowed/>");
        }
        if (Boolean.TRUE.equals(bl2 = ((Boolean)StandardBundlerParam.SHORTCUT_HINT.fetchFrom(map)).booleanValue())) {
            printStream.println("  <shortcut><desktop/></shortcut>");
        }
        printStream.println("  </information>");
        boolean bl5 = false;
        if (!bl4) {
            printStream.println("  <resources>");
            bl5 = true;
            string2 = this.getJvmArguments(map, false);
            string2 = string2 == null ? "" : " java-vm-args=\"" + string2 + "\" ";
            printStream.println("    <j2se version=\"" + (String)JRE_PLATFORM.fetchFrom(map) + "\"" + string2 + " href=\"http://java.sun.com/products/autodl/j2se\"/>");
            for (Map.Entry entry : ((Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map)).entrySet()) {
                printStream.println("    <property name=\"" + (String)entry.getKey() + "\" value=\"" + (String)entry.getValue() + "\"/>");
            }
        }
        string2 = null;
        object4 = null;
        Object var15_22 = null;
        for (Object object3 : (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(map)) {
            if (!bl5 || string2 == null && ((RelativeFileSet)object3).getOs() != null || string2 != null && !string2.equals(((RelativeFileSet)object3).getOs()) || object4 == null && ((RelativeFileSet)object3).getArch() != null || object4 != null && !((String)object4).equals(((RelativeFileSet)object3).getArch())) {
                void var15_26;
                if (bl5) {
                    String string7 = "  </resources>\n";
                } else {
                    String string8 = "";
                }
                string2 = ((RelativeFileSet)object3).getOs();
                object4 = ((RelativeFileSet)object3).getArch();
                String string9 = (String)var15_26 + "  <resources" + (string2 != null ? " os=\"" + string2 + "\"" : "") + (object4 != null ? " arch=\"" + (String)object4 + "\"" : "") + ">\n";
            }
            for (String string10 : ((RelativeFileSet)object3).getIncludedFiles()) {
                object2 = new File(((RelativeFileSet)object3).getBaseDirectory(), string10);
                if (!((File)object2).exists() || !((File)object2).isFile()) continue;
                object = ((RelativeFileSet)object3).getType();
                if (object == RelativeFileSet.Type.UNKNOWN) {
                    if (string10.endsWith(".jar")) {
                        object = RelativeFileSet.Type.jar;
                    } else if (string10.endsWith(".jnlp")) {
                        object = RelativeFileSet.Type.jnlp;
                    } else if (string10.endsWith(".dll")) {
                        object = RelativeFileSet.Type.nativelib;
                    } else if (string10.endsWith(".so")) {
                        object = RelativeFileSet.Type.nativelib;
                    } else if (string10.endsWith(".dylib")) {
                        object = RelativeFileSet.Type.nativelib;
                    }
                }
                switch (object) {
                    case jar: {
                        void var15_23;
                        if (var15_23 != null) {
                            printStream.print((String)var15_23);
                            Object var15_28 = null;
                            bl5 = true;
                        }
                        printStream.print("    <jar href=\"" + string10 + "\" size=\"" + ((File)object2).length() + "\"");
                        printStream.print(" download=\"" + ((RelativeFileSet)object3).getMode() + "\" ");
                        printStream.println("/>");
                        break;
                    }
                    case jnlp: {
                        void var15_23;
                        if (var15_23 != null) {
                            printStream.print((String)var15_23);
                            Object var15_29 = null;
                            bl5 = true;
                        }
                        printStream.println("    <extension href=\"" + string10 + "\"/>");
                        break;
                    }
                    case nativelib: {
                        void var15_23;
                        if (var15_23 != null) {
                            printStream.print((String)var15_23);
                            bl5 = true;
                            Object var15_30 = null;
                        }
                        printStream.println("    <nativelib href=\"" + string10 + "\"/>");
                    }
                }
            }
        }
        if (bl5) {
            printStream.println("  </resources>");
        }
        if (bl = ((Boolean)ALL_PERMISSIONS.fetchFrom(map)).booleanValue()) {
            printStream.println("<security>");
            printStream.println("  <all-permissions/>");
            printStream.println("</security>");
        }
        if (!bl4) {
            String string10;
            Object object3;
            object3 = (Integer)WIDTH.fetchFrom(map);
            Object object5 = (Integer)HEIGHT.fetchFrom(map);
            if (object3 == null) {
                object3 = 0;
            }
            if (object5 == null) {
                object5 = 0;
            }
            string10 = (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map);
            object2 = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(map);
            object = (Map)APP_PARAMS.fetchFrom(map);
            List list = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(map);
            String string11 = (String)StandardBundlerParam.APP_NAME.fetchFrom(map);
            if (mode == Mode.APPLET) {
                printStream.print("  <applet-desc  width=\"" + object3 + "\" height=\"" + object5 + "\"");
                printStream.print(" main-class=\"" + string10 + "\" ");
                printStream.println(" name=\"" + string11 + "\" >");
                for (Map.Entry entry : object.entrySet()) {
                    printStream.println("    <param name=\"" + (String)entry.getKey() + "\"" + (entry.getValue() != null ? " value=\"" + (String)entry.getValue() + "\"" : "") + "/>");
                }
                printStream.println("  </applet-desc>");
            } else if (mode == Mode.SwingAPP) {
                printStream.print("  <application-desc main-class=\"" + string10 + "\" ");
                printStream.println(" name=\"" + string11 + "\" >");
                for (String string12 : list) {
                    printStream.println("    <argument>" + string12 + "</argument>");
                }
                printStream.println("  </application-desc>");
            } else {
                String string13 = (String)FALLBACK_APP.fetchFrom(map);
                if (string13 != null) {
                    printStream.print("  <applet-desc  width=\"" + object3 + "\" height=\"" + object5 + "\"");
                    printStream.print(" main-class=\"" + string13 + "\" ");
                    printStream.println(" name=\"" + string11 + "\" >");
                    printStream.println("    <param name=\"requiredFXVersion\" value=\"" + (String)FX_PLATFORM.fetchFrom(map) + "\"/>");
                    printStream.println("  </applet-desc>");
                }
                printStream.print("  <jfx:javafx-desc  width=\"" + object3 + "\" height=\"" + object5 + "\"");
                printStream.print(" main-class=\"" + string10 + "\" ");
                printStream.print(" name=\"" + string11 + "\" ");
                if (object2 != null) {
                    printStream.print(" preloader-class=\"" + (String)object2 + "\"");
                }
                if ((object == null || object.isEmpty()) && (list == null || list.isEmpty())) {
                    printStream.println("/>");
                } else {
                    printStream.println(">");
                    if (object != null) {
                        for (Map.Entry entry : object.entrySet()) {
                            printStream.println("    <fx:param name=\"" + (String)entry.getKey() + "\"" + (entry.getValue() != null ? " value=\"" + (String)entry.getValue() + "\"" : "") + "/>");
                        }
                    }
                    if (list != null) {
                        for (String string14 : list) {
                            printStream.println("    <fx:argument>" + string14 + "</fx:argument>");
                        }
                    }
                    printStream.println("  </jfx:javafx-desc>");
                }
            }
        }
        printStream.println("  <update check=\"" + (String)UPDATE_MODE.fetchFrom(map) + "\"/>");
        printStream.println("</jnlp>");
    }

    private void addToList(List<String> list, String string, String string2, boolean bl) {
        String string3 = bl ? "'" : "";
        String string4 = string + " : " + string3 + string2 + string3;
        list.add(string4);
    }

    private String listToString(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list == null || list.isEmpty()) {
            return string + "{}";
        }
        stringBuilder.append(string).append("{\n");
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                stringBuilder.append(",\n");
            }
            bl = false;
            stringBuilder.append(string).append("    ");
            stringBuilder.append(string2);
        }
        stringBuilder.append("\n");
        stringBuilder.append(string).append("}");
        return stringBuilder.toString();
    }

    private String encodeAsBase64(byte[] byArray) {
        return Base64.getEncoder().encodeToString(byArray);
    }

    private void generateHTML(Map<String, ? super Object> map, PrintStream printStream, byte[] byArray, String string, byte[] byArray2, String string2, Map<TemplatePlaceholders, String> map2, boolean bl) {
        boolean bl2;
        String string3 = "    ";
        String string4 = string3 + string3;
        String string5 = string4 + string3;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        String string6 = this.getAppletParameters(map);
        String string7 = null;
        String string8 = null;
        boolean bl3 = (Boolean)EMBED_JNLP.fetchFrom(map);
        boolean bl4 = (Boolean)INCLUDE_DT.fetchFrom(map);
        if (bl3) {
            string7 = this.encodeAsBase64(byArray);
            string8 = this.encodeAsBase64(byArray2);
        }
        printStream.println("<html><head>");
        String string9 = bl4 ? EMBEDDED_DT : PUBLIC_DT;
        String string10 = "<SCRIPT src=\"" + string9 + "\"></SCRIPT>";
        if (map2 != null) {
            map2.put(TemplatePlaceholders.SCRIPT_URL, string9);
            map2.put(TemplatePlaceholders.SCRIPT_CODE, string10);
        }
        printStream.println("  " + string10);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.addToList(arrayList, "url", string2, true);
        if (string8 != null) {
            this.addToList(arrayList, "jnlp_content", string8, true);
        }
        this.addToList(arrayList2, "javafx", (String)FX_PLATFORM.fetchFrom(map), true);
        String string11 = this.getJvmArguments(map, true);
        if (string11 != null) {
            this.addToList(arrayList2, "jvmargs", string11, true);
        }
        if (!"".equals(string6)) {
            this.addToList(arrayList, "params", "{" + string6 + "}", false);
        }
        for (Map.Entry object22 : ((Map)JS_CALLBACKS.fetchFrom(map)).entrySet()) {
            this.addToList(arrayList3, (String)object22.getKey(), (String)object22.getValue(), false);
        }
        stringBuilder3.append(string4).append("dtjava.launch(");
        stringBuilder3.append(this.listToString(arrayList, string5)).append(",\n");
        stringBuilder3.append(this.listToString(arrayList2, string5)).append(",\n");
        stringBuilder3.append(this.listToString(arrayList3, string5)).append("\n");
        stringBuilder3.append(string4).append(");\n");
        printStream.println("<script>");
        printStream.println(string3 + "function launchApplication(jnlpfile) {");
        printStream.print(stringBuilder3.toString());
        printStream.println(string4 + "return false;");
        printStream.println(string3 + "}");
        printStream.println("</script>");
        if (map2 != null) {
            map2.put(TemplatePlaceholders.LAUNCH_CODE, stringBuilder3.toString());
        }
        String string12 = (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map);
        String string13 = (String)PLACEHOLDER.fetchFrom(map);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        if (string12 != null) {
            this.addToList(arrayList4, "id", string12, true);
        }
        if (bl2 = ((Boolean)SWING_APP.fetchFrom(map)).booleanValue()) {
            this.addToList(arrayList4, "toolkit", "swing", true);
        }
        this.addToList(arrayList4, "url", string, true);
        this.addToList(arrayList4, "placeholder", string13, false);
        this.addToList(arrayList4, "width", (String)EMBEDDED_WIDTH.fetchFrom(map), true);
        this.addToList(arrayList4, "height", (String)EMBEDDED_HEIGHT.fetchFrom(map), true);
        if (string7 != null) {
            this.addToList(arrayList4, "jnlp_content", string7, true);
        }
        this.addToList(arrayList5, "javafx", (String)FX_PLATFORM.fetchFrom(map), true);
        if (string11 != null) {
            this.addToList(arrayList5, "jvmargs", string11, true);
        }
        for (Map.Entry entry : ((Map)JS_CALLBACKS.fetchFrom(map)).entrySet()) {
            this.addToList(arrayList3, (String)entry.getKey(), (String)entry.getValue(), false);
        }
        if (!"".equals(string6)) {
            this.addToList(arrayList4, "params", "{" + string6 + "}", false);
        }
        if (bl) {
            boolean bl5 = true;
            for (String string14 : ((Map)JS_CALLBACKS.fetchFrom(map)).keySet()) {
                if (!"onGetSplash".equals(string14)) continue;
                bl5 = false;
            }
            if (bl5) {
                this.addToList(arrayList6, "onGetSplash", "function() {}", false);
            }
        }
        stringBuilder.append("dtjava.embed(\n");
        stringBuilder.append(this.listToString(arrayList4, string5)).append(",\n");
        stringBuilder.append(this.listToString(arrayList5, string5)).append(",\n");
        stringBuilder.append(this.listToString(arrayList6, string5)).append("\n");
        stringBuilder.append(string4).append(");\n");
        String bl5 = "javafxEmbed" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map);
        stringBuilder2.append("\n<script>\n");
        stringBuilder2.append(string3).append("function ").append(bl5).append("() {\n");
        stringBuilder2.append(string4);
        stringBuilder2.append((CharSequence)stringBuilder);
        stringBuilder2.append(string3).append("}\n");
        stringBuilder2.append(string3).append("<!-- Embed FX application into web page once page is loaded -->\n");
        stringBuilder2.append(string3).append("dtjava.addOnloadCallback(").append(bl5).append(");\n");
        stringBuilder2.append("</script>\n");
        if (map2 != null) {
            map2.put(TemplatePlaceholders.EMBED_CODE_ONLOAD, stringBuilder2.toString());
            map2.put(TemplatePlaceholders.EMBED_CODE_DYNAMIC, stringBuilder.toString());
        }
        printStream.println(stringBuilder2.toString());
        printStream.println("</head><body>");
        printStream.println("<h2>Test page for <b>" + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "</b></h2>");
        String string15 = "return launchApplication('" + string2 + "');";
        printStream.println("  <b>Webstart:</b> <a href='" + string2 + "' onclick=\"" + string15 + "\">" + "click to launch this app as webstart</a><br><hr><br>");
        printStream.println("");
        printStream.println("  <!-- Applet will be inserted here -->");
        printStream.println("  <div id=" + string13 + "></div>");
        printStream.println("</body></html>");
    }

    private void save(File file, String string, byte[] byArray) throws IOException {
        this.save(new File(file, string), byArray);
    }

    private void save(File file, byte[] byArray) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    private static void copyFileToOutDir(InputStream inputStream, File file) throws PackagerException {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new PackagerException("ERR_CreatingDirFailed", file2.getPath());
        }
        try (InputStream inputStream2 = inputStream;
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[16384];
            while ((n = inputStream2.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new PackagerException(iOException, "ERR_FileCopyFailed", file2.getPath());
        }
    }

    private String getAppletParameters(Map<String, ? super Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Map.Entry entry : ((Map)ESCAPED_APPLET_PARAMS.fetchFrom(map)).entrySet()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("'").append(this.quoteEscape((String)entry.getKey())).append("' : '").append(this.quoteEscape((String)entry.getValue())).append("'");
        }
        for (Map.Entry entry : ((Map)APPLET_PARAMS.fetchFrom(map)).entrySet()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("'").append(this.quoteEscape((String)entry.getKey())).append("' : ").append((String)entry.getValue());
        }
        return stringBuilder.toString();
    }

    String quoteEscape(String string) {
        return string.replaceAll("(['\"\\\\])", "\\\\$1");
    }

    private boolean extractWebFiles(File file) throws PackagerException {
        return this.doExtractWebFiles(webFiles, file, webfilesDir);
    }

    private boolean doExtractWebFiles(String[] stringArray, File file, String string) throws PackagerException {
        File file2 = new File(file, string);
        file2.mkdirs();
        for (String string2 : stringArray) {
            InputStream inputStream = PackagerLib.class.getResourceAsStream(prefixWebFiles + string2);
            if (inputStream == null) {
                System.err.println("Internal error. Missing resources [" + prefixWebFiles + string2 + "]");
                return false;
            }
            JNLPBundler.copyFileToOutDir(inputStream, new File(file2, string2));
        }
        return true;
    }

    private static enum Mode {
        FX,
        APPLET,
        SwingAPP;

    }
}

