/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui;

import com.jrockit.mc.core.AdapterUtil;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;

public class MCPathEditorInput
implements IPathEditorInput,
IPersistableElement {
    private final File m_file;
    private final boolean m_persistable;

    public MCPathEditorInput(File file) {
        this(file, false);
    }

    public MCPathEditorInput(File file, boolean persistable) {
        this.m_file = file;
        this.m_persistable = persistable;
    }

    public boolean exists() {
        return this.m_file.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.m_file.getName();
    }

    public IPersistableElement getPersistable() {
        if (this.m_persistable) {
            return this;
        }
        return null;
    }

    public String getToolTipText() {
        return this.m_file.getPath();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.m_file.getAbsolutePath());
    }

    public boolean equals(Object object) {
        if (object instanceof IEditorInput) {
            return this.m_file.equals(MCPathEditorInput.getFile((IEditorInput)object));
        }
        return false;
    }

    public int hashCode() {
        return this.m_file.hashCode();
    }

    public String getFactoryId() {
        return "mc.path.editorinput";
    }

    public void saveState(IMemento memento) {
        memento.putString("portable.string", this.m_file.getAbsolutePath());
        memento.putInteger("persist.editor", this.m_persistable ? 1 : 0);
    }

    public static File getFile(IEditorInput ei) {
        IPathEditorInput ped = (IPathEditorInput)AdapterUtil.getAdapter((Object)ei, IPathEditorInput.class);
        if (ped != null) {
            return ped.getPath().toFile();
        }
        return null;
    }
}

