/*
 * Copyright (c) 1998, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package javax.security.auth;

/**
 * This class is for authentication permissions.
 * An AuthPermission contains a name
 * (also referred to as a "target name")
 * but no actions list; you either have the named permission
 * or you don't.
 *
 * <p> The target name is the name of a security configuration parameter
 * (see below).  Currently the AuthPermission object is used to
 * guard access to the Policy, Subject, LoginContext,
 * and Configuration objects.
 *
 * <p> The possible target names for an Authentication Permission are:
 *
 * <pre>
 *      doAs -                  allow the caller to invoke the
 *                              {@code Subject.doAs} methods.
 *
 *      doAsPrivileged -        allow the caller to invoke the
 *                              {@code Subject.doAsPrivileged} methods.
 *
 *      getSubject -            allow for the retrieval of the
 *                              Subject(s) associated with the
 *                              current Thread.
 *
 *      getSubjectFromDomainCombiner -  allow for the retrieval of the
 *                              Subject associated with the
 *                              a {@code SubjectDomainCombiner}.
 *
 *      setReadOnly -           allow the caller to set a Subject
 *                              to be read-only.
 *
 *      modifyPrincipals -      allow the caller to modify the {@code Set}
 *                              of Principals associated with a
 *                              {@code Subject}
 *
 *      modifyPublicCredentials - allow the caller to modify the
 *                              {@code Set} of public credentials
 *                              associated with a {@code Subject}
 *
 *      modifyPrivateCredentials - allow the caller to modify the
 *                              {@code Set} of private credentials
 *                              associated with a {@code Subject}
 *
 *      refreshCredential -     allow code to invoke the {@code refresh}
 *                              method on a credential which implements
 *                              the {@code Refreshable} interface.
 *
 *      destroyCredential -     allow code to invoke the {@code destroy}
 *                              method on a credential {@code object}
 *                              which implements the {@code Destroyable}
 *                              interface.
 *
 *      createLoginContext.{name} -  allow code to instantiate a
 *                              {@code LoginContext} with the
 *                              specified <i>name</i>.  <i>name</i>
 *                              is used as the index into the installed login
 *                              {@code Configuration}
 *                              (that returned by
 *                              {@code Configuration.getConfiguration()}).
 *                              <i>name</i> can be wildcarded (set to '*')
 *                              to allow for any name.
 *
 *      getLoginConfiguration - allow for the retrieval of the system-wide
 *                              login Configuration.
 *
 *      createLoginConfiguration.{type} - allow code to obtain a Configuration
 *                              object via
 *                              {@code Configuration.getInstance}.
 *
 *      setLoginConfiguration - allow for the setting of the system-wide
 *                              login Configuration.
 *
 *      refreshLoginConfiguration - allow for the refreshing of the system-wide
 *                              login Configuration.
 * </pre>
 *
 * <p> The following target name has been deprecated in favor of
 * {@code createLoginContext.{name}}.
 *
 * <pre>
 *      createLoginContext -    allow code to instantiate a
 *                              {@code LoginContext}.
 * </pre>
 *
 * <p> {@code javax.security.auth.Policy} has been
 * deprecated in favor of {@code java.security.Policy}.
 * Therefore, the following target names have also been deprecated:
 *
 * <pre>
 *      getPolicy -             allow the caller to retrieve the system-wide
 *                              Subject-based access control policy.
 *
 *      setPolicy -             allow the caller to set the system-wide
 *                              Subject-based access control policy.
 *
 *      refreshPolicy -         allow the caller to refresh the system-wide
 *                              Subject-based access control policy.
 * </pre>
 *
 */
public final class AuthPermission extends
java.security.BasicPermission {

    private static final long serialVersionUID = 5806031445061587174L;

    /**
     * Creates a new AuthPermission with the specified name.
     * The name is the symbolic name of the AuthPermission.
     *
     * <p>
     *
     * @param name the name of the AuthPermission
     *
     * @throws NullPointerException if {@code name} is {@code null}.
     * @throws IllegalArgumentException if {@code name} is empty.
     */
    public AuthPermission(String name) {
        // for backwards compatibility --
        // createLoginContext is deprecated in favor of createLoginContext.*
        super("createLoginContext".equals(name) ?
                "createLoginContext.*" : name);
    }

    /**
     * Creates a new AuthPermission object with the specified name.
     * The name is the symbolic name of the AuthPermission, and the
     * actions String is currently unused and should be null.
     *
     * <p>
     *
     * @param name the name of the AuthPermission <p>
     *
     * @param actions should be null.
     *
     * @throws NullPointerException if {@code name} is {@code null}.
     * @throws IllegalArgumentException if {@code name} is empty.
     */
    public AuthPermission(String name, String actions) {
        // for backwards compatibility --
        // createLoginContext is deprecated in favor of createLoginContext.*
        super("createLoginContext".equals(name) ?
                "createLoginContext.*" : name, actions);
    }
}
