/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json.impl;

import com.oracle.javafx.jmx.json.JSONException;
import com.oracle.javafx.jmx.json.impl.JSONMessages;
import com.oracle.javafx.jmx.json.impl.JSONScanner;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;

enum JSONSymbol {
    X,
    O,
    O1,
    O3,
    OV,
    A,
    A1,
    A2,
    V,
    VA,
    CURLYOPEN,
    CURLYCLOSE,
    COLON,
    COMMA,
    SQUAREOPEN,
    SQUARECLOSE,
    KEYWORD,
    STRING,
    NUMBER,
    EOS,
    X_,
    O_,
    O1_,
    O3_,
    OV_,
    A_,
    A1_,
    A2_,
    V_,
    VA_;

    static final boolean DEBUG = false;
    boolean isTerminal = true;
    boolean isMarker = false;
    HashMap<JSONSymbol, JSONSymbol[]> transitions;
    JSONSymbol markerSymbol;
    private static Stack<JSONSymbol> stack;
    private static JSONSymbol terminal;
    private static JSONSymbol current;
    private static JSONScanner scanner;
    private static String value;

    private void transition(JSONSymbol jSONSymbol, JSONSymbol[] jSONSymbolArray) {
        if (this.isTerminal) {
            this.isTerminal = false;
            this.transitions = new HashMap();
        }
        this.transitions.put(jSONSymbol, jSONSymbolArray);
    }

    private void marker(JSONSymbol jSONSymbol) {
        this.markerSymbol = jSONSymbol;
        jSONSymbol.isMarker = true;
    }

    static void init(JSONScanner jSONScanner) throws JSONException, IOException {
        scanner = jSONScanner;
        stack = new Stack();
        stack.push(X);
        terminal = scanner.nextSymbol();
    }

    static JSONSymbol next() throws JSONException, IOException {
        current = stack.pop();
        if (JSONSymbol.current.isMarker) {
            if (current == X_) {
                return current;
            }
        } else if (JSONSymbol.current.isTerminal) {
            if (current != terminal) {
                Object[] objectArray = new Object[]{current, terminal};
                throw new JSONException(JSONMessages.localize(objectArray, "expected_but_found"), scanner.line(), scanner.column());
            }
            value = scanner.getValue();
            terminal = scanner.nextSymbol();
        } else {
            JSONSymbol[] jSONSymbolArray = JSONSymbol.current.transitions.get((Object)terminal);
            if (jSONSymbolArray == null) {
                Object[] objectArray = new Object[]{terminal, current};
                throw new JSONException(JSONMessages.localize(objectArray, "unexpected_terminal"), scanner.line(), scanner.column());
            }
            stack.push(JSONSymbol.current.markerSymbol);
            int n = jSONSymbolArray.length;
            while (--n >= 0) {
                JSONSymbol jSONSymbol = jSONSymbolArray[n];
                stack.push(jSONSymbol);
            }
        }
        return current;
    }

    static String getValue() {
        return value;
    }

    static {
        JSONSymbol[] jSONSymbolArray = new JSONSymbol[]{};
        X.transition(CURLYOPEN, new JSONSymbol[]{O});
        X.transition(SQUAREOPEN, new JSONSymbol[]{A});
        O.transition(CURLYOPEN, new JSONSymbol[]{CURLYOPEN, O1, CURLYCLOSE});
        O1.transition(CURLYCLOSE, jSONSymbolArray);
        O1.transition(STRING, new JSONSymbol[]{OV, O3});
        O3.transition(CURLYCLOSE, jSONSymbolArray);
        O3.transition(COMMA, new JSONSymbol[]{COMMA, OV, O3});
        OV.transition(STRING, new JSONSymbol[]{STRING, COLON, V});
        A.transition(SQUAREOPEN, new JSONSymbol[]{SQUAREOPEN, A1, SQUARECLOSE});
        A1.transition(CURLYOPEN, new JSONSymbol[]{VA, A2});
        A1.transition(SQUAREOPEN, new JSONSymbol[]{VA, A2});
        A1.transition(SQUARECLOSE, jSONSymbolArray);
        A1.transition(KEYWORD, new JSONSymbol[]{VA, A2});
        A1.transition(STRING, new JSONSymbol[]{VA, A2});
        A1.transition(NUMBER, new JSONSymbol[]{VA, A2});
        A2.transition(COMMA, new JSONSymbol[]{COMMA, VA, A2});
        A2.transition(SQUARECLOSE, jSONSymbolArray);
        VA.transition(CURLYOPEN, new JSONSymbol[]{V});
        VA.transition(SQUAREOPEN, new JSONSymbol[]{V});
        VA.transition(STRING, new JSONSymbol[]{V});
        VA.transition(NUMBER, new JSONSymbol[]{V});
        VA.transition(KEYWORD, new JSONSymbol[]{V});
        V.transition(CURLYOPEN, new JSONSymbol[]{O});
        V.transition(SQUAREOPEN, new JSONSymbol[]{A});
        V.transition(KEYWORD, new JSONSymbol[]{KEYWORD});
        V.transition(STRING, new JSONSymbol[]{STRING});
        V.transition(NUMBER, new JSONSymbol[]{NUMBER});
        X.marker(X_);
        O.marker(O_);
        O1.marker(O1_);
        O3.marker(O3_);
        OV.marker(OV_);
        A.marker(A_);
        A1.marker(A1_);
        A2.marker(A2_);
        VA.marker(VA_);
        V.marker(V_);
    }
}

