/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptorCategory;
import com.jrockit.mc.components.ui.components.ComponentTypeRegistry;
import com.jrockit.mc.components.ui.design.LayoutData;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.ui.layout.SimpleLayoutData;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public final class LayoutToolkit {
    private LayoutToolkit() {
        throw new Error("Don't instantiate!");
    }

    public static Object createSimpleLayoutData(LayoutItem layoutItem) {
        return LayoutToolkit.createSimpleLayoutData(layoutItem, true);
    }

    public static Object createSimpleLayoutData(LayoutItem layoutItem, boolean allowPreferredSize) {
        SimpleLayoutData sl = new SimpleLayoutData();
        LayoutToolkit.updateSimpleLayoutData(sl, layoutItem.getLayoutData(), allowPreferredSize);
        return sl;
    }

    public static void updateSimpleLayoutData(SimpleLayoutData sl, LayoutData ld, boolean allowPreferredSize) {
        int minSize = ld.getMinimumSize();
        int maxSize = ld.getMaximumSize();
        sl.setMinSize(minSize != Integer.MIN_VALUE || allowPreferredSize ? minSize : 0);
        sl.setMaxSize(maxSize != Integer.MIN_VALUE || allowPreferredSize ? maxSize : Integer.MAX_VALUE);
        sl.setWeight(LayoutToolkit.convertWeight(ld.getWeight()));
    }

    private static float convertWeight(double weight) {
        if (weight == Double.POSITIVE_INFINITY) {
            return Float.MAX_VALUE;
        }
        if (weight == 0.0) {
            return 10.0f;
        }
        return (float)(10.0 / weight);
    }

    public static String getDisplayName(LayoutItem li) {
        return LayoutToolkit.getDisplayName(li.getComponentDescriptor());
    }

    public static String getDisplayName(ComponentDescriptor cd) {
        String name = cd.getName();
        if (name.length() == 0) {
            ComponentTypeDescriptor ctd = ComponentsPlugin.getDefault().getComponentTypeRegistry().getComponentTypeDescriptor(cd.getTypeIdentifier());
            if (ctd != null) {
                return NLS.bind((String)"[%0]", (Object)ctd.getName());
            }
            return Messages.LAYOUT_TOOLKIT_UNKNOWN_COMPONENT_TYPE_TEXT;
        }
        return name;
    }

    public static boolean removeItem(LayoutItem parentItem, LayoutItem removeItem) {
        for (LayoutItem li : new ArrayList<LayoutItem>(parentItem.getChildren())) {
            if (li != removeItem) continue;
            parentItem.remove(removeItem);
            ComponentTypeRegistry r = ComponentsPlugin.getDefault().getComponentTypeRegistry();
            ComponentTypeDescriptorCategory ctdc = r.getComponentTypeDescriptorCategory(parentItem.getComponentDescriptor());
            if (ctdc.isContainer() && parentItem.getChildren().isEmpty()) {
                parentItem.resetComponentDescriptor();
            }
            removeItem.deleteObservers();
            parentItem.setChanged();
            return true;
        }
        return false;
    }
}

