/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateEditAdvancedPage;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateEditSimplePage;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class TemplateEditPage
extends WizardPage
implements IPerformFinishable {
    private static final int ADVANCED_BUTTON_ID = 1025;
    protected final RecordingTemplateModel model;
    protected final RecordingTemplateRepository repository;
    private Text nameControl;
    private Text descriptionControl;

    public static Dialog createDialogFor(Shell shell, RecordingTemplateModel model, RecordingTemplateRepository repository) {
        return TemplateEditPage.createDialogFor(shell, model, repository, true);
    }

    protected static Dialog createDialogFor(Shell shell, final RecordingTemplateModel model, final RecordingTemplateRepository repository, boolean preferSimple) {
        OnePageWizardDialog dialog;
        if (preferSimple && model.getTemplate().hasControlElements()) {
            TemplateEditSimplePage page = new TemplateEditSimplePage(model, repository);
            dialog = new OnePageWizardDialog(shell, (IWizardPage)page){

                protected void createButtonsForButtonBar(Composite parent) {
                    ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
                    this.createButton(parent, 1025, Messages.BUTTON_ADVANCED_TEXT, false);
                    super.createButtonsForButtonBar(parent);
                }

                protected void buttonPressed(int buttonId) {
                    if (buttonId == 1025) {
                        IRecordingConfiguration advClone = model.getTemplate().createClone();
                        RecordingTemplateModel advModel = new RecordingTemplateModel(advClone, model.getServerSettings(), model.getEventTypeInfos());
                        Dialog advDialog = TemplateEditPage.createDialogFor(this.getShell(), advModel, repository, false);
                        if (advDialog.open() == 0) {
                            this.setReturnCode(0);
                            this.close();
                        }
                    } else {
                        super.buttonPressed(buttonId);
                    }
                }
            };
        } else {
            TemplateEditAdvancedPage page = new TemplateEditAdvancedPage(model, repository);
            dialog = new OnePageWizardDialog(shell, (IWizardPage)page);
        }
        dialog.setWidthConstraint(600, 800);
        dialog.setHeightConstraint(600, 800);
        return dialog;
    }

    public TemplateEditPage(RecordingTemplateModel model, RecordingTemplateRepository repository, String pageName, String title) {
        super(pageName, title, null);
        this.model = model;
        this.repository = repository;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createGeneralArea(container).setLayoutData((Object)new GridData(4, 128, true, false));
        this.createSpecificArea(container);
        this.setControl((Control)container);
    }

    protected Control createGeneralArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.createNameControls(container);
        this.createDescriptionControls(container);
        return container;
    }

    private void createNameControls(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_NAME_TEXT);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        this.nameControl = new Text(parent, 2048);
        this.nameControl.setText(this.model.getTemplate().getName());
        this.nameControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateEditPage.this.model.getTemplate().setName(TemplateEditPage.this.nameControl.getText());
                TemplateEditPage.this.verifyName();
            }
        });
        this.nameControl.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.verifyName();
    }

    private void verifyName() {
        String oldName;
        String newName = this.nameControl.getText();
        boolean ok = newName.equals(oldName = this.model.getTemplate().getOriginal().getName()) || this.repository.isAllowedName(newName);
        this.setErrorMessage(ok ? null : Messages.SAVE_TEMPLATE_WIZARD_PAGE_DUPLICATE_ERROR_MSG);
        this.setPageComplete(ok);
    }

    private void createDescriptionControls(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_DESCRIPTION_TEXT);
        label.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        this.descriptionControl = new Text(parent, 2626);
        this.descriptionControl.setText(this.model.getTemplate().getDescription());
        this.descriptionControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateEditPage.this.model.getTemplate().setDescription(TemplateEditPage.this.descriptionControl.getText());
            }
        });
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = this.convertHeightInCharsToPixels(4);
        this.descriptionControl.setLayoutData((Object)gd);
    }

    protected abstract void createSpecificArea(Composite var1);

    public boolean performFinish() {
        if (this.isPageComplete()) {
            IRecordingConfiguration workingCopy = this.model.getTemplate();
            return this.repository.replaceOriginalContentsFor(workingCopy);
        }
        return false;
    }
}

