/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class BoundedList<T>
implements Iterable<T> {
    private int maxSize;
    private int size;
    private INode<T> first;
    private INode<T> last;

    public BoundedList(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public synchronized void add(T t) {
        if (t instanceof INode) {
            INode node = (INode)t;
            this.addNode(node);
        } else {
            this.addNode(new Node<T>(t));
        }
    }

    private void addNode(INode<T> t) {
        if (this.first == null) {
            this.first = t;
            this.last = t;
        } else {
            this.last.setNext(t);
            this.last = t;
        }
        ++this.size;
        if (this.size > this.maxSize) {
            this.first = this.first.getNext();
            --this.size;
        }
    }

    @Override
    public synchronized Iterator<T> iterator() {
        BoundedIterator iter = new BoundedIterator(this.size, this.first, this.last);
        return iter;
    }

    public synchronized T getFirst() {
        return this.first == null ? null : (T)this.first.getValue();
    }

    public synchronized T getLast() {
        return this.last == null ? null : (T)this.last.getValue();
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Can not have maximum size of less than 1!");
        }
        BoundedList boundedList = this;
        synchronized (boundedList) {
            this.maxSize = maxSize;
            while (this.size > maxSize) {
                this.first = this.first.getNext();
                --this.size;
            }
        }
    }

    public String toString() {
        return this.iterator().toString();
    }

    public synchronized void clear() {
        this.size = 0;
        this.first = null;
        this.last = null;
    }

    private class BoundedIterator
    implements Iterator<T>,
    Iterable<T> {
        private final int size;
        private INode<T> current;
        private final INode<T> last;

        BoundedIterator(int size, INode<T> first, INode<T> last) {
            this.current = first;
            this.last = last;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.current != null && this.current != this.last.getNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements!");
            }
            Object value = this.current.getValue();
            this.current = this.current.getNext();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("BoundedList does not support remove!");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        public String toString() {
            return String.format("BoundedIterator size=%d, maxSize=%d, current=%d, last=%d ", this.size, BoundedList.this.getMaxSize(), this.current.getValue(), this.last.getValue());
        }
    }

    public static interface INode<T> {
        public INode<T> getNext();

        public void setNext(INode<T> var1);

        public T getValue();
    }

    private static class Node<T>
    implements INode<T> {
        private final T value;
        private INode<T> next;

        public Node(T value) {
            this.value = value;
        }

        @Override
        public Node<T> getNext() {
            return (Node)this.next;
        }

        @Override
        public void setNext(INode<T> next) {
            this.next = next;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }
}

