/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputKind;
import org.openide.windows.IOColors;
import org.openide.windows.OutputListener;

public class LineInfo {
    List<Segment> segments = new CopyOnWriteArrayList<Segment>();
    final Lines parent;

    LineInfo(Lines lines) {
        this.parent = lines;
    }

    LineInfo(Lines lines, int n) {
        this(lines, n, OutputKind.OUT, null, null, null, false);
    }

    LineInfo(Lines lines, int n, OutputKind outputKind, OutputListener outputListener, Color color, Color color2, boolean bl) {
        this.parent = lines;
        this.addSegment(n, outputKind, outputListener, color, color2, bl);
    }

    int getEnd() {
        return this.segments.isEmpty() ? 0 : this.segments.get(this.segments.size() - 1).getEnd();
    }

    void addSegment(int n, OutputKind outputKind, OutputListener outputListener, Color color, Color color2, boolean bl) {
        boolean bl2;
        Segment segment = null;
        if (!this.segments.isEmpty() && (segment = this.segments.get(this.segments.size() - 1)).getKind() == outputKind && segment.getListener() == outputListener && this.hasColors(segment, color, color2)) {
            segment.end = n;
            return;
        }
        boolean bl3 = bl2 = color != null || color2 != null;
        segment = outputListener != null ? (bl2 ? new ColorListenerSegment(n, outputListener, bl, color, color2) : new ListenerSegment(n, outputListener, bl)) : (bl2 ? new ColorSegment(n, outputKind, color, color2) : new Segment(n, outputKind));
        this.segments.add(segment);
    }

    private boolean hasColors(Segment segment, Color color, Color color2) {
        return this.hasForeground(segment, color) && this.hasBackground(segment, color2);
    }

    private boolean hasForeground(Segment segment, Color color) {
        return segment.getCustomColor() == color || color != null && color.equals(segment.getCustomColor());
    }

    private boolean hasBackground(Segment segment, Color color) {
        return segment.getCustomBackground() == color || color != null && color.equals(segment.getCustomBackground());
    }

    OutputListener getListenerAfter(int n, int[] nArray) {
        int n2 = 0;
        for (Segment segment : this.segments) {
            if (segment.getEnd() < n) continue;
            if (segment.getListener() != null) {
                if (nArray != null) {
                    nArray[0] = n2;
                    nArray[1] = segment.getEnd();
                }
                return segment.getListener();
            }
            n2 = segment.getEnd();
        }
        return null;
    }

    OutputListener getListenerBefore(int n, int[] nArray) {
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            int n2;
            int n3 = n2 = i == 0 ? 0 : this.segments.get(i - 1).getEnd();
            if (n2 > n || this.segments.get(i).getListener() == null) continue;
            if (nArray != null) {
                nArray[0] = n2;
                nArray[1] = this.segments.get(i).getEnd();
            }
            return this.segments.get(i).getListener();
        }
        return null;
    }

    OutputListener getFirstListener(int[] nArray) {
        int n = 0;
        for (Segment segment : this.segments) {
            if (segment.getListener() != null) {
                if (nArray != null) {
                    nArray[0] = n;
                    nArray[1] = segment.getEnd();
                }
                return segment.getListener();
            }
            n = segment.getEnd();
        }
        return null;
    }

    OutputListener getLastListener(int[] nArray) {
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            Segment segment = this.segments.get(i);
            if (segment.getListener() == null) continue;
            if (nArray != null) {
                nArray[0] = i == 0 ? 0 : this.segments.get(i - 1).getEnd();
                nArray[1] = segment.getEnd();
            }
            return segment.getListener();
        }
        return null;
    }

    Collection<Segment> getLineSegments() {
        return this.segments;
    }

    Collection<OutputListener> getListeners() {
        ArrayList<OutputListener> arrayList = new ArrayList<OutputListener>();
        for (Segment segment : this.segments) {
            OutputListener outputListener = segment.getListener();
            if (outputListener == null) continue;
            arrayList.add(outputListener);
        }
        return arrayList;
    }

    private class ColorListenerSegment
    extends ListenerSegment {
        final Color color;
        final Color background;

        public ColorListenerSegment(int n, OutputListener outputListener, boolean bl, Color color, Color color2) {
            super(n, outputListener, bl);
            this.color = color == null ? super.getColor() : color;
            this.background = color2;
        }

        @Override
        Color getColor() {
            return this.color;
        }

        @Override
        Color getCustomColor() {
            return this.color;
        }

        @Override
        Color getCustomBackground() {
            return this.background;
        }
    }

    private class ListenerSegment
    extends Segment {
        final OutputListener listener;
        final boolean important;

        public ListenerSegment(int n, OutputListener outputListener, boolean bl) {
            super(n, OutputKind.OUT);
            this.listener = outputListener;
            this.important = bl;
        }

        @Override
        OutputListener getListener() {
            return this.listener;
        }

        @Override
        Color getColor() {
            return LineInfo.this.parent.getDefColor(this.important ? IOColors.OutputType.HYPERLINK_IMPORTANT : IOColors.OutputType.HYPERLINK);
        }
    }

    private class ColorSegment
    extends Segment {
        final Color color;
        final Color background;

        public ColorSegment(int n, OutputKind outputKind, Color color, Color color2) {
            super(n, outputKind);
            this.color = color == null ? super.getColor() : color;
            this.background = color2;
        }

        @Override
        Color getColor() {
            return this.color;
        }

        @Override
        Color getCustomColor() {
            return this.color;
        }

        @Override
        Color getCustomBackground() {
            return this.background;
        }
    }

    public class Segment {
        private int end;
        private OutputKind outputKind;

        Segment(int n, OutputKind outputKind) {
            this.end = n;
            this.outputKind = outputKind;
        }

        int getEnd() {
            return this.end;
        }

        OutputListener getListener() {
            return null;
        }

        OutputKind getKind() {
            return this.outputKind;
        }

        Color getColor() {
            IOColors.OutputType outputType;
            switch (this.outputKind) {
                case OUT: {
                    outputType = IOColors.OutputType.OUTPUT;
                    break;
                }
                case ERR: {
                    outputType = IOColors.OutputType.ERROR;
                    break;
                }
                case IN: {
                    outputType = IOColors.OutputType.INPUT;
                    break;
                }
                default: {
                    outputType = IOColors.OutputType.OUTPUT;
                }
            }
            return LineInfo.this.parent.getDefColor(outputType);
        }

        Color getCustomColor() {
            return null;
        }

        Color getCustomBackground() {
            return null;
        }
    }
}

