/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.util.ColorToolkit;
import java.awt.Color;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class EventAppearance {
    private static final Map<String, String> HUMAN_NAMES;
    private static final Map<String, Color> COLORS;

    static {
        Properties props = EventAppearance.loadProperties("segments.properties");
        HashMap<String, String> segments = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            segments.put(key.toLowerCase(Locale.ENGLISH), (String)entry.getValue());
        }
        HUMAN_NAMES = Collections.unmodifiableMap(segments);
        props = EventAppearance.loadProperties("colors.properties");
        HashMap<String, Color> colors = new HashMap<String, Color>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String colStr = (String)entry.getValue();
            try {
                String key = (String)entry.getKey();
                Color color = new Color(Integer.valueOf(colStr, 16));
                colors.put(key.toLowerCase(Locale.ENGLISH), color);
            }
            catch (NumberFormatException e) {
                System.err.println("Couldn't parse color " + colStr + ". Please use a hexadecimal RRGGBB string.");
                e.printStackTrace();
            }
        }
        COLORS = Collections.unmodifiableMap(colors);
    }

    private static Properties loadProperties(String fileName) {
        Properties properties = new Properties();
        InputStream in = EventAppearance.class.getResourceAsStream(fileName);
        if (in != null) {
            try {
                try {
                    properties.load(in);
                }
                catch (IOException e) {
                    System.err.println("Problem loading file '" + fileName + "'");
                    e.printStackTrace();
                    IOToolkit.closeSilently((Closeable)in);
                }
            }
            finally {
                IOToolkit.closeSilently((Closeable)in);
            }
        } else {
            System.err.println("Couldn't find file '" + fileName + "'");
        }
        return properties;
    }

    public static Color getColor(String path) {
        Color color = COLORS.get(path = path.toLowerCase(Locale.ENGLISH));
        if (color == null) {
            color = ColorToolkit.getDistinguishableColor((Object)path);
        }
        return color;
    }

    public static String getHumanSegmentName(String path) {
        String humanName = HUMAN_NAMES.get(path = path.toLowerCase(Locale.ENGLISH));
        if (humanName != null) {
            return humanName;
        }
        int index = path.lastIndexOf(47);
        String identifier = index >= 0 ? path.substring(index + 1) : path;
        return EventAppearance.humanifyName(identifier);
    }

    public static String humanifyName(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.length() == 0) {
            return "<Empty>";
        }
        StringBuilder humanReadable = new StringBuilder(identifier.length());
        boolean firstLetter = true;
        int n = 0;
        while (n < identifier.length()) {
            char c = identifier.charAt(n);
            if (c == '_') {
                c = ' ';
            }
            if (firstLetter && Character.isLetter(c)) {
                humanReadable.append(Character.toUpperCase(c));
            } else {
                humanReadable.append(c);
            }
            firstLetter = c == ' ';
            ++n;
        }
        return humanReadable.toString();
    }
}

