/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.components.MachineParams;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SorterStatusTask
extends Thread {
    private static final Logger logger = Logger.getLogger(SorterStatusTask.class);
    private static final long MACHINE_IN_ACTIVE_TIME = 60000L;
    private static final int REQUEST_INTERVAL = 2000;

    public SorterStatusTask() {
        this.setName("Sorter-Status-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.reloadBasicConfig();
                this.sendMachineParams();
                this.sendSlotSortLockStatus();
                this.checkMachineActive();
                Thread.sleep(2000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void checkMachineActive() {
        long lastRecvTime = SorterParams.getInstance().getRecvHeartBeatTime();
        long now = System.currentTimeMillis();
        long delta = now - lastRecvTime;
        if (delta >= 60000L) {
            this.disconnectAllFrameChannel();
            SorterParams.getInstance().setRecvHeartBeatTime(System.currentTimeMillis());
        }
    }

    private void disconnectAllFrameChannel() {
        Channel[] channels;
        byte[] errorBuffer = new byte[]{2, 1, -18, 1, 13, 10};
        for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(channel, errorBuffer, true);
        }
    }

    private void reloadBasicConfig() {
        MachineParams.getInstance().loadBasicConfig();
    }

    private void sendMachineParams() {
        try {
            Channel[] channels;
            byte[] machineParamsBuf = SortProtocolCreator.getInstance().createMachineParams();
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, machineParamsBuf, false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SorterStatusTask.sendMachineParams] Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void sendSlotSortLockStatus() {
        try {
            Channel[] channels;
            byte[] slotLockStatus = SlotManager.getInstance().getSlotLockStatus();
            byte[] replyBuffer = SortProtocolCreator.getInstance().createSlotSoftLockStatus(slotLockStatus);
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SorterStatusTask.sendMachineParams] Catch an exception [" + ex.getMessage() + "]");
        }
    }
}

