/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortResult;
import org.apache.log4j.Logger;

public class SortResultOfferTask
extends Thread {
    private static final Logger logger = Logger.getLogger(SortResultOfferTask.class);
    private static final int REQUEST_INTERVAL = 1000;

    public SortResultOfferTask() {
        this.setName("Sort-Result-Offer-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.uploadSortResult();
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private Boolean uploadSortResult() {
        Boolean ret = false;
        SortInfo sortInfo = SortInfoManager.getInstance().createSortInfo();
        ICommand command = CommandCreator.getInstance().createCommand("FetchPacketOffCmd", sortInfo);
        ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (!ret.booleanValue()) {
            return ret;
        }
        int droppedSlotId = sortInfo.getDroppedSlotId();
        String slotId = String.valueOf(droppedSlotId);
        if (SlotManager.getInstance().checkSlotIsTrash(slotId).booleanValue()) {
            return ret;
        }
        SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
        if (slotInfo == null) {
            return ret;
        }
        SortResult sortResult = new SortResult();
        sortResult.setBoxCode(sortInfo.getBoxCode());
        sortResult.setSlotId(slotId);
        sortResult.getSortInfos().add(sortInfo);
        int uploadNum = sortInfo.getUploadNum() + 1;
        if (SlotManager.getInstance().checkSlotIsUpload(slotId).booleanValue()) {
            command = CommandCreator.getInstance().createCommand("WebPacketOffCmd", sortResult);
            ret = WebCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue()) {
                sortInfo.setUploadFlag(1);
            } else {
                sortInfo.setUploadFlag(0);
            }
            sortInfo.setUploadNum(uploadNum);
        } else {
            sortInfo.setUploadFlag(-1);
        }
        command = CommandCreator.getInstance().createCommand("RenewSortResultCmd", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
        return ret;
    }
}

