/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LogUtil;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PrinterInfoManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.PrinterInfo;
import com.simba.server.components.data.SlotInfo;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class SlotStatusTask
extends Thread {
    private static final Logger logger = Logger.getLogger(SlotStatusTask.class);
    private static final int REQUEST_INTERVAL = 10000;

    public SlotStatusTask() {
        this.setName("Slot-Status-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.reloadSlotConfig();
                this.reloadTshSlots();
                Thread.sleep(10000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void reloadSlotConfig() {
        try {
            LinkedList slots = new LinkedList();
            ICommand command = CommandCreator.getInstance().createCommand("FetchSlotInfoCmd", slots);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue()) {
                for (SlotInfo slotTmp : slots) {
                    String slotId = slotTmp.getSlotId();
                    String printerMasterId = slotTmp.getMasterPrinterId();
                    String printerSlaveId = slotTmp.getSlavePrinterId();
                    int slotDistrict = slotTmp.getSlotDistrict();
                    int needUpload = slotTmp.getNeedUpload();
                    SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
                    if (slotInfo == null) continue;
                    PrinterInfo printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerMasterId);
                    if (printerInfo != null) {
                        slotInfo.setMasterPrinterId(printerInfo.getPrinterId());
                        slotInfo.setMasterPrinterIp(printerInfo.getPrinterIp());
                    }
                    if ((printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerSlaveId)) != null) {
                        slotInfo.setSlavePrinterId(printerInfo.getPrinterId());
                        slotInfo.setSlavePrinterIp(printerInfo.getPrinterIp());
                    }
                    slotInfo.setSlotDistrict(slotDistrict);
                    slotInfo.setNeedUpload(needUpload);
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SlotStatusTask.reloadSlotConfig] reload slots config error: " + ex, 2));
        }
    }

    private void reloadTshSlots() {
        try {
            SlotManager.getInstance().reloadTshSlots();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
        }
    }
}

