/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.DeleteData;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DataClearTask
extends Thread {
    private static final Logger logger = Logger.getLogger(DataClearTask.class);
    private static final int REQUEST_INTERVAL = 30000;

    public DataClearTask() {
        this.setName("Data-Clear-Task");
    }

    public void doClearData() {
        this.doClearPacketOff();
        this.doClearSlotPack();
        this.doClearBoxInfo();
        this.doClearPacketOn();
        this.doClearScannedInfo();
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.deleteOverTimeSortData();
                Thread.sleep(30000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void deleteOverTimeSortData() {
        try {
            Timestamp nowTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = nowTime.toString();
            Date date = format.parse(time);
            int hour = date.getHours();
            int deleteDataTime = SorterParams.getInstance().getDeleteDataTime();
            if (hour == deleteDataTime) {
                this.doClearData();
            }
        }
        catch (ParseException ex) {
            LogUtil.LogError(logger, "[deleteOverTimeSortData] : Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void doClearBoxInfo() {
        int restoreDays = SorterParams.getInstance().getRestoreDaysBoxInfo();
        long restoreTime = restoreDays * 24 * 3600 * 1000;
        Timestamp deleteTime = new Timestamp(System.currentTimeMillis() - restoreTime);
        DeleteData deleteData = new DeleteData();
        deleteData.setDeleteBeforeTime(deleteTime);
        ICommand commandDelBoxInfo = CommandCreator.getInstance().createCommand("DelBoxInfoCmd", deleteData);
        SQLCommandExecutor.getInstance().executeCmd(commandDelBoxInfo);
        if (deleteData.getDelCount() > 0) {
            LogUtil.LogDebug(logger, "Delete Box Info Data Count : [" + deleteData.getDelCount() + "]");
        }
    }

    private void doClearPacketOff() {
        int restoreDays = SorterParams.getInstance().getRestoreDaysPacketOff();
        long restoreTime = restoreDays * 24 * 3600 * 1000;
        Timestamp deleteTime = new Timestamp(System.currentTimeMillis() - restoreTime);
        DeleteData deleteData = new DeleteData();
        deleteData.setDeleteBeforeTime(deleteTime);
        ICommand commandDelPacketOff = CommandCreator.getInstance().createCommand("DelPacketOffCmd", deleteData);
        SQLCommandExecutor.getInstance().executeCmd(commandDelPacketOff);
        if (deleteData.getDelCount() > 0) {
            LogUtil.LogDebug(logger, "Delete Packet Off Data Count : [" + deleteData.getDelCount() + "]");
        }
    }

    private void doClearPacketOn() {
        int restoreDays = SorterParams.getInstance().getRestoreDaysPacketOff();
        long restoreTime = restoreDays * 24 * 3600 * 1000;
        Timestamp deleteTime = new Timestamp(System.currentTimeMillis() - restoreTime);
        DeleteData deleteData = new DeleteData();
        deleteData.setDeleteBeforeTime(deleteTime);
        ICommand commandDelPacketOff = CommandCreator.getInstance().createCommand("DelPacketOnCmd", deleteData);
        SQLCommandExecutor.getInstance().executeCmd(commandDelPacketOff);
        if (deleteData.getDelCount() > 0) {
            LogUtil.LogDebug(logger, "Delete Packet On Data Count : [" + deleteData.getDelCount() + "]");
        }
    }

    private void doClearScannedInfo() {
        int restoreDays = SorterParams.getInstance().getRestoreDaysPacketOff();
        long restoreTime = restoreDays * 24 * 3600 * 1000;
        Timestamp deleteTime = new Timestamp(System.currentTimeMillis() - restoreTime);
        DeleteData deleteData = new DeleteData();
        deleteData.setDeleteBeforeTime(deleteTime);
        ICommand commandDelPacketOff = CommandCreator.getInstance().createCommand("DelScannedInfoCmd", deleteData);
        SQLCommandExecutor.getInstance().executeCmd(commandDelPacketOff);
        if (deleteData.getDelCount() > 0) {
            LogUtil.LogDebug(logger, "Delete Scanned Data Count : [" + deleteData.getDelCount() + "]");
        }
    }

    private void doClearSlotPack() {
        int restoreDays = SorterParams.getInstance().getRestoreDaysSlotPack();
        long restoreTime = restoreDays * 24 * 3600 * 1000;
        Timestamp deleteTime = new Timestamp(System.currentTimeMillis() - restoreTime);
        DeleteData deleteData = new DeleteData();
        deleteData.setDeleteBeforeTime(deleteTime);
        ICommand commandDelBoxInfo = CommandCreator.getInstance().createCommand("DelSlotPackCmd", deleteData);
        SQLCommandExecutor.getInstance().executeCmd(commandDelBoxInfo);
        if (deleteData.getDelCount() > 0) {
            LogUtil.LogDebug(logger, "Delete Slot Pack Data Count : [" + deleteData.getDelCount() + "]");
        }
    }
}

