/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.common.log.LogUtil;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;

public class BoxInfoAllocTask
extends Thread {
    protected static final Logger logger = Logger.getLogger(BoxInfoAllocTask.class);

    public BoxInfoAllocTask() {
        this.setName("Box-Info-Alloc-Task");
    }

    @Override
    public void run() {
        try {
            this.doAllocBoxInfoForSlot();
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void doAllocBoxInfoForSlot() throws InterruptedException {
        try {
            SlotInfo[] slotInfos;
            for (SlotInfo slotInfo : slotInfos = SlotManager.getInstance().getSlotInfoList()) {
                if (slotInfo.getAllocBoxInfo().booleanValue()) continue;
                this.doFetchBoxInfo(slotInfo);
                Thread.sleep(20L);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[BoxInfoAllocTask.doAllocBoxInfo] Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void doFetchBoxInfo(SlotInfo slotInfo) {
        Boolean res = SlotManager.getInstance().checkSlotIsTrash(slotInfo.getSlotId());
        if (res.booleanValue()) {
            return;
        }
        SlotManager.getInstance().doAllocBoxInfo(slotInfo);
    }
}

