/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.StringUtil;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatManager;
import com.simba.server.components.data.SortInfo;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class MesInfoJsonService
implements JsonService {
    public static final String NAME = "MesInfo";
    private static final Logger logger = Logger.getLogger(MesInfoJsonService.class);

    @Override
    public void handleRequest(Channel connection, Object jsonData) {
        try {
            JSONObject request = (JSONObject)jsonData;
            String type = request.getString("type");
            if (StringUtil.isNull(type).booleanValue()) {
                return;
            }
            LogUtil.LogDebug(logger, "Recv MES Scanned Msg :" + request.toString());
            this.handleManualScanned(connection, request);
        }
        catch (JSONException ex) {
            LogUtil.LogError(logger, "MES Scanned Json Request Service Error : exception info : " + ex.getMessage());
        }
    }

    private String createSlotsContent(SortInfo sortInfo) {
        String slotsContent = "";
        List<Integer> slots = sortInfo.getSlotsList();
        int slotSize = slots.size();
        for (int i = 0; i < slotSize; ++i) {
            String slotId = String.valueOf(slots.get(i));
            slotsContent = i != slotSize - 1 ? slotsContent + slotId + "," : slotsContent + slotId;
        }
        return slotsContent;
    }

    private void handleManualScanned(Channel channel, JSONObject request) {
        String platId = request.getString("platId");
        String barcode = request.getString("barcode");
        String siteCode = request.getString("siteCode");
        JSONObject scannedObj = new JSONObject();
        scannedObj.put("platId", platId);
        scannedObj.put("platMode", "3");
        scannedObj.put("barcode", barcode);
        scannedObj.put("siteCode", siteCode);
        scannedObj.put("plcId", "MES-SCANNED");
        scannedObj.put("scannedMode", "MES");
        scannedObj.put("scannedPlatType", "MANUAL");
        PlatInstance plat = PlatManager.getInstance().getPlatById(platId);
        if (plat == null) {
            this.sendErrorPlatIdResponse(channel, platId);
            return;
        }
        if (plat.getPlatMode() != 3) {
            this.sendPlatModeErrorResponse(channel, platId);
            return;
        }
        SortInfo sortInfo = plat.handleScannedCommand(channel, scannedObj);
        String slotsContent = "";
        slotsContent = sortInfo.getErrorCodeSVR() == 2 ? "\u65e0\u5206\u62e3\u65b9\u6848" : this.createSlotsContent(sortInfo);
        this.sendSuccessResponse(channel, platId, slotsContent);
    }

    private void sendErrorPlatIdResponse(Channel channel, String platId) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("ServiceName", "ToMes");
        response.put("type", "noPlat");
        response.put("message", "\u672a\u53d1\u73b0\u6b64\u4f9b\u4ef6\u53f0\uff1a" + platId);
        JSONObject jsonObject = new JSONObject(response);
        JsonChannelManager.getInstance().commitResponse(channel, jsonObject.toString().getBytes(), false);
    }

    private void sendPlatModeErrorResponse(Channel channel, String platId) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("ServiceName", "ToMes");
        response.put("type", "platModeAuto");
        response.put("message", "\u4f9b\u4ef6\u53f0\u81ea\u52a8\u6a21\u5f0f\uff1a" + platId);
        JSONObject jsonObject = new JSONObject(response);
        JsonChannelManager.getInstance().commitResponse(channel, jsonObject.toString().getBytes(), false);
    }

    private void sendSuccessResponse(Channel channel, String platId, String slots) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("ServiceName", "ToMes");
        response.put("type", "success");
        response.put("chuteCodes", slots);
        response.put("message", "MES\u8865\u7801\u6210\u529f\uff1a" + platId);
        JSONObject jsonObject = new JSONObject(response);
        JsonChannelManager.getInstance().commitResponse(channel, jsonObject.toString().getBytes(), false);
    }
}

