/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortCommonDefines;
import com.simba.server.components.SortProtocolCreator;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckTimeJsonService
implements JsonService {
    public static final String NAME = "CheckTime";
    private static final int CHECK_TIME_BUFFER_SIZE = 14;
    private static final Logger logger = Logger.getLogger(CheckTimeJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            this.sendTimeToPlc();
        }
        catch (JSONException ex) {
            LogUtil.LogError(logger, "Check Time Json Service Error : exception info : ");
        }
    }

    private void sendTimeToPlc() {
        try {
            Channel[] channels;
            byte[] replyBuffer = new byte[14];
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{17};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] timeBuffer = SortProtocolCreator.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position += command.length, timeBuffer.length);
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, position += timeBuffer.length, serialByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += serialByte.length, replayEnder.length);
            position += replayEnder.length;
            for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(channel, replyBuffer, false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "EchoTime Decode Catch Exception : " + ex.getMessage());
        }
    }
}

