/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SortProtocolCreator;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class BoxInfoClearJsonService
implements JsonService {
    public static final String NAME = "BoxInfoClear";
    private static final Logger logger = Logger.getLogger(BoxInfoClearJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            String privateKey = request.getString("privateKey");
            if (privateKey == null || !privateKey.equals(ServerManager.getInstance().getPrivatekey())) {
                this.sendPrivateKeyErrorToClient();
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("TruncateTableCmd", "tt_box_info");
            Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                this.sendSuccessInfoToClient();
            }
            Timestamp clearTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            LogUtil.LogDebug(logger, "BoxInfoClear Json Service request name : " + clearTime.toString());
        }
        catch (JSONException ex) {
            LogUtil.LogError(logger, "Dummy Json Service Error : exception info : ");
        }
    }

    private void sendPrivateKeyErrorToClient() {
    }

    private void sendSuccessInfoToClient() {
    }
}

