/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.BarcodeManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SortInfo;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SortInfoDecoder
implements Decoder {
    public static final int CAR_HAS_NO_PACKET = 0;
    public static final int CAR_HAS_PACKET = 1;
    public static final String NAME = "SortInfo";
    protected static final Logger logger = Logger.getLogger(SortInfoDecoder.class);
    private static final int BARCODE_NUMBER_POSITION = 8;
    private static final int CAR_ID_POSITION = 3;
    private static final int CAR_STATUS_POSITION = 5;
    private static final String INVALID_READ_BARCODE = "Invalid-Code";
    private static final int OBR_NUM_POSITION = 7;
    private static final int TRIGGER_STATUS_POSITION = 6;
    private static final int TRIGGER_TO_GET_SLOT = 1;

    public static SortInfoDecoder getInstance() {
        return DecoderHolder.INSTANCE;
    }

    private SortInfoDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            if (!(message instanceof byte[])) {
                return;
            }
            byte[] content = (byte[])message;
            int carIdInt = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            String carIdStr = String.valueOf(carIdInt);
            byte carStatus = content[5];
            if (carStatus != 1) {
                return;
            }
            byte trriggerStatus = content[6];
            if (trriggerStatus != 1) {
                return;
            }
            SortInfo sortInfo = SortInfoManager.getInstance().createSortInfo();
            sortInfo.setCarId(carIdStr);
            byte obr = content[7];
            if (obr != 1 && obr != 2) {
                obr = 1;
            }
            sortInfo.setObr(obr);
            int barcodeNumber = content[8];
            int barcodePosition = 9;
            String invalidBarcode = INVALID_READ_BARCODE;
            for (int i = 0; i < barcodeNumber; ++i) {
                byte barcodeLen = content[barcodePosition];
                String barcode = new String(content, ++barcodePosition, (int)barcodeLen, "UTF-8");
                if (BarcodeManager.getInstance().checkBarcodeValid(barcode).booleanValue()) {
                    sortInfo.setBarcode(barcode);
                    sortInfo.getBarcodeList().add(barcode);
                } else {
                    invalidBarcode = barcode;
                }
                barcodePosition += barcodeLen;
            }
            int plcIdLenPosition = barcodePosition;
            int plcIdPosition = plcIdLenPosition + 1;
            byte plcIdLen = content[plcIdLenPosition];
            byte[] plcIdBuffer = new byte[plcIdLen];
            System.arraycopy(content, plcIdPosition, plcIdBuffer, 0, plcIdLen);
            String plcId = "NoDefine";
            try {
                plcId = new String(plcIdBuffer, "UTF-8");
            }
            catch (Exception e) {
                plcId = "Parse-PLCID-Error";
            }
            sortInfo.setPlcId(plcId);
            int turnNumberPosition = plcIdPosition + plcIdLen;
            byte turnNumber = content[turnNumberPosition];
            sortInfo.setTurnNumber(turnNumber);
            int platIdPosition = turnNumberPosition + 1;
            byte platId = content[platIdPosition];
            sortInfo.setPlatId(String.valueOf(platId));
            BarcodeManager.getInstance().createSortInfoBarcodeList(sortInfo);
            if (sortInfo.getBarcodeList().size() == 0) {
                if (!invalidBarcode.equals(INVALID_READ_BARCODE)) {
                    sortInfo.setBarcode(invalidBarcode);
                    sortInfo.setErrorCodeSVR(18);
                } else {
                    sortInfo.setBarcode("NoRead");
                    sortInfo.getBarcodeList().add("NoRead");
                    sortInfo.setErrorCodeSVR(3);
                }
            } else if (sortInfo.getBarcodeList().size() > 1 && SorterParams.getInstance().isMultiCodeCheck()) {
                this.handleMultiBarcodes(sortInfo);
            }
            SortControllerManager.getInstance().onSortInfoMessage(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortInfoDecoder.doDecode] Do decode sort info error : " + ex.toString() + "]");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void handleMultiBarcodes(SortInfo sortInfo) {
        String barcodes = "";
        sortInfo.setErrorCodeSVR(4);
        List<String> barcodeList = sortInfo.getBarcodeList();
        for (int i = 0; i < barcodeList.size(); ++i) {
            barcodes = i < barcodeList.size() - 1 ? barcodes + barcodeList.get(i) + "," : barcodes + barcodeList.get(i);
        }
        sortInfo.setBarcode(barcodes);
    }

    public void sendSortInfoToClient(SortInfo sortInfo) {
    }

    private static class DecoderHolder {
        private static final SortInfoDecoder INSTANCE = new SortInfoDecoder();

        private DecoderHolder() {
        }
    }
}

