/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PlatManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.ISortInfoController;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class JDSortInfoController
implements ISortInfoController {
    private static final Logger logger = Logger.getLogger(JDSortInfoController.class);

    @Override
    public void onSortInfoMessage(SortInfo sortInfo) {
        try {
            if (sortInfo == null) {
                return;
            }
            sortInfo.setScannedMode("OBR");
            sortInfo.setScannedPlatType("AUTO");
            String carId = sortInfo.getCarId();
            if (carId == null || carId.equals("")) {
                return;
            }
            this.recordPackOnInfo(sortInfo);
            SortInfoManager.getInstance().addSortInfo(sortInfo);
            this.setSortInfoObrScanTime(sortInfo);
            byte[] sortResultBuffer = null;
            int errorCode = sortInfo.getErrorCodeSVR();
            if (errorCode == 4) {
                SortInfoManager.getInstance().doHandleMultiCode(sortInfo);
                this.printMultiBarcodeLog(sortInfo);
            } else if (errorCode == 3) {
                SortInfoManager.getInstance().doHandleNoRead(sortInfo);
            } else if (errorCode == 18) {
                SortInfoManager.getInstance().doHandleInvalidCode(sortInfo);
            } else {
                ICommand command = CommandCreator.getInstance().createCommand("WebSortInfoCmd", sortInfo);
                Boolean res = WebCommandExecutor.getInstance().executeCmd(command);
                if (!res.booleanValue()) {
                    this.printWebCmdErrorLog(sortInfo);
                }
                SortInfoManager.getInstance().handleSortInfoResult(sortInfo);
            }
            sortResultBuffer = SortProtocolCreator.getInstance().createSortCmdWithCarID(sortInfo);
            this.sendToPlcChannels(sortResultBuffer);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortInfoController.onSortInfoMessage] Handle Sort Info Error:" + ex.getMessage());
        }
    }

    private void printMultiBarcodeLog(SortInfo sortInfo) {
        String barcodes = "";
        List<String> barcodeList = sortInfo.getBarcodeList();
        for (int i = 0; i < barcodeList.size(); ++i) {
            barcodes = i < barcodeList.size() - 1 ? barcodes + barcodeList.get(i) + "," : barcodes + barcodeList.get(i);
        }
        LogUtil.LogError(logger, "[SortInfoController.printMultiBarcodeLog] WayBill : [" + barcodes + "] is multiBarcode.");
    }

    private void printWebCmdErrorLog(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        LogUtil.LogError(logger, "[SortInfoProcess.printWebCmdErrorLog] billCode : [" + barcode + "] errorCode : [" + sortInfo.getErrorCodeSVR() + "]");
    }

    private void recordPackOnInfo(SortInfo sortInfo) {
        String carId = sortInfo.getCarId();
        PacketOnInfo packetOnInfo = PlatManager.getInstance().getPacketOnInfo(carId);
        if (packetOnInfo != null) {
            sortInfo.setPlatId(packetOnInfo.getPlatId());
            sortInfo.setPlatMode(packetOnInfo.getPlatMode());
            packetOnInfo.setBarcode(sortInfo.getBarcode());
            packetOnInfo.setScannedMode(sortInfo.getScannedMode());
            packetOnInfo.setScannedPlatType(sortInfo.getScannedPlatType());
            PlatManager.getInstance().removePacketOnInfo(carId);
            ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOnCmd", packetOnInfo);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
    }

    private void sendToPlcChannels(byte[] sortResultBuffer) {
        try {
            Channel[] channels;
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, sortResultBuffer, false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[Method]:[sendToPlcChannels] ,[Message]:[Send sort result to plc channels error : " + ex.getMessage() + "]");
        }
    }

    private void setSortInfoObrScanTime(SortInfo sortInfo) {
        Timestamp obrScannedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
        sortInfo.setTimestampScanned(obrScannedTime);
        sortInfo.setTimeScanned(obrScannedTime.toString());
    }
}

