/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotPackController;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class JDSlotPackController
implements ISlotPackController {
    private static final Logger logger = Logger.getLogger(JDSlotPackController.class);

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo) {
        Boolean res = false;
        try {
            slotInfo.setLockStatus(1);
            SlotManager.getInstance().setSlotSoftLockStatus(slotInfo);
            SlotManager.getInstance().sendSlotSoftLockToPLC(slotInfo);
            this.printSlotPackPoint("start", slotInfo);
            res = SlotManager.getInstance().checkSlotIsTrash(slotInfo.getSlotId());
            if (res.booleanValue()) {
                return;
            }
            String boxCode = slotInfo.getBoxInfo().getBoxCode();
            if (boxCode == null || boxCode.equals("")) {
                LogUtil.LogDebug(logger, "Slot Box Code Is Null : [" + slotInfo.getSlotId() + "]");
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("FetchPacketCountCmd", slotInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "Query Packet Off Count In SlotPackProcess Failed ");
                SlotManager.getInstance().offerSlotPackToRestore(slotInfo);
                return;
            }
            if (slotInfo.getBoxInfo().getMailCount() == 0) {
                LogUtil.LogDebug(logger, "Query Packet Off Count is Zero");
                return;
            }
            Timestamp createTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            slotInfo.getBoxInfo().setCreateTime(createTime.toString());
            command = CommandCreator.getInstance().createCommand("RecordBoxPackCmd", slotInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                this.retrySlotBoxPack(slotInfo);
                LogUtil.LogDebug(logger, "Insert Slot Pack Record In JDSlotPackController Failed ");
                SlotManager.getInstance().offerSlotPackToRestore(slotInfo);
                return;
            }
            this.printSlotPackPoint("end", slotInfo);
            slotInfo.resetBoxInfo();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle JD Slot Pack Message In JDSlotPackController Error -- Exception : " + ex);
        }
    }

    private void printSlotPackPoint(String point, SlotInfo slotInfo) {
        StringBuilder boxInfoBuilder = new StringBuilder(50);
        boxInfoBuilder.append("[JDSlotPackController.onSlotPackMessage] Slot:[");
        boxInfoBuilder.append(slotInfo.getChuteCode());
        boxInfoBuilder.append("],Pack Box Code:[");
        boxInfoBuilder.append(slotInfo.getBoxInfo().getBoxCode());
        boxInfoBuilder.append("],mailCount:[");
        boxInfoBuilder.append(slotInfo.getBoxInfo().getMailCount());
        boxInfoBuilder.append("],point:[");
        boxInfoBuilder.append(point);
        boxInfoBuilder.append("]");
        LogUtil.LogDebug(logger, boxInfoBuilder.toString());
    }

    private void retrySlotBoxPack(SlotInfo slotInfo) {
    }
}

