/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortResult;
import com.simba.server.controllers.IPacketOffController;
import org.apache.log4j.Logger;

public class JDPacketOffController
implements IPacketOffController {
    private static final Logger logger = Logger.getLogger(JDPacketOffController.class);

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        try {
            this.offerSortResult(sortInfo);
            this.restorePacketOff(sortInfo);
            this.offerAddScanInfo(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle JD PacketOff Message In BestPacketOff Handler Error -- Exception : " + ex);
        }
    }

    private void offerAddScanInfo(SortInfo sortInfo) {
        try {
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String slotId = String.valueOf(droppedSlotId);
            if (SlotManager.getInstance().checkSlotIsUpload(slotId).booleanValue()) {
                ICommand command = CommandCreator.getInstance().createCommand("WebAddScanCmd", sortInfo);
                SQLCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle JD PacketOff Message In offerAddScanInfo Handler Error -- Exception : " + ex);
        }
    }

    private Boolean offerSortResult(SortInfo sortInfo) {
        Boolean ret = false;
        try {
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String slotId = String.valueOf(droppedSlotId);
            int errorCodeSVR = sortInfo.getErrorCodeSVR();
            if (errorCodeSVR > 0) {
                sortInfo.setUploadFlag(2);
                return ret;
            }
            if (SlotManager.getInstance().checkSlotIsTrash(slotId).booleanValue()) {
                return ret;
            }
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return ret;
            }
            SortResult sortResult = new SortResult();
            sortResult.setBoxCode(sortInfo.getBoxCode());
            sortResult.setSlotId(slotInfo.getSlotId());
            sortResult.getSortInfos().add(sortInfo);
            int uploadNum = sortInfo.getUploadNum() + 1;
            if (SlotManager.getInstance().checkSlotIsUpload(slotId).booleanValue()) {
                ICommand command = CommandCreator.getInstance().createCommand("WebPacketOffCmd", sortResult);
                ret = WebCommandExecutor.getInstance().executeCmd(command);
                if (ret.booleanValue()) {
                    sortInfo.setUploadFlag(1);
                } else {
                    sortInfo.setUploadFlag(0);
                }
                sortInfo.setUploadNum(uploadNum);
            } else {
                sortInfo.setUploadFlag(-1);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle JD PacketOff Message In uploadSortInfo Handler Error -- Exception : " + ex);
            ret = false;
        }
        return ret;
    }

    private void restorePacketOff(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOffCmd", sortInfo);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                ServerManager.getInstance().getDataRestoreTask().offerRestoreDataToQueue(sortInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle JD PacketOff Message In restorePacketOff Handler Error -- Exception : " + ex);
        }
    }
}

