/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.data;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.IRecordData;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class SortInfo
implements IRecordData {
    protected static final Logger logger = Logger.getLogger(SortInfo.class);
    private String barcode;
    private final List<String> barcodeList = new LinkedList<String>();
    private String boxCode;
    private String carId;
    private final List<String> chuteCodeList = new LinkedList<String>();
    private int droppedSlotId;
    private int errorCodePLC;
    private int errorCodeSVR;
    private int obr;
    private String platId;
    private String platMode;
    private String plcId;
    private String scannedMode;
    private String scannedPlatType;
    private String siteCode;
    private final List<String> siteCodeList = new LinkedList<String>();
    private int siteCodeValue;
    private int slotDistrict;
    private final List<Integer> slotsList = new LinkedList<Integer>();
    private String sortingId;
    private String sortMode;
    private int sortResultId;
    private String timePacketOff;
    private String timeScanned;
    private Timestamp timestampComplement;
    private Timestamp timestampPacketOff;
    private Timestamp timestampPacketOn;
    private Timestamp timestampScanned;
    private int turnNumber;
    private int uploadFlag;
    private int uploadNum;
    private int volume;
    private int webJDCode;
    private int weight;

    public String getBarcode() {
        return this.barcode;
    }

    public List<String> getBarcodeList() {
        return this.barcodeList;
    }

    public String getBoxCode() {
        return this.boxCode;
    }

    public String getCarId() {
        return this.carId;
    }

    public List<String> getChuteCodeList() {
        return this.chuteCodeList;
    }

    public int getDroppedSlotId() {
        return this.droppedSlotId;
    }

    public int getErrorCodePLC() {
        return this.errorCodePLC;
    }

    public int getErrorCodeSVR() {
        return this.errorCodeSVR;
    }

    public int getObr() {
        return this.obr;
    }

    public String getPlatId() {
        return this.platId;
    }

    public String getPlatMode() {
        return this.platMode;
    }

    public String getPlcId() {
        return this.plcId;
    }

    @Override
    public String getRecordDataName() {
        return "Sort-Info-Restore-Data";
    }

    public String getScannedMode() {
        return this.scannedMode;
    }

    public String getScannedPlatType() {
        return this.scannedPlatType;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public List<String> getSiteCodeList() {
        return this.siteCodeList;
    }

    public int getSiteCodeValue() {
        return this.siteCodeValue;
    }

    public int getSlotDistrict() {
        return this.slotDistrict;
    }

    public List<Integer> getSlotsList() {
        return this.slotsList;
    }

    public String getSortingId() {
        return this.sortingId;
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public int getSortResultId() {
        return this.sortResultId;
    }

    public String getTimePacketOff() {
        return this.timePacketOff;
    }

    public String getTimeScanned() {
        return this.timeScanned;
    }

    public Timestamp getTimestampComplement() {
        return this.timestampComplement;
    }

    public Timestamp getTimestampPacketOff() {
        return this.timestampPacketOff;
    }

    public Timestamp getTimestampPacketOn() {
        return this.timestampPacketOn;
    }

    public Timestamp getTimestampScanned() {
        return this.timestampScanned;
    }

    public int getTurnNumber() {
        return this.turnNumber;
    }

    public int getUploadFlag() {
        return this.uploadFlag;
    }

    public int getUploadNum() {
        return this.uploadNum;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getWebJDCode() {
        return this.webJDCode;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public void restoreData() {
        try {
            LogUtil.LogDebug(logger, "[SortInfo.restoreData] Try Restore Packet Off Again. [Barcode:" + this.barcode + "]");
            ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOffCmd", this);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Restore PacketOff Message In Sort Info Error -- Exception : " + ex);
        }
    }

    public void sendPacketOffToClient() {
        try {
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServiceName", "SortResult");
            sortInfoObj.put("droppedSlot", this.getDroppedSlotId());
            sortInfoObj.put("barcode", this.getBarcode());
            sortInfoObj.put("trunNumber", this.getTurnNumber());
            sortInfoObj.put("carId", this.getCarId());
            sortInfoObj.put("boxCode", this.getBoxCode());
            sortInfoObj.put("slotsList", this.getSlotsList());
            String sortInfoStr = sortInfoObj.toString();
            for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, sortInfoStr.getBytes(), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSortInfoToClient() {
        try {
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServiceName", "SortInfo");
            sortInfoObj.put("Barcode", this.getBarcode());
            sortInfoObj.put("trunNumber", this.getTurnNumber());
            sortInfoObj.put("carId", this.getCarId());
            sortInfoObj.put("boxCode", this.getBoxCode());
            sortInfoObj.put("slotList", this.getSlotsList());
            sortInfoObj.put("obrNumber", this.obr);
            String sortInfoStr = sortInfoObj.toString();
            for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, sortInfoStr.getBytes(), false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[Method]:[sendRequestSortIntoToRemoteLogger] ,[Message]:[sort info send to remote logger error : " + ex.getMessage() + "]");
        }
    }

    public void setBarcode(String mailBarcode) {
        this.barcode = mailBarcode;
    }

    public void setBoxCode(String boxCode) {
        this.boxCode = boxCode;
    }

    public void setCarId(String carId) {
        this.carId = carId;
    }

    public void setDroppedSlotId(int droppedSlotId) {
        this.droppedSlotId = droppedSlotId;
    }

    public void setErrorCodePLC(int errorCodePLC) {
        this.errorCodePLC = errorCodePLC;
    }

    public void setErrorCodeSVR(int errorCode) {
        this.errorCodeSVR = errorCode;
    }

    public void setObr(int obr) {
        this.obr = obr;
    }

    public void setPlatId(String providePlatId) {
        this.platId = providePlatId;
    }

    public void setPlatMode(String supplyMode) {
        this.platMode = supplyMode;
    }

    public void setPlcId(String plcId) {
        this.plcId = plcId;
    }

    public void setScannedMode(String scannedMode) {
        this.scannedMode = scannedMode;
    }

    public void setScannedPlatType(String scannedPlatType) {
        this.scannedPlatType = scannedPlatType;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public void setSiteCodeValue(int siteCodeValue) {
        this.siteCodeValue = siteCodeValue;
    }

    public void setSlotDistrict(int slotDistrict) {
        this.slotDistrict = slotDistrict;
    }

    public void setSortingId(String sortingId) {
        this.sortingId = sortingId;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
    }

    public void setSortResultId(int sortResultId) {
        this.sortResultId = sortResultId;
    }

    public void setTimePacketOff(String packetOffTime) {
        this.timePacketOff = packetOffTime;
    }

    public void setTimeScanned(String timeScanned) {
        this.timeScanned = timeScanned;
    }

    public void setTimestampComplement(Timestamp timestampComplement) {
        this.timestampComplement = timestampComplement;
    }

    public void setTimestampPacketOff(Timestamp timestampPacketOff) {
        this.timestampPacketOff = timestampPacketOff;
    }

    public void setTimestampPacketOn(Timestamp timestampPacketOn) {
        this.timestampPacketOn = timestampPacketOn;
    }

    public void setTimestampScanned(Timestamp timestampScanned) {
        this.timestampScanned = timestampScanned;
    }

    public void setTurnNumber(int turnNumberValue) {
        this.turnNumber = turnNumberValue;
    }

    public void setUploadFlag(int uploadFlag) {
        this.uploadFlag = uploadFlag;
    }

    public void setUploadNum(int uploadNum) {
        this.uploadNum = uploadNum;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setWebJDCode(int webJDCode) {
        this.webJDCode = webJDCode;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }
}

