/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.data;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.IRecordData;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SlotInfo
implements IRecordData {
    private static final Logger logger = Logger.getLogger(SlotInfo.class);
    private Boolean allocBoxInfo = false;
    private final BoxInfo boxInfo = new BoxInfo();
    private String chuteCode;
    private int lockStatus;
    private String masterPrinterId;
    private String masterPrinterIp;
    private int needUpload;
    private String slavePrinterId;
    private String slavePrinterIp;
    private int slotDistrict;
    private String slotId;

    public void cloneSlotInfo(SlotInfo toSlotInfo) {
        this.slotDistrict = toSlotInfo.getSlotDistrict();
        this.slotId = toSlotInfo.getSlotId();
        this.chuteCode = toSlotInfo.getChuteCode();
        this.needUpload = toSlotInfo.getNeedUpload();
        this.masterPrinterId = toSlotInfo.getMasterPrinterId();
        this.masterPrinterIp = toSlotInfo.getMasterPrinterIp();
        this.slavePrinterId = toSlotInfo.getSlavePrinterId();
        this.slavePrinterIp = toSlotInfo.getSlavePrinterIp();
        this.boxInfo.setBoxCode(toSlotInfo.getBoxInfo().getBoxCode());
        this.boxInfo.setBoxType(toSlotInfo.getBoxInfo().getBoxType());
        this.boxInfo.setReceiveSiteCode(toSlotInfo.getBoxInfo().getReceiveSiteCode());
        this.boxInfo.setReceiveSiteName(toSlotInfo.getBoxInfo().getReceiveSiteName());
        this.boxInfo.setCreateSiteName(toSlotInfo.getBoxInfo().getCreateSiteName());
        this.boxInfo.setMailCount(toSlotInfo.getBoxInfo().getMailCount());
        this.boxInfo.setMixBoxTypeText(toSlotInfo.getBoxInfo().getMixBoxTypeText());
        this.boxInfo.setCategoryText(toSlotInfo.getBoxInfo().getCategoryText());
        this.boxInfo.setRouter(toSlotInfo.getBoxInfo().getRouter());
        this.boxInfo.setRouterNum(toSlotInfo.getBoxInfo().getRouterNum());
        this.boxInfo.setUploadFlag(0);
        this.boxInfo.setUploadNum(0);
    }

    public Boolean getAllocBoxInfo() {
        return this.allocBoxInfo;
    }

    public BoxInfo getBoxInfo() {
        return this.boxInfo;
    }

    public String getChuteCode() {
        return this.chuteCode;
    }

    public int getLockStatus() {
        return this.lockStatus;
    }

    public String getMasterPrinterId() {
        return this.masterPrinterId;
    }

    public String getMasterPrinterIp() {
        return this.masterPrinterIp;
    }

    public int getNeedUpload() {
        return this.needUpload;
    }

    @Override
    public String getRecordDataName() {
        return "Slot-Pack-Restore-Info";
    }

    public String getSlavePrinterId() {
        return this.slavePrinterId;
    }

    public String getSlavePrinterIp() {
        return this.slavePrinterIp;
    }

    public int getSlotDistrict() {
        return this.slotDistrict;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public void resetBoxInfo() {
        this.allocBoxInfo = false;
        this.boxInfo.setId(0);
        this.boxInfo.setBoxCode("");
        this.boxInfo.setBoxType("");
        this.boxInfo.setReceiveSiteCode("");
        this.boxInfo.setReceiveSiteName("");
        this.boxInfo.setCreateSiteName("");
        this.boxInfo.setMailCount(0);
        this.boxInfo.setMixBoxTypeText("");
        this.boxInfo.setCategoryText("");
        this.boxInfo.setRouter("");
        this.boxInfo.setRouterNum("");
        this.boxInfo.setUploadFlag(0);
        this.boxInfo.setUploadNum(0);
    }

    @Override
    public void restoreData() {
        Boolean res = false;
        try {
            LogUtil.LogDebug(logger, "[SlotInfo.restoreData] Try Restore Slot Pack Again. [BoxCode:" + this.boxInfo.getBoxCode() + "]");
            res = SlotManager.getInstance().checkSlotIsTrash(this.getSlotId());
            if (res.booleanValue()) {
                return;
            }
            String boxCode = this.getBoxInfo().getBoxCode();
            if (boxCode == null || boxCode.equals("")) {
                LogUtil.LogDebug(logger, "Slot Box Code Is Null : [" + this.getSlotId() + "]");
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("FetchPacketCountCmd", this);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "Query Packet Off Count In SlotInfo Failed ");
                return;
            }
            if (this.getBoxInfo().getMailCount() == 0) {
                LogUtil.LogDebug(logger, "Query Packet Off Count is Zero");
                return;
            }
            Timestamp createTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            this.getBoxInfo().setCreateTime(createTime.toString());
            command = CommandCreator.getInstance().createCommand("RecordBoxPackCmd", this);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "Insert Slot Pack Record In SlotInfo Failed ");
                return;
            }
            this.resetBoxInfo();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle Slot Pack Message In SlotInfo Error -- Exception : " + ex);
        }
    }

    public void setAllocBoxInfo(Boolean status) {
        this.allocBoxInfo = status;
    }

    public void setChuteCode(String chuteCode) {
        this.chuteCode = chuteCode;
    }

    public void setLockStatus(int lockStatus) {
        this.lockStatus = lockStatus;
    }

    public void setMasterPrinterId(String masterPrinterId) {
        this.masterPrinterId = masterPrinterId;
    }

    public void setMasterPrinterIp(String masterPrinterIp) {
        this.masterPrinterIp = masterPrinterIp;
    }

    public void setNeedUpload(int needUpload) {
        this.needUpload = needUpload;
    }

    public void setSlavePrinterId(String slavePrinterId) {
        this.slavePrinterId = slavePrinterId;
    }

    public void setSlavePrinterIp(String slavePrinterIp) {
        this.slavePrinterIp = slavePrinterIp;
    }

    public void setSlotDistrict(int slotDistrict) {
        this.slotDistrict = slotDistrict;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }
}

