/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.MachineParams;
import com.simba.server.components.SortCommonDefines;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortResult;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class SortProtocolCreator {
    private static final Logger logger = Logger.getLogger(SortProtocolCreator.class);
    private static final int MACHINE_PARAMS_SEND_BUFFER_SIZE = 30;
    private static final byte PLAT_MODE_SCANNED = 3;
    private static final int RESET_PLAT_RRESULT_BUFFER_SIZE = 15;
    private static final int SLOT_SOFT_LOCK_CONSTANT_SIZE = 17;
    private static final int SLOT_SOFT_LOCK_STATUS_CONSTANT_SIZE = 14;
    private static final int SORT_CMD_CONSTANT_BUFFER_SIZE = 28;
    private static final int TSH_SLOTS_SEND_BUFFER_SIZE = 20;
    private final Map<Integer, String> errorCodesMap = new HashMap<Integer, String>();

    public static SortProtocolCreator getInstance() {
        return SortProtocolManagerHolder.INSTANCE;
    }

    private SortProtocolCreator() {
    }

    public String createAddScanContent(SortInfo sortInfo) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("packageCode", sortInfo.getBarcode());
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("carNo", sortInfo.getCarId());
        requestObj.put("tranceId", "000000");
        requestObj.put("supplyNo", sortInfo.getPlatId());
        String supplyType = this.addScanSupplyType(sortInfo);
        requestObj.put("supplyType", supplyType);
        String scanNo = this.addScanObrNo(sortInfo);
        requestObj.put("scanNo", scanNo);
        String chuteCode = String.valueOf(sortInfo.getDroppedSlotId());
        requestObj.put("chuteCode", chuteCode);
        requestObj.put("weight", 0);
        requestObj.put("length", 0);
        requestObj.put("width", 0);
        requestObj.put("height", 0);
        String errorCodeDesc = this.addScanExpType(sortInfo.getErrorCodePLC());
        requestObj.put("expType", errorCodeDesc);
        requestObj.put("operateTime", sortInfo.getTimePacketOff());
        return requestObj.toString();
    }

    public String createBoxInfoContent(SlotInfo slotInfo) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("chuteCode", slotInfo.getSlotId());
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("quantity", 1);
        return requestObj.toString();
    }

    public Timestamp createCurrentTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public byte[] createMachineParams() {
        byte[] replyBuffer = null;
        try {
            int bufferSize = 30;
            replyBuffer = new byte[bufferSize];
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{38};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            int maxLoopCircles = MachineParams.getInstance().getMaxLoopCircles();
            byte[] maxLoopCirclesBuf = new byte[]{(byte)maxLoopCircles};
            System.arraycopy(maxLoopCirclesBuf, 0, replyBuffer, position += command.length, maxLoopCirclesBuf.length);
            int maxScanTimes = MachineParams.getInstance().getMaxScanTimes();
            byte[] maxScanTimesBuf = new byte[]{(byte)maxScanTimes};
            System.arraycopy(maxScanTimesBuf, 0, replyBuffer, position += maxLoopCirclesBuf.length, maxScanTimesBuf.length);
            int clearMode = MachineParams.getInstance().getClearMode();
            byte[] clearModeBuf = new byte[]{(byte)clearMode};
            System.arraycopy(clearModeBuf, 0, replyBuffer, position += maxScanTimesBuf.length, clearModeBuf.length);
            int sorterMaintainSpeed = MachineParams.getInstance().getSorterSpeed();
            byte[] sorterMaintainSpeedBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, sorterMaintainSpeed, sorterMaintainSpeedBuf);
            System.arraycopy(sorterMaintainSpeedBuf, 0, replyBuffer, position += clearModeBuf.length, sorterMaintainSpeedBuf.length);
            int startWarnTime = MachineParams.getInstance().getStartWarnTime();
            byte[] startWarnTimeBuf = new byte[]{(byte)startWarnTime};
            System.arraycopy(startWarnTimeBuf, 0, replyBuffer, position += sorterMaintainSpeedBuf.length, startWarnTimeBuf.length);
            int clearStopTime = MachineParams.getInstance().getClearStopTime();
            byte[] clearStopTimeBuf = new byte[]{(byte)clearStopTime};
            System.arraycopy(clearStopTimeBuf, 0, replyBuffer, position += startWarnTimeBuf.length, clearStopTimeBuf.length);
            int clearStopCircles = MachineParams.getInstance().getClearStopCircles();
            byte[] clearStopCirclesBuf = new byte[]{(byte)clearStopCircles};
            System.arraycopy(clearStopCirclesBuf, 0, replyBuffer, position += clearStopTimeBuf.length, clearStopCirclesBuf.length);
            int noreadWarn = MachineParams.getInstance().getNoreadWarn();
            byte[] noreadWarnBuf = new byte[]{(byte)noreadWarn};
            System.arraycopy(noreadWarnBuf, 0, replyBuffer, position += clearStopCirclesBuf.length, noreadWarnBuf.length);
            int saveElecTime = MachineParams.getInstance().getSaveElecTime();
            byte[] saveElecTimeBuf = new byte[]{(byte)saveElecTime};
            System.arraycopy(saveElecTimeBuf, 0, replyBuffer, position += noreadWarnBuf.length, saveElecTimeBuf.length);
            int pidaiInterval = MachineParams.getInstance().getPidaiInterval();
            byte[] pidaiIntervalBuf = new byte[]{(byte)pidaiInterval};
            System.arraycopy(pidaiIntervalBuf, 0, replyBuffer, position += saveElecTimeBuf.length, pidaiIntervalBuf.length);
            int pidaiCheckTime = MachineParams.getInstance().getPidaiCheckTime();
            byte[] pidaiCheckTimeBuf = new byte[]{(byte)pidaiCheckTime};
            System.arraycopy(pidaiCheckTimeBuf, 0, replyBuffer, position += pidaiIntervalBuf.length, pidaiCheckTimeBuf.length);
            byte[] timeBuffer = FrameUtils.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position += pidaiCheckTimeBuf.length, timeBuffer.length);
            position += timeBuffer.length;
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, replyBuffer.length - 3, serialByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, replyBuffer.length - 2, replayEnder.length);
            int n = (position += serialByte.length) + replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortCommandManager.sendMachineParams] Create Machine Params Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public byte[] createResetPlatBuffer(int platId) {
        byte[] replyBuffer = new byte[15];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{14};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] platformId = new byte[]{(byte)platId};
        System.arraycopy(platformId, 0, replyBuffer, position += command.length, platformId.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += platformId.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public String createSlotPackContent(BoxInfo boxInfo) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("boxCode", boxInfo.getBoxCode());
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("mailCount", boxInfo.getMailCount());
        String chuteCode = boxInfo.getChuteCode();
        requestObj.put("chuteCode", Integer.parseInt(chuteCode));
        requestObj.put("boxType", boxInfo.getBoxType());
        requestObj.put("receiveSiteCode", boxInfo.getReceiveSiteCode());
        requestObj.put("createTime", boxInfo.getCreateTime());
        return requestObj.toString();
    }

    public byte[] createSlotSoftLock(int slotId) {
        int bufferLen = 17;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{18};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] slotIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotId, slotIdBuf);
        System.arraycopy(slotIdBuf, 0, replyBuffer, position += command.length, slotIdBuf.length);
        byte[] slotLockStatus = new byte[]{1};
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += slotIdBuf.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSlotSoftLockStatus(byte[] slotLockStatus) {
        int bufferLen = 14 + slotLockStatus.length;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{20};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += command.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSlotSoftUnLock(int slotId) {
        int bufferLen = 17;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{19};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] slotIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotId, slotIdBuf);
        System.arraycopy(slotIdBuf, 0, replyBuffer, position += command.length, slotIdBuf.length);
        boolean slotUnlock = false;
        byte[] slotLockStatus = new byte[]{(byte)(slotUnlock ? 1 : 0)};
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += slotIdBuf.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSortCmdWithCarID(SortInfo sortInfo) {
        int slotsNum = sortInfo.getSlotsList().size();
        int bufferLen = 28 + 2 * slotsNum;
        byte[] replyBuffer = new byte[bufferLen];
        try {
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{7};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            int carId = Integer.parseInt(sortInfo.getCarId());
            byte[] carIdBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, carId, carIdBuf);
            System.arraycopy(carIdBuf, 0, replyBuffer, position += command.length, carIdBuf.length);
            int obr = sortInfo.getObr();
            byte[] obrBuf = new byte[]{(byte)obr};
            System.arraycopy(obrBuf, 0, replyBuffer, position += carIdBuf.length, obrBuf.length);
            byte[] siteCodeBuf = new byte[2];
            int siteCodeValue = sortInfo.getSiteCodeValue();
            FrameUtils.getInstance().setShortBigEndian(0, siteCodeValue, siteCodeBuf);
            System.arraycopy(siteCodeBuf, 0, replyBuffer, position += obrBuf.length, siteCodeBuf.length);
            byte[] slotsNumBuffer = new byte[]{(byte)slotsNum};
            System.arraycopy(slotsNumBuffer, 0, replyBuffer, position += siteCodeBuf.length, slotsNumBuffer.length);
            position += slotsNumBuffer.length;
            for (int slot : sortInfo.getSlotsList()) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            int sortMode = 0;
            try {
                sortMode = Integer.parseInt(sortInfo.getSortMode());
            }
            catch (Exception e) {
                sortMode = 0;
            }
            byte[] sortModeBuf = new byte[]{(byte)sortMode};
            System.arraycopy(sortModeBuf, 0, replyBuffer, position, sortModeBuf.length);
            byte[] svrErrorCodeBuff = new byte[]{(byte)sortInfo.getErrorCodeSVR()};
            System.arraycopy(svrErrorCodeBuff, 0, replyBuffer, position += sortModeBuf.length, svrErrorCodeBuff.length);
            byte[] timeStampBuffer = this.createSystemTimeToBuffer();
            System.arraycopy(timeStampBuffer, 0, replyBuffer, position += svrErrorCodeBuff.length, timeStampBuffer.length);
            byte[] finalByte = new byte[]{1};
            System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
            position += replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortCommandManager.createSortInfoBuffer] Create Sort Info Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public byte[] createSortCmdWithPlat(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        if (barcode == null) {
            barcode = "NoneCode";
        }
        int slotsNum = sortInfo.getSlotsList().size();
        int barcodeLen = barcode.length();
        int bufferLen = 28 + barcodeLen + 2 * slotsNum;
        byte[] replyBuffer = new byte[bufferLen];
        try {
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{4};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] platId = new byte[]{(byte)Integer.parseInt(sortInfo.getPlatId())};
            System.arraycopy(platId, 0, replyBuffer, position += command.length, platId.length);
            byte[] platMode = new byte[]{3};
            System.arraycopy(platMode, 0, replyBuffer, position += platId.length, platMode.length);
            byte[] barcodeLenBuf = new byte[]{(byte)barcodeLen};
            System.arraycopy(barcodeLenBuf, 0, replyBuffer, position += platMode.length, barcodeLenBuf.length);
            byte[] barcodeBuf = barcode.getBytes();
            System.arraycopy(barcodeBuf, 0, replyBuffer, position += barcodeLenBuf.length, barcodeBuf.length);
            byte[] siteCodeBuf = new byte[2];
            int siteCodeValue = sortInfo.getSiteCodeValue();
            FrameUtils.getInstance().setShortBigEndian(0, siteCodeValue, siteCodeBuf);
            System.arraycopy(siteCodeBuf, 0, replyBuffer, position += barcodeBuf.length, siteCodeBuf.length);
            byte[] slotsNumBuf = new byte[]{(byte)slotsNum};
            System.arraycopy(slotsNumBuf, 0, replyBuffer, position += siteCodeBuf.length, slotsNumBuf.length);
            position += slotsNumBuf.length;
            for (int slot : sortInfo.getSlotsList()) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            int sortMode = 0;
            try {
                sortMode = Integer.parseInt(sortInfo.getSortMode());
            }
            catch (Exception e) {
                sortMode = 0;
            }
            byte[] sortModeBuf = new byte[]{(byte)sortMode};
            System.arraycopy(sortModeBuf, 0, replyBuffer, position, sortModeBuf.length);
            byte[] svrErrorCodeBuff = new byte[]{(byte)sortInfo.getErrorCodeSVR()};
            System.arraycopy(svrErrorCodeBuff, 0, replyBuffer, position += sortModeBuf.length, svrErrorCodeBuff.length);
            byte[] scannedTimeBuffer = this.createSystemTimeToBuffer();
            System.arraycopy(scannedTimeBuffer, 0, replyBuffer, position += svrErrorCodeBuff.length, scannedTimeBuffer.length);
            byte[] finalByte = new byte[]{1};
            System.arraycopy(finalByte, 0, replyBuffer, position += scannedTimeBuffer.length, finalByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
            position += replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortProtocolCreator.createSortInfoWithPlat] Create Sort Info Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public String createSortInfo(SortInfo sortInfo) {
        JSONObject requestObj = new JSONObject();
        ArrayList<String> barcodeList = new ArrayList<String>();
        barcodeList.add(sortInfo.getBarcode());
        requestObj.put("barCode", barcodeList);
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        return requestObj.toString();
    }

    public String createSortResult(SortResult sortResult) {
        if (sortResult == null || sortResult.getSortInfos().size() == 0) {
            return null;
        }
        JSONObject requestObj = new JSONObject();
        requestObj.put("boxCode", sortResult.getBoxCode());
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("opCode", 21);
        requestObj.put("chuteCode", sortResult.getSlotId());
        LinkedList<JSONObject> packageCodes = new LinkedList<JSONObject>();
        for (SortInfo sortInfo : sortResult.getSortInfos()) {
            JSONObject packObjs = new JSONObject();
            packObjs.put("packageCode", sortInfo.getBarcode());
            packObjs.put("createTime", sortInfo.getTimePacketOff());
            packObjs.put("weight", 0);
            packObjs.put("length", 0);
            packObjs.put("width", 0);
            packObjs.put("height", 0);
            packageCodes.add(packObjs);
        }
        requestObj.put("packageCodes", packageCodes);
        return requestObj.toString();
    }

    public byte[] createSystemTimeToBuffer() {
        byte[] timeBuffer = new byte[8];
        long now = System.currentTimeMillis();
        FrameUtils.getInstance().setLongBigEndian(0, now, timeBuffer);
        return timeBuffer;
    }

    public void doSendTshSlotsToPLC(List<Integer> tshSlots, int tshValue) {
        try {
            Channel[] channels;
            if (tshSlots == null) {
                return;
            }
            int factualSize = tshSlots.size();
            int bufferSize = 20 + 2 * factualSize;
            byte[] replyBuffer = new byte[bufferSize];
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{-16};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] tshVlaueBuf = new byte[]{(byte)tshValue};
            System.arraycopy(tshVlaueBuf, 0, replyBuffer, position += command.length, tshVlaueBuf.length);
            int slotCount = tshSlots.size();
            byte[] slotCountBuf = new byte[]{(byte)slotCount};
            System.arraycopy(slotCountBuf, 0, replyBuffer, position += tshVlaueBuf.length, slotCountBuf.length);
            position += slotCountBuf.length;
            for (int slot : tshSlots) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            byte[] timeBuffer = FrameUtils.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position, timeBuffer.length);
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, position += timeBuffer.length, serialByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += serialByte.length, replayEnder.length);
            position += replayEnder.length;
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortProtocolCreator.doSendTshSlotsToPLC] Send sort plan items error:");
        }
    }

    public void init() {
        this.initErrorCodeMap();
    }

    public void sendContentEchoToPLC(byte[] content) {
        Channel[] channels;
        if (content == null || content.length < 2) {
            return;
        }
        content[0] = 2;
        content[1] = 1;
        for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(channel, content, false);
        }
    }

    public void shutdown() {
    }

    private String addScanExpType(Integer errorCode) {
        String errorCodeDesc = "none";
        if (this.errorCodesMap.containsKey(errorCode)) {
            errorCodeDesc = this.errorCodesMap.get(errorCode);
        }
        return errorCodeDesc;
    }

    private String addScanObrNo(SortInfo sortInfo) {
        return String.valueOf(sortInfo.getObr());
    }

    private String addScanSupplyType(SortInfo sortInfo) {
        String supplyType = "none";
        String scannedMode = sortInfo.getScannedMode();
        String scannedPlatType = sortInfo.getScannedPlatType();
        if (scannedMode != null && scannedMode.equals("OBR")) {
            supplyType = "AT";
        } else if (scannedPlatType != null) {
            if (scannedPlatType.equals("auto")) {
                supplyType = "MB";
            } else if (scannedPlatType.equals("manual")) {
                supplyType = "MD";
            } else if (scannedPlatType.equals("reject")) {
                supplyType = "MJ";
            }
        }
        return supplyType;
    }

    private void initErrorCodeMap() {
        this.errorCodesMap.put(0, "SC");
        this.errorCodesMap.put(1, "DE");
        this.errorCodesMap.put(2, "ID");
        this.errorCodesMap.put(3, "NR");
        this.errorCodesMap.put(4, "MB");
        this.errorCodesMap.put(5, "MR");
        this.errorCodesMap.put(6, "UP");
        this.errorCodesMap.put(7, "MT");
        this.errorCodesMap.put(8, "IB");
        this.errorCodesMap.put(17, "MJ");
    }

    private static class SortProtocolManagerHolder {
        private static final SortProtocolCreator INSTANCE = new SortProtocolCreator();

        private SortProtocolManagerHolder() {
        }
    }
}

