/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.SortPlanItem;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SortPlanManager {
    protected static final Logger logger = Logger.getLogger(SortPlanManager.class);
    private final List<SortPlanItem> sortPlanItems = new LinkedList<SortPlanItem>();

    public static SortPlanManager getInstance() {
        return SortPlanManagerHolder.INSTANCE;
    }

    private SortPlanManager() {
    }

    public List<SortPlanItem> getSortPlanItems() {
        return this.sortPlanItems;
    }

    public void init() {
        try {
            List<SortPlanItem> sortPlanItems = SortPlanManager.getInstance().getSortPlanItems();
            sortPlanItems.clear();
            ICommand command = CommandCreator.getInstance().createCommand("WebSortPlanCmd", sortPlanItems);
            WebCommandExecutor.getInstance().executeCmd(command);
            if (sortPlanItems.size() > 0) {
                command = CommandCreator.getInstance().createCommand("TruncateTableCmd", "tt_sort_plan_info");
                SQLCommandExecutor.getInstance().executeCmd(command);
                command = CommandCreator.getInstance().createCommand("RecordSortPlanCmd", sortPlanItems);
                SQLCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortPlanManager.init] Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private static class SortPlanManagerHolder {
        private static final SortPlanManager INSTANCE = new SortPlanManager();

        private SortPlanManagerHolder() {
        }
    }
}

