/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SortInfo;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SortInfoManager {
    protected static final Logger logger = Logger.getLogger(SortInfoManager.class);
    private final ConcurrentHashMap<String, Integer> siteCodeMap = new ConcurrentHashMap();
    private final AtomicInteger siteCodeSerial = new AtomicInteger(0);
    private final ConcurrentHashMap<String, SortInfo> sortInfoList = new ConcurrentHashMap();

    public static SortInfoManager getInstance() {
        return SortManagerHolder.INSTANCE;
    }

    private SortInfoManager() {
    }

    public void addSortInfo(SortInfo sortInfo) {
        if (sortInfo != null) {
            this.sortInfoList.put(sortInfo.getCarId(), sortInfo);
        }
    }

    public void clearSiteCodeMap() {
        this.siteCodeMap.clear();
    }

    public void clearSortInfoList() {
        this.sortInfoList.clear();
    }

    public boolean containsSortInfo(String key) {
        return this.sortInfoList.containsKey(key);
    }

    public void createSiteCodeValue(SortInfo sortInfo) {
        String siteCode = sortInfo.getSiteCode();
        if (siteCode == null || siteCode.equals("")) {
            return;
        }
        int siteCodeValue = 0;
        if (this.siteCodeMap.containsKey(siteCode)) {
            siteCodeValue = this.siteCodeMap.get(siteCode);
        } else {
            siteCodeValue = this.siteCodeSerial.incrementAndGet();
            this.siteCodeMap.put(siteCode, siteCodeValue);
        }
        sortInfo.setSiteCodeValue(siteCodeValue);
    }

    public SortInfo createSortInfo() {
        SortInfo sortInfo = new SortInfo();
        sortInfo.setSortingId(this.createSortingId());
        return sortInfo;
    }

    public void doHandleInvalidCode(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getInvalidCodeTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleMultiCode(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getMultiCodeTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleNoRead(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoReadTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public SortInfo getSortInfo(String key) {
        return this.sortInfoList.get(key.toLowerCase());
    }

    public int getSortInfoCount() {
        return this.sortInfoList.size();
    }

    public SortInfo[] getSortInfoList() {
        return this.sortInfoList.values().toArray(new SortInfo[0]);
    }

    public void handleSortInfoResult(SortInfo sortInfo) {
        int errorCode = sortInfo.getErrorCodeSVR();
        switch (errorCode) {
            case 0: {
                this.doHandleSuccess(sortInfo);
                break;
            }
            case 1: {
                this.doHandleNoInfo(sortInfo);
                break;
            }
            case 2: {
                this.doHandleNoPlan(sortInfo);
                break;
            }
            case 11: {
                this.doHandleOverTime(sortInfo);
                break;
            }
            case 13: {
                this.doHandleNoInfo(sortInfo);
                break;
            }
            case 10: {
                this.doHandleParamsError(sortInfo);
                break;
            }
            case 9: {
                this.doHandleNoInfo(sortInfo);
                break;
            }
            case 15: {
                this.doHandleEXP120(sortInfo);
                break;
            }
            case 16: {
                this.doHandleEXP130(sortInfo);
                break;
            }
        }
    }

    public void postInitProcess() {
    }

    public SortInfo removeSortInfo(String key) {
        return this.sortInfoList.remove(key);
    }

    private String createSortingId() {
        UUID uuid = UUID.randomUUID();
        long now = System.currentTimeMillis();
        String timeInfo = String.valueOf(now);
        String uuidStr = uuid.toString() + "-" + timeInfo;
        return uuidStr;
    }

    private void doHandleEXP120(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getEXP120TrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleEXP130(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getEXP130TrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleNoInfo(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleNoPlan(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoPlanTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleOverTime(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getOverTimeTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleParamsError(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getJDSvrErrorTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleSuccess(SortInfo sortInfo) {
        SortInfoManager.getInstance().createSiteCodeValue(sortInfo);
    }

    private static class SortManagerHolder {
        private static final SortInfoManager INSTANCE = new SortInfoManager();

        private SortManagerHolder() {
        }
    }
}

