/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.RouteNumInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.TrashSlotInfo;
import com.simba.server.task.BoxInfoAllocTask;
import com.simba.server.task.SlotStatusTask;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotManager {
    public static final int NORMAL_SLOT_0 = 0;
    public static final int TRASH_SLOT_1_NO_INFO = 1;
    public static final int TRASH_SLOT_15_JD_SVR_EXP120 = 15;
    public static final int TRASH_SLOT_16_JD_SVR_EXP130 = 16;
    public static final int TRASH_SLOT_18_INVALID_CODE_ERROR = 18;
    public static final int TRASH_SLOT_2_NO_PLAN = 2;
    public static final int TRASH_SLOT_3_NO_READ = 3;
    public static final int TRASH_SLOT_4_MULTI_BARCODE = 4;
    public static final int TRASH_SLOT_5_MAX_CIRCLE = 5;
    public static final int TRASH_SLOT_6_LOST_PACKET = 6;
    public static final int TRASH_SLOT_7_OVER_TIME = 7;
    public static final int TRASH_SLOT_8_IBB_ERROR = 8;
    public static final int TRASH_SLOT_9_JD_SVR_INTER_ERROR = 9;
    public static final int UPLOAD_SLOT_NEED_UPLOAD_0 = 0;
    public static final int UPLOAD_SLOT_NO_NEED_UPLOAD_1 = 1;
    private static final Logger logger = Logger.getLogger(SlotManager.class);
    private final BoxInfoAllocTask boxInfoAllocTask = new BoxInfoAllocTask();
    private final List<Integer> exp120TrashSlotList = new ArrayList<Integer>();
    private final List<Integer> exp130TrashSlotList = new ArrayList<Integer>();
    private final List<Integer> ibbErrorTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> invalidCodeTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> jdSvrErrorTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> lostPackTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> maxCircleTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> multiCodeTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noInfoTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noPlanTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noReadTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> overTimeTrashSlotList = new ArrayList<Integer>();
    private final ConcurrentHashMap<String, SlotInfo> slotInfoList = new ConcurrentHashMap();
    private byte[] slotLockStatus;
    private final SlotStatusTask slotStatusTask = new SlotStatusTask();
    private final ConcurrentHashMap<String, SlotInfo> trashSlotList = new ConcurrentHashMap();

    public static SlotManager getInstance() {
        return SlotManagerHolder.INSTANCE;
    }

    private SlotManager() {
    }

    public void addSlotInfo(SlotInfo slotInfo) {
        if (slotInfo != null) {
            this.slotInfoList.put(slotInfo.getSlotId(), slotInfo);
        }
    }

    public Boolean checkSlotIsTrash(String slotId) {
        Boolean ret = false;
        if (this.trashSlotList.containsKey(slotId)) {
            ret = true;
        }
        return ret;
    }

    public Boolean checkSlotIsUpload(String slotId) {
        Boolean ret = false;
        SlotInfo slotInfo = this.slotInfoList.get(slotId);
        if (slotInfo == null) {
            return ret;
        }
        if (slotInfo.getNeedUpload() == 0) {
            ret = true;
        }
        return ret;
    }

    public void clearSlotInfoList() {
        this.slotInfoList.clear();
    }

    public boolean containsSlotInfo(String key) {
        return this.slotInfoList.containsKey(key);
    }

    public String createSlotBindUUID() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAllocBoxInfo(SlotInfo slotInfo) {
        SlotInfo slotInfo2 = slotInfo;
        synchronized (slotInfo2) {
            if (slotInfo.getAllocBoxInfo().booleanValue()) {
                slotInfo.setLockStatus(0);
                this.setSlotSoftLockStatus(slotInfo);
                this.sendSlotSoftUnLockToPLC(slotInfo);
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("WebBoxInfoCmd", slotInfo);
            Boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotManager.doAllocBoxInfo] Fetch Box Info Failed, SlotId : [" + slotInfo.getSlotId() + "]");
                slotInfo.resetBoxInfo();
            } else {
                this.doAllocAppendRouteNum(slotInfo);
                slotInfo.setAllocBoxInfo(true);
                slotInfo.setLockStatus(0);
                this.setSlotSoftLockStatus(slotInfo);
                this.sendSlotSoftUnLockToPLC(slotInfo);
                this.recordNewBoxInfo(slotInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAllocBoxInfoLocal(SlotInfo slotInfo) {
        SlotInfo slotInfo2 = slotInfo;
        synchronized (slotInfo2) {
            if (slotInfo.getAllocBoxInfo().booleanValue()) {
                slotInfo.setLockStatus(0);
                this.setSlotSoftLockStatus(slotInfo);
                this.sendSlotSoftUnLockToPLC(slotInfo);
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("FetchBoxInfoCmd", slotInfo);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotManager.doAllocBoxInfoLocal] Fetch Box Info Failed, SlotId : [" + slotInfo.getSlotId() + "]");
                slotInfo.resetBoxInfo();
            } else {
                Boolean result = this.renewLocalBoxInfoStatus(slotInfo);
                if (result.booleanValue()) {
                    this.doAllocAppendRouteNum(slotInfo);
                    slotInfo.setAllocBoxInfo(true);
                    slotInfo.setLockStatus(0);
                    this.setSlotSoftLockStatus(slotInfo);
                    this.sendSlotSoftUnLockToPLC(slotInfo);
                    LogUtil.LogDebug(logger, "[doAllocBoxInfoLocal]:BoxCode:[" + slotInfo.getBoxInfo().getBoxCode() + "],SlotId:[" + slotInfo.getSlotId() + "]");
                } else {
                    slotInfo.resetBoxInfo();
                }
            }
        }
    }

    public void doGetTrashSlots(TrashSlotInfo trashSlotInfo) {
        List<Integer> configTrashSlots;
        int trashType = trashSlotInfo.getTypeId();
        ICommand command = CommandCreator.getInstance().createCommand("FetchTrashSlotsCmd", trashSlotInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue() && (configTrashSlots = trashSlotInfo.getTrashSlots()) != null && configTrashSlots.size() > 0) {
            switch (trashType) {
                case 1: {
                    this.setNoInfoTrashSlots(configTrashSlots);
                    break;
                }
                case 2: {
                    this.setNoPlanTrashSlots(configTrashSlots);
                    break;
                }
                case 3: {
                    this.setNoReadTrashSlots(configTrashSlots);
                    break;
                }
                case 4: {
                    this.setMultiCodeTrashSlots(configTrashSlots);
                    break;
                }
                case 5: {
                    this.setMaxCircleTrashSlots(configTrashSlots);
                    break;
                }
                case 6: {
                    this.setLostPackTrashSlots(configTrashSlots);
                    break;
                }
                case 7: {
                    this.setOverTimeTrashSlots(configTrashSlots);
                    break;
                }
                case 8: {
                    this.setIBBErrorTrashSlots(configTrashSlots);
                    break;
                }
                case 9: {
                    this.setJDServerErrorTrashSlots(configTrashSlots);
                    break;
                }
                case 15: {
                    this.setEXP120TrashSlots(configTrashSlots);
                    break;
                }
                case 16: {
                    this.setEXP130TrashSlots(configTrashSlots);
                    break;
                }
                case 18: {
                    this.setInvalidCodeTrashSlots(configTrashSlots);
                    break;
                }
            }
            this.registerTrashSlot(configTrashSlots);
        }
    }

    public String getChuteCodeFromSlotId(int i) {
        String chuteCode = "CH";
        if (i < 10) {
            chuteCode = chuteCode + "00" + String.valueOf(i);
        } else if (i >= 10 && i < 100) {
            chuteCode = chuteCode + "0" + String.valueOf(i);
        } else if (i >= 100) {
            chuteCode = chuteCode + String.valueOf(i);
        }
        return chuteCode;
    }

    public List<Integer> getEXP120TrashSlots() {
        return this.exp120TrashSlotList;
    }

    public List<Integer> getEXP130TrashSlots() {
        return this.exp130TrashSlotList;
    }

    public List<Integer> getIBBErrorTrashSlots() {
        return this.ibbErrorTrashSlotList;
    }

    public List<Integer> getInvalidCodeTrashSlots() {
        return this.invalidCodeTrashSlotList;
    }

    public List<Integer> getJDSvrErrorTrashSlots() {
        return this.jdSvrErrorTrashSlotList;
    }

    public List<Integer> getLostPackTrashSlots() {
        return this.lostPackTrashSlotList;
    }

    public List<Integer> getMaxCircleTrashSlots() {
        return this.maxCircleTrashSlotList;
    }

    public List<Integer> getMultiCodeTrashSlots() {
        return this.multiCodeTrashSlotList;
    }

    public List<Integer> getNoInfoTrashSlots() {
        return this.noInfoTrashSlotList;
    }

    public List<Integer> getNoPlanTrashSlots() {
        return this.noPlanTrashSlotList;
    }

    public List<Integer> getNoReadTrashSlots() {
        return this.noReadTrashSlotList;
    }

    public List<Integer> getOverTimeTrashSlots() {
        return this.overTimeTrashSlotList;
    }

    public int getSlotIdFromChuteCode(String chuteCode) {
        String slotIdContent = chuteCode.substring(2);
        int slotIdValue = Integer.parseInt(slotIdContent);
        return slotIdValue;
    }

    public SlotInfo getSlotInfo(String key) {
        return this.slotInfoList.get(key.toLowerCase());
    }

    public int getSlotInfoCount() {
        return this.slotInfoList.size();
    }

    public SlotInfo[] getSlotInfoList() {
        return this.slotInfoList.values().toArray(new SlotInfo[0]);
    }

    public byte[] getSlotLockStatus() {
        return this.slotLockStatus;
    }

    public void init() {
        try {
            int slotSize = SorterParams.getInstance().getSlotNumber();
            this.slotLockStatus = new byte[slotSize];
            for (int i = 0; i < this.slotLockStatus.length; ++i) {
                this.slotLockStatus[i] = 1;
            }
            this.initSlotInfos();
            this.initTrashSlots();
            this.initTasks();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "init slot info  error: " + ex);
        }
    }

    public void initTrashSlots() {
        this.trashSlotList.clear();
        this.initNoInfoTrashSlot();
        this.initNoPlanTrashSlot();
        this.initNoReadTrashSlot();
        this.initMultiCodeTrashSlot();
        this.initMaxCircleTrashSlot();
        this.initLostPackTrashSlot();
        this.initOverTimeTrashSlot();
        this.initIBBTrashSlot();
        this.initJDServerTrashSlot();
        this.initEXP120TrashSlot();
        this.initEXP130TrashSlot();
        this.initInvalidCodeTrashSlot();
    }

    public void offerSlotPackToRestore(SlotInfo slotInfo) {
        try {
            SlotInfo newSlotInfo = new SlotInfo();
            newSlotInfo.cloneSlotInfo(slotInfo);
            ServerManager.getInstance().getDataRestoreTask().offerRestoreDataToQueue(newSlotInfo);
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "offer slot info to restore: " + e.getMessage());
        }
    }

    public void parseSlotFromBarcode(SortInfo sortInfo) {
        try {
            String barcode = sortInfo.getBarcode();
            String[] info = barcode.split("-");
            if (info.length < 4) {
                int errorCode = 13;
                sortInfo.setErrorCodeSVR(errorCode);
                sortInfo.getSlotsList().clear();
                sortInfo.getChuteCodeList().clear();
            } else {
                sortInfo.getSlotsList().clear();
                sortInfo.getChuteCodeList().clear();
                String slotIdKey = info[3];
                SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotIdKey);
                String boxCode = slotInfo.getBoxInfo().getBoxCode();
                if (boxCode != null && !boxCode.equals("")) {
                    sortInfo.getSlotsList().add(Integer.parseInt(slotIdKey));
                }
            }
        }
        catch (Exception e) {
            int errorCode = 13;
            sortInfo.setErrorCodeSVR(errorCode);
            sortInfo.getSlotsList().clear();
            sortInfo.getChuteCodeList().clear();
            LogUtil.LogError(logger, "parse slot from barcode error: " + e.getMessage());
        }
    }

    public void postInitProcess() {
    }

    public void printEXP120TrashSlot() {
        String info = "EXP 120 Trash slots : ";
        for (Integer trashSlot : this.exp120TrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printEXP130TrashSlot() {
        String info = "EXP 130 Trash slots : ";
        for (Integer trashSlot : this.exp130TrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printIBBTrashSlot() {
        String info = "IBB Error Trash slots : ";
        for (Integer trashSlot : this.ibbErrorTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printJDSvrErrorTrashSlot() {
        String info = "JD Server Trash slots : ";
        for (Integer trashSlot : this.jdSvrErrorTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printLostPacketTrashSlot() {
        String info = "Lost Pack Trash slots : ";
        for (Integer trashSlot : this.lostPackTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printMaxCircleTrashSlot() {
        String info = "Max Circle Trash slots : ";
        for (Integer trashSlot : this.maxCircleTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printMultiCodeTrashSlot() {
        String info = "Multi Code Trash slots : ";
        for (Integer trashSlot : this.multiCodeTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printNoInfoTrashSlot() {
        String info = " No Info Trash slots : ";
        for (Integer trashSlot : this.noInfoTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printNoPlanTrashSlot() {
        String info = "No Plan Trash slots : ";
        for (Integer trashSlot : this.noPlanTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printNoReadTrashSlot() {
        String info = "No Read Trash slots : ";
        for (Integer trashSlot : this.noReadTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printOverTimeTrashSlot() {
        String info = "Over Time Trash slots : ";
        for (Integer trashSlot : this.overTimeTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void registerTrashSlot(List<Integer> configTrashSlots) {
        for (Integer slotValue : configTrashSlots) {
            SlotInfo slotInfo;
            String slotId = String.valueOf(slotValue);
            if (this.trashSlotList.containsKey(slotId) || (slotInfo = this.slotInfoList.get(slotId)) == null) continue;
            this.trashSlotList.put(slotId, slotInfo);
        }
    }

    public void reloadTshSlots() {
        this.initTrashSlots();
    }

    public SlotInfo removeSlotInfo(String key) {
        return this.slotInfoList.remove(key);
    }

    public void sendSlotSoftLockToPLC(SlotInfo slotInfo) {
        try {
            Channel[] channels;
            byte[] replyBuffer = SortProtocolCreator.getInstance().createSlotSoftLock(Integer.parseInt(slotInfo.getSlotId()));
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSlotSoftUnLockToPLC(SlotInfo slotInfo) {
        try {
            Channel[] channels;
            byte[] replyBuffer = SortProtocolCreator.getInstance().createSlotSoftUnLock(Integer.parseInt(slotInfo.getSlotId()));
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendTshSlotsToPLC() {
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.noInfoTrashSlotList, 1);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.noPlanTrashSlotList, 2);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.noReadTrashSlotList, 3);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.multiCodeTrashSlotList, 4);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.maxCircleTrashSlotList, 5);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.lostPackTrashSlotList, 6);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.overTimeTrashSlotList, 7);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.ibbErrorTrashSlotList, 8);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.jdSvrErrorTrashSlotList, 9);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.exp120TrashSlotList, 15);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.exp130TrashSlotList, 16);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.invalidCodeTrashSlotList, 18);
    }

    public void setSlotSoftLockStatus(SlotInfo slotInfo) {
        try {
            int slotIndex = Integer.parseInt(slotInfo.getSlotId()) - 1;
            int softLockStatus = slotInfo.getLockStatus();
            if (this.slotLockStatus == null || this.slotLockStatus.length <= slotIndex) {
                return;
            }
            this.slotLockStatus[slotIndex] = (byte)softLockStatus;
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "Update Slot Soft Lock Status Error.");
        }
    }

    private void doAllocAppendRouteNum(SlotInfo slotInfo) {
        try {
            String slotId = slotInfo.getSlotId();
            RouteNumInfo routeNumInfo = new RouteNumInfo();
            routeNumInfo.setAppendInfo(slotId);
            routeNumInfo.setRouteNum("");
            ICommand command = CommandCreator.getInstance().createCommand("FetchRouteNumCmd", routeNumInfo);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            String routerNum = routeNumInfo.getRouteNum();
            if (ret.booleanValue() && !routeNumInfo.getRouteNum().equals("")) {
                slotInfo.getBoxInfo().setRouterNum(routerNum);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "Alloc Slot Info Route Num Error : " + e.getMessage());
        }
    }

    private void initEXP120TrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(15);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initEXP130TrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(16);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initIBBTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(8);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initInvalidCodeTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(18);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initJDServerTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(9);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initLostPackTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(6);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initMaxCircleTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(5);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initMultiCodeTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(4);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initNoInfoTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(1);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initNoPlanTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(2);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initNoReadTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(3);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initOverTimeTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(7);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initSlotInfos() {
        this.slotInfoList.clear();
        LinkedList slots = new LinkedList();
        ICommand command = CommandCreator.getInstance().createCommand("FetchSlotInfoCmd", slots);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue()) {
            for (SlotInfo slotInfo : slots) {
                slotInfo.resetBoxInfo();
                this.slotInfoList.put(slotInfo.getSlotId(), slotInfo);
            }
        }
        this.printSlotInfos();
    }

    private void initTasks() {
        this.boxInfoAllocTask.start();
        this.slotStatusTask.start();
    }

    private void printSlotInfos() {
        String info = "[SlotManager.initSlotInfos] Current slot number : [" + this.slotInfoList.size() + "]";
        LogUtil.LogDebug(logger, info);
    }

    private void recordNewBoxInfo(SlotInfo slotInfo) {
        LinkedList<BoxInfo> boxInfos = new LinkedList<BoxInfo>();
        boxInfos.add(slotInfo.getBoxInfo());
        ICommand command = CommandCreator.getInstance().createCommand("RecordBoxInfoCmd", boxInfos);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private Boolean renewLocalBoxInfoStatus(SlotInfo slotInfo) {
        Boolean ret = false;
        try {
            BoxInfo boxInfo = slotInfo.getBoxInfo();
            ICommand command = CommandCreator.getInstance().createCommand("RenewBoxInfoCmd", boxInfo);
            ret = SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private void setEXP120TrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.exp120TrashSlotList.clear();
        this.exp120TrashSlotList.addAll(configTrashSlots);
    }

    private void setEXP130TrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.exp130TrashSlotList.clear();
        this.exp130TrashSlotList.addAll(configTrashSlots);
    }

    private void setIBBErrorTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.ibbErrorTrashSlotList.clear();
        this.ibbErrorTrashSlotList.addAll(configTrashSlots);
    }

    private void setInvalidCodeTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.invalidCodeTrashSlotList.clear();
        this.invalidCodeTrashSlotList.addAll(configTrashSlots);
    }

    private void setJDServerErrorTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.jdSvrErrorTrashSlotList.clear();
        this.jdSvrErrorTrashSlotList.addAll(configTrashSlots);
    }

    private void setLostPackTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.lostPackTrashSlotList.clear();
        this.lostPackTrashSlotList.addAll(configTrashSlots);
    }

    private void setMaxCircleTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.maxCircleTrashSlotList.clear();
        this.maxCircleTrashSlotList.addAll(configTrashSlots);
    }

    private void setMultiCodeTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.multiCodeTrashSlotList.clear();
        this.multiCodeTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoInfoTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noInfoTrashSlotList.clear();
        this.noInfoTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoPlanTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noPlanTrashSlotList.clear();
        this.noPlanTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoReadTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noReadTrashSlotList.clear();
        this.noReadTrashSlotList.addAll(configTrashSlots);
    }

    private void setOverTimeTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.overTimeTrashSlotList.clear();
        this.overTimeTrashSlotList.addAll(configTrashSlots);
    }

    private static class SlotManagerHolder {
        private static final SlotManager INSTANCE = new SlotManager();

        private SlotManagerHolder() {
        }
    }
}

